/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;

public class EJBArchiveMetaDataAdapterEJB3 {
    private static Logger log = Logger.getLogger(EJBArchiveMetaDataAdapterEJB3.class);
    public static final String DEPLOYED_OBJECT = "org.jboss.ws.ejb3.deployed.object";

    public EJBArchiveMetaData buildUnifiedApplicationMetaData(Deployment dep) {
        EJBArchiveMetaData appMetaData = null;
        ObjectName oname = (ObjectName)dep.getProperty(DEPLOYED_OBJECT);
        if (oname != null && oname.getDomain().equals("jboss.j2ee") && "EJB3".equals(oname.getKeyProperty("service"))) {
            appMetaData = new EJBArchiveMetaData();
            Ejb3ModuleMBean ejb3Module = EJBArchiveMetaDataAdapterEJB3.getEJB3Module(oname);
            ArrayList<Object> beans = new ArrayList<Object>();
            for (Object container : ejb3Module.getContainers().values()) {
                ActivationConfigPropertyMetaData destProp;
                if (container instanceof StatelessContainer) {
                    StatelessContainer slc = (StatelessContainer)container;
                    SLSBMetaData usmd = new SLSBMetaData();
                    usmd.setEjbName(slc.getEjbName());
                    usmd.setEjbClass(slc.getBeanClassName());
                    beans.add(usmd);
                    this.buildWebServiceMetaData(appMetaData, (EJBContainer)slc);
                    continue;
                }
                if (!(container instanceof MessagingContainer)) continue;
                MessagingContainer mdb = (MessagingContainer)container;
                MDBMetaData umdb = new MDBMetaData();
                umdb.setEjbName(mdb.getEjbName());
                umdb.setEjbClass(mdb.getBeanClassName());
                Map props = mdb.getActivationConfigProperties();
                if (props != null && (destProp = (ActivationConfigPropertyMetaData)props.get("destination")) != null) {
                    String destination = destProp.getValue();
                    umdb.setDestinationJndiName(destination);
                }
                beans.add(umdb);
                this.buildWebServiceMetaData(appMetaData, (EJBContainer)mdb);
            }
            appMetaData.setEnterpriseBeans(beans);
        }
        return appMetaData;
    }

    private void buildWebServiceMetaData(EJBArchiveMetaData appMetaData, EJBContainer container) {
        WebContext webContext = (WebContext)container.resolveAnnotation(WebContext.class);
        if (webContext != null) {
            appMetaData.setWebServiceContextRoot(webContext.contextRoot());
        }
    }

    static Ejb3ModuleMBean getEJB3Module(ObjectName objectName) {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            Ejb3ModuleMBean ejb3Module = (Ejb3ModuleMBean)MBeanProxy.get(Ejb3ModuleMBean.class, (ObjectName)objectName, (MBeanServer)server);
            if (ejb3Module == null) {
                throw new WSFDeploymentException("Cannot obtain EJB3 module: " + objectName);
            }
            return ejb3Module;
        }
        catch (MBeanProxyCreationException ex) {
            throw new WSFDeploymentException("Cannot obtain proxy to EJB3 module");
        }
    }
}

