/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.iiop;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.LocalId;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.XidImpl;
import org.jboss.tm.iiop.CoordinatorExt;
import org.jboss.tm.iiop.CoordinatorExtHelper;
import org.jboss.tm.iiop.TransactionDesc;
import org.jboss.tm.iiop.TransactionFactoryExtHelper;
import org.jboss.tm.iiop.TransactionId;
import org.jboss.tm.iiop.TransactionServicePOA;
import org.jboss.util.UnreachableStatementException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;

public class TransactionServiceImpl
extends TransactionServicePOA {
    private static final Logger log = Logger.getLogger(TransactionServiceImpl.class);
    private static final byte CONTROL = 67;
    private static final byte COORDINATOR = 99;
    private static final byte TX_FACTORY = 70;
    private static final byte TERMINATOR = 116;
    private static final String[] controlInterfaceIds = new String[]{ControlHelper.id()};
    private static final String[] coordinatorInterfaceIds = new String[]{CoordinatorExtHelper.id(), CoordinatorHelper.id()};
    private static final String[] txFactoryInterfaceIds = new String[]{TransactionFactoryExtHelper.id(), TransactionFactoryHelper.id()};
    private static final String[] terminatorInterfaceIds = new String[]{TerminatorHelper.id()};
    private static TransactionManager tm;
    private static TransactionPropagationContextImporter tpcImporter;
    private ORB orb;
    private POA poa;
    private Current poaCurrent;

    static byte[] theFactoryId() {
        return new byte[]{70};
    }

    TransactionServiceImpl(ORB orb, POA poa) {
        this.orb = orb;
        this.poa = poa;
        try {
            Object obj = orb.resolve_initial_references("POACurrent");
            this.poaCurrent = CurrentHelper.narrow((Object)obj);
        }
        catch (InvalidName e) {
            log.warn((java.lang.Object)"Call to resolve_initial_references failed: ", (Throwable)e);
            throw new RuntimeException("Call to resolve_initial_references failed: " + (java.lang.Object)((java.lang.Object)e));
        }
        catch (BAD_PARAM e) {
            log.warn((java.lang.Object)"Call to narrow failed: ", (Throwable)e);
            throw new RuntimeException("Call to narrow failed: " + (java.lang.Object)((java.lang.Object)e));
        }
    }

    public String[] _all_interfaces(POA poa, byte[] oid) {
        if (oid[0] == 70) {
            return txFactoryInterfaceIds;
        }
        if (oid[0] == 67) {
            return controlInterfaceIds;
        }
        if (oid[0] == 99) {
            return coordinatorInterfaceIds;
        }
        if (oid[0] == 116) {
            return terminatorInterfaceIds;
        }
        throw new BAD_PARAM("Unknown CORBA object id");
    }

    public TransactionDesc create_transaction(int timeout) {
        this.checkInvocationTarget(70);
        try {
            TransactionManager tm = TransactionServiceImpl.getTransactionManager();
            if (timeout != 0) {
                tm.setTransactionTimeout(timeout);
            }
            tm.begin();
            TransactionImpl tx = (TransactionImpl)tm.suspend();
            XidImpl xid = tx.getXid();
            long localId = xid.getLocalIdValue();
            byte[] oid = new byte[9];
            oid[0] = 99;
            LocalId.toByteArray((long)localId, (byte[])oid, (int)1);
            Coordinator coord = CoordinatorHelper.narrow((Object)this.poa.create_reference_with_id(oid, CoordinatorHelper.id()));
            oid[0] = 116;
            Terminator term = TerminatorHelper.narrow((Object)this.poa.create_reference_with_id(oid, TerminatorHelper.id()));
            PropagationContext pc = new PropagationContext();
            pc.current = TransactionServiceImpl.createTransIdentity((Xid)xid, coord, term);
            pc.timeout = timeout;
            pc.parents = new TransIdentity[0];
            pc.implementation_specific_data = this.orb.create_any();
            TransactionDesc td = new TransactionDesc();
            td.control = ControlHelper.narrow((Object)this.poa.create_reference_with_id(oid, ControlHelper.id()));
            td.propagationContext = pc;
            return td;
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
        catch (NotSupportedException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new BAD_INV_ORDER(e.toString());
        }
    }

    public Control create(int timeout) {
        this.checkInvocationTarget(70);
        try {
            TransactionManager tm = TransactionServiceImpl.getTransactionManager();
            if (timeout != 0) {
                tm.setTransactionTimeout(timeout);
            }
            tm.begin();
            TransactionImpl tx = (TransactionImpl)tm.suspend();
            XidImpl xid = tx.getXid();
            long localId = xid.getLocalIdValue();
            byte[] oid = new byte[9];
            oid[0] = 67;
            LocalId.toByteArray((long)localId, (byte[])oid, (int)1);
            return ControlHelper.narrow((Object)this.poa.create_reference_with_id(oid, ControlHelper.id()));
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
        catch (NotSupportedException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new BAD_INV_ORDER(e.toString());
        }
    }

    public Control recreate(PropagationContext pc) {
        this.checkInvocationTarget(70);
        log.trace((java.lang.Object)"Operation recreate is not implemented");
        throw new NO_IMPLEMENT("recreate not implemented");
    }

    public Terminator get_terminator() throws Unavailable {
        byte[] oid = this.getTargetId();
        if (oid[0] != 67) {
            throw new BAD_OPERATION();
        }
        oid[0] = 116;
        return TerminatorHelper.narrow((Object)this.poa.create_reference_with_id(oid, TerminatorHelper.id()));
    }

    public Coordinator get_coordinator() throws Unavailable {
        byte[] oid = this.getTargetId();
        if (oid[0] != 67) {
            throw new BAD_OPERATION();
        }
        oid[0] = 99;
        return CoordinatorHelper.narrow((Object)this.poa.create_reference_with_id(oid, CoordinatorHelper.id()));
    }

    public void commit(boolean reportHeuristics) throws HeuristicHazard, HeuristicMixed {
        byte[] oid = this.getTargetId();
        if (oid[0] != 116) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        Transaction tx = TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in commit: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        TransactionManager tm = TransactionServiceImpl.getTransactionManager();
        try {
            tm.resume(tx);
            tm.commit();
        }
        catch (RollbackException e) {
            log.trace((java.lang.Object)"Exception: ", (Throwable)e);
            throw new TRANSACTION_ROLLEDBACK(e.toString());
        }
        catch (HeuristicMixedException e) {
            log.trace((java.lang.Object)"Exception: ", (Throwable)e);
            if (reportHeuristics) {
                throw new HeuristicMixed(e.toString());
            }
        }
        catch (HeuristicRollbackException e) {
            log.trace((java.lang.Object)"Exception: ", (Throwable)e);
            if (reportHeuristics) {
                throw new HeuristicHazard(e.toString());
            }
        }
        catch (InvalidTransactionException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new INVALID_TRANSACTION(e.toString());
        }
        catch (IllegalStateException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new BAD_INV_ORDER(e.toString());
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
        catch (SecurityException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new NO_PERMISSION(e.toString());
        }
    }

    public void rollback() {
        byte[] oid = this.getTargetId();
        if (oid[0] != 116) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        Transaction tx = TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in rollback: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        TransactionManager tm = TransactionServiceImpl.getTransactionManager();
        try {
            tm.resume(tx);
            tm.rollback();
        }
        catch (InvalidTransactionException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new INVALID_TRANSACTION(e.toString());
        }
        catch (IllegalStateException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new BAD_INV_ORDER(e.toString());
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
        catch (SecurityException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new NO_PERMISSION(e.toString());
        }
    }

    public TransactionId get_transaction_id() {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        TransactionImpl tx = (TransactionImpl)TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in get_transaction_id: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        XidImpl xid = tx.getXid();
        return new TransactionId(xid.getFormatId(), xid.getGlobalTransactionId());
    }

    public Status get_status() {
        int status;
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        Transaction tx = TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in get_status: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
        return TransactionServiceImpl.javaxToCosTransactions(status);
    }

    public Status get_parent_status() {
        return this.get_status();
    }

    public Status get_top_level_status() {
        return this.get_status();
    }

    public boolean is_same_transaction(Coordinator other) {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        TransactionImpl tx = (TransactionImpl)TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in is_same_transaction: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        XidImpl xid = tx.getXid();
        try {
            CoordinatorExt otherExt = CoordinatorExtHelper.narrow((Object)other);
            TransactionId otherId = otherExt.get_transaction_id();
            return TransactionServiceImpl.compare((Xid)xid, otherId.formatId, otherId.globalId, otherId.globalId.length);
        }
        catch (BAD_PARAM e) {
            try {
                otid_t otherOtid = other.get_txcontext().current.otid;
                return TransactionServiceImpl.compare((Xid)xid, otherOtid.formatID, otherOtid.tid, otherOtid.tid.length - otherOtid.bqual_length);
            }
            catch (Unavailable u) {
                log.trace((java.lang.Object)"Foreign Coordinator do not support get_txcontext(): ", (Throwable)e);
                throw new BAD_PARAM(e.toString());
            }
        }
    }

    public boolean is_ancestor_transaction(Coordinator other) {
        return this.is_same_transaction(other);
    }

    public boolean is_descendant_transaction(Coordinator other) {
        return this.is_same_transaction(other);
    }

    public boolean is_related_transaction(Coordinator other) {
        return this.is_same_transaction(other);
    }

    public boolean is_top_level_transaction() {
        this.checkInvocationTarget(99);
        return true;
    }

    public int hash_transaction() {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        TransactionImpl tx = (TransactionImpl)TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in is_same_transaction: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        return tx.getXid().hashCode();
    }

    public int hash_top_level_tran() {
        return this.hash_transaction();
    }

    public RecoveryCoordinator register_resource(Resource r) throws Inactive {
        this.checkInvocationTarget(99);
        throw new NO_IMPLEMENT("Two-phase commit is not supported.");
    }

    public void register_synchronization(final Synchronization sync) throws SynchronizationUnavailable, Inactive {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        Transaction tx = TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in register_synchronization: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        try {
            tx.registerSynchronization(new javax.transaction.Synchronization(){

                public void beforeCompletion() {
                    sync.before_completion();
                }

                public void afterCompletion(int status) {
                    sync.after_completion(TransactionServiceImpl.javaxToCosTransactions(status));
                }
            });
        }
        catch (RollbackException e) {
            log.trace((java.lang.Object)"Exception: ", (Throwable)e);
            throw new TRANSACTION_ROLLEDBACK(e.toString());
        }
        catch (IllegalStateException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new BAD_INV_ORDER(e.toString());
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws NotSubtransaction, Inactive {
        this.checkInvocationTarget(99);
        throw new NotSubtransaction("Nested transactions are not supported");
    }

    public void rollback_only() throws Inactive {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        Transaction tx = TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in rollback_only: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        try {
            tx.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new BAD_INV_ORDER(e.toString());
        }
        catch (SystemException e) {
            log.trace((java.lang.Object)"Unexpected exception: ", (Throwable)e);
            throw new UNKNOWN(e.toString());
        }
    }

    public String get_transaction_name() {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        Transaction tx = TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in get_transaction_name: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        return tx.toString();
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        this.checkInvocationTarget(99);
        throw new SubtransactionsUnavailable("Nested transactions are not supported");
    }

    public PropagationContext get_txcontext() throws Unavailable {
        byte[] oid = this.getTargetId();
        if (oid[0] != 99) {
            throw new BAD_OPERATION();
        }
        long localIdValue = LocalId.fromByteArray((byte[])oid, (int)1);
        LocalId localId = new LocalId(localIdValue);
        TransactionImpl tx = (TransactionImpl)TransactionServiceImpl.getTransaction(localId);
        if (tx == null) {
            log.trace((java.lang.Object)"RuntimeException in get_txcontext: transaction not found");
            throw new OBJECT_NOT_EXIST("No transaction.");
        }
        XidImpl xid = tx.getXid();
        Coordinator coord = CoordinatorHelper.narrow((Object)this.poa.create_reference_with_id(oid, CoordinatorHelper.id()));
        PropagationContext pc = new PropagationContext();
        pc.current = TransactionServiceImpl.createTransIdentity((Xid)xid, coord, null);
        try {
            pc.timeout = TransactionServiceImpl.divideAndRoundUp(tx.getTimeLeftBeforeTimeout(false), 1000L);
        }
        catch (RollbackException e) {
            throw new UnreachableStatementException();
        }
        pc.parents = new TransIdentity[0];
        pc.implementation_specific_data = this.orb.create_any();
        return pc;
    }

    protected static TransactionManager getTransactionManager() {
        if (tm == null) {
            try {
                InitialContext ctx = new InitialContext();
                tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            }
            catch (NamingException ex) {
                log.error((java.lang.Object)"java:/TransactionManager lookup failed", (Throwable)ex);
            }
        }
        return tm;
    }

    protected static TransactionPropagationContextImporter getTPCImporter() {
        if (tpcImporter == null) {
            try {
                InitialContext ctx = new InitialContext();
                tpcImporter = (TransactionPropagationContextImporter)ctx.lookup("java:/TransactionPropagationContextImporter");
            }
            catch (NamingException ex) {
                log.error((java.lang.Object)"java:/TransactionPropagationContextImporter lookup failed", (Throwable)ex);
            }
        }
        return tpcImporter;
    }

    private static Transaction getTransaction(LocalId localId) {
        return TransactionServiceImpl.getTPCImporter().importTransactionPropagationContext((java.lang.Object)localId);
    }

    private byte[] getTargetId() {
        byte[] id = null;
        try {
            id = this.poaCurrent.get_object_id();
        }
        catch (NoContext e) {
            log.trace((java.lang.Object)("Unexpected exception: " + (java.lang.Object)((java.lang.Object)e)));
            throw new RuntimeException("Unexpected exception: " + (java.lang.Object)((java.lang.Object)e));
        }
        return id;
    }

    private void checkInvocationTarget(int targetType) {
        if (this.getTargetId()[0] != targetType) {
            throw new BAD_OPERATION();
        }
    }

    private static TransIdentity createTransIdentity(Xid xid, Coordinator coord, Terminator term) {
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        byte[] trid = new byte[gtrid.length + bqual.length];
        System.arraycopy(gtrid, 0, trid, 0, gtrid.length);
        System.arraycopy(bqual, 0, trid, gtrid.length, bqual.length);
        TransIdentity ti = new TransIdentity();
        ti.coord = coord;
        ti.term = term;
        ti.otid = new otid_t(xid.getFormatId(), bqual.length, trid);
        return ti;
    }

    private static int divideAndRoundUp(long m, long n) {
        long retval = m / n;
        if (m % n != 0L) {
            ++retval;
        }
        return (int)retval;
    }

    private static Status javaxToCosTransactions(int status) {
        switch (status) {
            case 0: {
                return Status.StatusActive;
            }
            case 3: {
                return Status.StatusCommitted;
            }
            case 8: {
                return Status.StatusCommitting;
            }
            case 1: {
                return Status.StatusMarkedRollback;
            }
            case 6: {
                return Status.StatusNoTransaction;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 7: {
                return Status.StatusPreparing;
            }
            case 4: {
                return Status.StatusRolledBack;
            }
            case 9: {
                return Status.StatusRollingBack;
            }
            case 5: {
                return Status.StatusUnknown;
            }
        }
        log.trace((java.lang.Object)"Invalid transaction status.");
        return Status.StatusUnknown;
    }

    private static boolean compare(Xid xid, int otherFormatId, byte[] otherGlobalId, int otherLength) {
        if (xid.getFormatId() != otherFormatId) {
            return false;
        }
        byte[] globalId = xid.getGlobalTransactionId();
        int len = globalId.length;
        if (len != otherLength) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (globalId[i] == otherGlobalId[i]) continue;
            return false;
        }
        return true;
    }
}

