/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxDeploymentScopeImpl
implements DeploymentScope {
    private ConcurrentHashMap<String, Ejb3Deployment> deployments = new ConcurrentHashMap();
    private String shortName;
    private String baseName;

    public JmxDeploymentScopeImpl(String shortName) {
        this.shortName = shortName;
        int idx = shortName.lastIndexOf(46);
        this.baseName = shortName.substring(0, idx);
    }

    @Override
    public Collection<Ejb3Deployment> getEjbDeployments() {
        return this.deployments.values();
    }

    @Override
    public void register(Ejb3Deployment deployment) {
        this.deployments.put(deployment.getDeploymentUnit().getShortName(), deployment);
    }

    @Override
    public void unregister(Ejb3Deployment deployment) {
        this.deployments.remove(deployment.getDeploymentUnit().getShortName());
    }

    @Override
    public Ejb3Deployment findRelativeDeployment(String relativeName) {
        String relativeShortName = relativeName.substring(3);
        return this.deployments.get(relativeShortName);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }
}

