/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.context;

import com.dsoft.framework.client.context.ClientContext;
import com.dsoft.framework.client.context.ClientContextImpl;
import java.beans.Beans;
import java.util.Locale;
import java.util.Map;

public abstract class ClientContextFactory {
    private static ClientContextFactory factory = null;
    private static final String ORIGINAL_CONTEXT = "ORIGINAL_CONTEXT";

    protected abstract ClientContext getClientContextInstance();

    public static synchronized void setClientContextFactory(ClientContextFactory factory) {
        if (ClientContextFactory.factory == null) {
            ClientContextFactory.factory = factory;
        }
    }

    protected abstract void activateClientContextInstance(ClientContext var1);

    protected abstract void deactivateClientContextInstance();

    private static ClientContextFactory getFactory() throws InterruptedException {
        while (factory == null) {
            if (Beans.isDesignTime()) {
                factory = new DesignTimeClientContextFactory(Locale.getDefault());
                continue;
            }
            Thread.sleep(100L);
        }
        return factory;
    }

    public static void activateContext(ClientContext context) {
        try {
            ClientContextFactory.getFactory().activateClientContextInstance(context);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void deactivateContext() {
        try {
            ClientContextFactory.getFactory().deactivateClientContextInstance();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ClientContext getClientContext() {
        try {
            return ClientContextFactory.getFactory().getClientContextInstance();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPushed() throws InterruptedException {
        Map<Object, Object> valueMap;
        Map<Object, Object> map = valueMap = ClientContextFactory.getClientContext().getContextValueMap();
        synchronized (map) {
            return valueMap.containsKey(ORIGINAL_CONTEXT);
        }
    }

    public static ClientContext pushContext() {
        ClientContextImpl context;
        ClientContext originalContext = ClientContextFactory.getClientContext();
        if (originalContext != null) {
            context = new ClientContextImpl(originalContext);
            context.setContextValue(ORIGINAL_CONTEXT, originalContext);
        } else {
            context = new ClientContextImpl();
        }
        ClientContextFactory.activateContext(context);
        return context;
    }

    public static ClientContext popContext() {
        ClientContext originalContext = (ClientContext)ClientContextFactory.getClientContext().getContextValue(ORIGINAL_CONTEXT);
        if (originalContext != null) {
            ClientContextFactory.activateContext(originalContext);
        }
        return ClientContextFactory.getClientContext();
    }

    public static class DesignTimeClientContextFactory
    extends ClientContextFactory {
        private ClientContext context = new ClientContextImpl();

        public DesignTimeClientContextFactory(Locale locale) {
            this.context.setLocale(locale);
        }

        @Override
        protected synchronized ClientContext getClientContextInstance() {
            return this.context;
        }

        @Override
        protected void activateClientContextInstance(ClientContext context) {
            this.context = context;
        }

        @Override
        protected void deactivateClientContextInstance() {
        }
    }
}

