/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.context;

import com.dsoft.framework.client.context.ClientContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jms.Queue;

public class ClientContextImpl
implements ClientContext {
    private final Map<Object, Object> contextValueMap = new HashMap<Object, Object>();
    private static final String ACCOUNT = "ACCOUNT";
    private static final String WORKPLACE = "WORKPLACE";
    private static final String LOCALE_LANGUAGE = "LOCALE.LANGUAGE";
    private static final String LOCALE_COUNTRY = "LOCALE.COUNTRY";
    private static final String LOCALE_VARIANT = "LOCALE.VARIANT";
    private transient Locale locale;
    private int instanceHash = (this.getClass().getName() + "@" + Integer.toHexString(super.hashCode())).hashCode();
    protected static final String REPORT_QUEUE = "REPORT_QUEUE";

    public boolean equals(Object obj) {
        return obj instanceof ClientContext && this.contextValueMap.equals(((ClientContext)obj).getContextValueMap());
    }

    @Override
    public Set<Object> getKeysSet() {
        return new HashSet<Object>(this.contextValueMap.keySet());
    }

    public int hashCode() {
        return this.instanceHash;
    }

    protected ClientContextImpl(ClientContext originalContext) {
        this();
        this.contextValueMap.putAll(originalContext.getContextValueMap());
        this.locale = originalContext.getLocale();
    }

    public ClientContextImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<Object, Object> map = this.contextValueMap;
        synchronized (map) {
            this.contextValueMap.clear();
        }
    }

    @Override
    public void setReportQueue(Queue reportQueue) {
        this.setContextValue(REPORT_QUEUE, reportQueue);
    }

    @Override
    public Queue getReportQueue() {
        return (Queue)this.getContextValue(REPORT_QUEUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContextValue(Object key, Object value) {
        Map<Object, Object> map = this.contextValueMap;
        synchronized (map) {
            if (value != null) {
                this.contextValueMap.put(key, value);
            } else {
                this.contextValueMap.remove(key);
            }
        }
    }

    @Override
    public <T> T getContextValue(Object key) {
        return (T)this.contextValueMap.get(key);
    }

    @Override
    public <T> T getContextValue(Object key, T defaultValue) {
        Object result = this.contextValueMap.get(key);
        if (result == null) {
            return defaultValue;
        }
        return (T)result;
    }

    @Override
    public void removeContextValue(Object key) {
        this.contextValueMap.remove(key);
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            if (this.contextValueMap.containsKey(LOCALE_LANGUAGE)) {
                this.locale = new Locale((String)this.contextValueMap.get(LOCALE_LANGUAGE), (String)this.contextValueMap.get(LOCALE_COUNTRY), (String)this.contextValueMap.get(LOCALE_VARIANT));
            } else {
                return Locale.getDefault();
            }
        }
        return this.locale;
    }

    @Override
    public Map<Object, Object> getContextValueMap() {
        return this.contextValueMap;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.setContextValue(LOCALE_LANGUAGE, locale.getLanguage());
        this.setContextValue(LOCALE_COUNTRY, locale.getCountry());
        this.setContextValue(LOCALE_VARIANT, locale.getVariant());
        this.locale = locale;
    }

    @Override
    public void setAccount(Integer account) {
        this.setContextValue(ACCOUNT, account);
    }

    @Override
    public void setWorkplace(Integer workplace) {
        this.setContextValue(WORKPLACE, workplace);
    }

    @Override
    public Integer getAccount() {
        return (Integer)this.contextValueMap.get(ACCOUNT);
    }

    @Override
    public Integer getWorkplace() {
        return (Integer)this.contextValueMap.get(WORKPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Object, Object> map = this.contextValueMap;
        synchronized (map) {
            return this.contextValueMap.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Map<Object, Object> map = this.contextValueMap;
        synchronized (map) {
            out.writeObject(this.contextValueMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        Map<Object, Object> map = this.contextValueMap;
        synchronized (map) {
            this.contextValueMap.clear();
            this.contextValueMap.putAll((Map)in.readObject());
        }
    }

    @Override
    public void sendMessageToClient(Serializable message) throws Exception {
    }

    @Override
    public void closeContext() throws Exception {
        this.contextValueMap.clear();
    }

    @Override
    public ClientContext duplicate() {
        return new ClientContextImpl(this);
    }
}

