/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.login;

import com.dsoft.framework.enterprise.client.PasswordUtils;
import com.dsoft.framework.util.MBeanUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.List;
import java.util.Random;
import javax.management.ObjectName;

public class AccountUtil {
    private static final String SECURITY_DOMAIN = "dsoft_login_config";
    private static final String PASS_HASH_PREFIX = "@S!L#A$Y%E^R";
    private static final String PASS_HASH_POSTFIX = "I_:*&N_^%$#@C_1@#()C";
    private static final char[] SPEC_SYMBOLS = new char[]{'@', '#', '$', '%', '&', '*', '_', '?'};

    public static String createPasswordHash(String username, char[] password) throws NoSuchAlgorithmException, IOException {
        return password != null ? PasswordUtils.createPasswordHash(username, password, PASS_HASH_PREFIX, PASS_HASH_POSTFIX) : "";
    }

    public static String generateRandomPassword() {
        int c;
        char[] PASSWORD_SYMBOLS = new char[SPEC_SYMBOLS.length + 9 + 25 + 25 + 3];
        System.arraycopy(SPEC_SYMBOLS, 0, PASSWORD_SYMBOLS, 0, SPEC_SYMBOLS.length);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            PASSWORD_SYMBOLS[AccountUtil.SPEC_SYMBOLS.length + (c - 48)] = c;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            PASSWORD_SYMBOLS[AccountUtil.SPEC_SYMBOLS.length + 9 + 1 + (c - 65)] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            PASSWORD_SYMBOLS[AccountUtil.SPEC_SYMBOLS.length + 9 + 1 + 25 + 1 + (c - 97)] = c;
        }
        char[] charPass = new char[20];
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            int val = Math.abs(rand.nextInt() % (PASSWORD_SYMBOLS.length - 1));
            charPass[i] = PASSWORD_SYMBOLS[val];
        }
        return new String(charPass);
    }

    public static void refreshRolesCache(String username) throws Exception {
        ObjectName name = new ObjectName("jboss.security:service=JaasSecurityManager");
        List<?> principals = AccountUtil.getAllPrincipals(name);
        for (Object principal1 : principals) {
            Principal principal = (Principal)principal1;
            if (principal == null || !principal.getName().equals(username)) continue;
            MBeanUtil.lookupJBossMBeanServer().invoke(name, "flushAuthenticationCache", new Object[]{SECURITY_DOMAIN, principal}, new String[]{String.class.getName(), Principal.class.getName()});
            break;
        }
    }

    public static void refreshAllRolesCache(String username) throws Exception {
        ObjectName name = new ObjectName("jboss.security:service=JaasSecurityManager");
        List<?> principals = AccountUtil.getAllPrincipals(name);
        for (Object principal1 : principals) {
            Principal principal = (Principal)principal1;
            if (principal == null || principal.getName().equals(username)) continue;
            MBeanUtil.lookupJBossMBeanServer().invoke(name, "flushAuthenticationCache", new Object[]{SECURITY_DOMAIN, principal}, new String[]{String.class.getName(), Principal.class.getName()});
        }
    }

    private static List<?> getAllPrincipals(ObjectName name) throws Exception {
        return (List)MBeanUtil.lookupJBossMBeanServer().invoke(name, "getAuthenticationCachePrincipals", new Object[]{SECURITY_DOMAIN}, new String[]{String.class.getName()});
    }
}

