/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.login;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MessagesFactory {
    private static final Map<String, MessagesFactory> messagesFactoryMap = new ConcurrentHashMap<String, MessagesFactory>();
    protected String resource;
    private static MessagesFactoryProducer messagesFactoryProducer = new MessagesFactoryProducer(){

        @Override
        public MessagesFactory createInstance(String resource) {
            return new MessagesFactory(resource){
                ResourceBundle RESOURCE_BUNDLE;
                {
                    this.RESOURCE_BUNDLE = ResourceBundle.getBundle(this.resource);
                }

                @Override
                public String getString(String key) {
                    try {
                        return this.RESOURCE_BUNDLE.getString(key);
                    }
                    catch (MissingResourceException e) {
                        return '!' + key + '!';
                    }
                }
            };
        }
    };

    public static void setMessagesFactoryProducer(MessagesFactoryProducer producer) {
        messagesFactoryProducer = producer;
    }

    public static MessagesFactory getMessages(String resource) {
        if (!messagesFactoryMap.containsKey(resource)) {
            messagesFactoryProducer.createInstance(resource);
        }
        return messagesFactoryMap.get(resource);
    }

    public MessagesFactory(String resource) {
        messagesFactoryMap.put(resource, this);
        this.resource = resource;
    }

    public abstract String getString(String var1);

    public static interface MessagesFactoryProducer {
        public MessagesFactory createInstance(String var1);
    }
}

