/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.login.jboss;

import com.dsoft.framework.client.context.ClientContextFactory;
import com.dsoft.framework.login.AccountUtil;
import com.dsoft.framework.login.jboss.Messages;
import com.dsoft.framework.util.MBeanUtil;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class PowerProLoginModule
extends UsernamePasswordLoginModule {
    private static final Logger logger = Logger.getLogger((String)PowerProLoginModule.class.getName());
    private static final String BASE_ACCOUNT_DTO = "com.dsoft.framework.enterprise.client.dto.BaseAccountDTO";
    private static final String CACHING_SERVICE_NAME = "name=com.dsoft.framework:service=DSoftCachingService";
    private static final Set<String> SPECIAL_NAMES = new HashSet<String>(Arrays.asList("ddb", "admin", "web"));
    private static final Set<String> LOCAL_HOST = new HashSet<String>(Arrays.asList("127.0.0.1", "localhost"));
    private static final String PRINCIPALS_QUERY = "SELECT pass, enabled, LOG_MESSAGE, LOGIN_ATTEMPTS, id \nFROM base_account\nWHERE username=? AND expiring = 0";
    private static final String UPDATE_LOGIN_ATTEMPTS = "UPDATE BASE_ACCOUNT\nSET LOGIN_ATTEMPTS = LOGIN_ATTEMPTS + 1 \nWHERE USERNAME = ? AND EXPIRING = 0 AND ENABLED = 1";
    private static final String INIT_LOGIN_ATTEMPTS = "UPDATE BASE_ACCOUNT \nSET LOGIN_ATTEMPTS = 1 \nWHERE USERNAME = ? AND EXPIRING = 0 AND ENABLED = 1";
    private static final String CLEAR_LOGIN_ATTEMPTS = "UPDATE BASE_ACCOUNT \nSET LOGIN_ATTEMPTS = 0 \nWHERE USERNAME = ? AND EXPIRING = 0 AND ENABLED = 1";
    private static final String CHANGE_ACCOUNT_STATE = "UPDATE BASE_ACCOUNT \nSET ENABLED = ?, LOG_MESSAGE = ? \nWHERE ID = ? AND EXPIRING = 0 AND enabled = 1";
    private static final String MAX_LOGIN_ATTEMPTS = "SELECT MAX_LOGIN_ATTEMPTS FROM BASE_GLOB_ACCOUNT_POLICY WHERE id = 0";
    private static final String rolesQuery2 = "SELECT r.name\nFROM base_account a\n  JOIN base_account_disabled_role ar ON ((ar.IDLEFTFK = a.ID) AND ar.EXPLEFTFK = a.EXPIRING) \n  JOIN base_roles r ON ((ar.IDRIGHTFK = r.ID) AND ar.EXPRIGHTFK = r.EXPIRING) \nWHERE a.username=?";
    private static final String rolesQuery1 = "SELECT r.name\nFROM base_account a\n  JOIN base_account_enabled_role ar ON ((ar.IDLEFTFK = a.ID) AND ar.EXPLEFTFK = a.EXPIRING)\n  JOIN base_roles r ON ((ar.IDRIGHTFK = r.ID) AND ar.EXPRIGHTFK = r.EXPIRING)\nWHERE a.username=? AND a.expiring = 0";
    private static final String rolesQuery3 = "SELECT r.name\nFROM base_account a\n  JOIN base_account_groups ag ON ((ag.IDLEFTFK = a.ID) AND ag.EXPLEFTFK = a.EXPIRING)\n  JOIN base_groups g ON ((ag.IDRIGHTFK = g.ID) AND ag.EXPRIGHTFK = g.EXPIRING)\n  JOIN base_group_en_role gr ON ((gr.IDLEFTFK = g.ID) AND gr.EXPLEFTFK = g.EXPIRING)\n  JOIN base_roles r ON ((gr.IDRIGHTFK = r.ID) AND gr.EXPRIGHTFK = r.EXPIRING)\nWHERE a.username=? AND a.expiring = 0 ";
    private static final String rolesQuery4 = "SELECT r.name\nFROM base_account a\n  JOIN base_account_groups ag ON ((ag.IDLEFTFK = a.ID) AND ag.EXPLEFTFK = a.EXPIRING)\n  JOIN base_groups g ON ((ag.IDRIGHTFK = g.ID) AND ag.EXPRIGHTFK = g.EXPIRING)\n  JOIN base_group_dis_role gr ON ((gr.IDLEFTFK = g.ID) AND gr.EXPLEFTFK = g.EXPIRING)\n  JOIN base_roles r ON ((gr.IDRIGHTFK = r.ID) AND gr.EXPRIGHTFK = r.EXPIRING)\nWHERE a.username=? AND a.expiring = 0";
    private static DateFormat licenseDateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private String dsJndiName;
    private Date expiresDate;
    private AccountInfo accountInfo;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/PowerProDS";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (this.accountInfo == null) {
            return super.validatePassword(inputPassword, expectedPassword);
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            try (Connection conn = ds.getConnection();){
                PreparedStatement ps;
                if (super.validatePassword(inputPassword, expectedPassword)) {
                    if (!this.accountInfo.enabled) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.accountInfo.attempts > 0 && ClientContextFactory.getClientContext().getAccount() == null) {
                        this.clearLoginAttempts(conn);
                    }
                    boolean bl = true;
                    return bl;
                }
                this.setValidateError(new FailedLoginException(Messages.getString("PowerProLoginModule.7")));
                int maxLoginAttempts = this.getMaxLoginAttempts(conn);
                String userName = this.getUsername();
                if (maxLoginAttempts == 0 || "admin".equals(userName)) {
                    boolean bl = false;
                    return bl;
                }
                AccountUtil.refreshRolesCache(userName);
                if (this.accountInfo.attempts == -1) {
                    ps = conn.prepareStatement(INIT_LOGIN_ATTEMPTS);
                    this.accountInfo.attempts = 1;
                } else {
                    ps = conn.prepareStatement(UPDATE_LOGIN_ATTEMPTS);
                    this.accountInfo.attempts++;
                }
                try {
                    ps.setString(1, userName);
                    ps.executeUpdate();
                }
                finally {
                    ps.close();
                }
                if (this.accountInfo.attempts <= maxLoginAttempts) return false;
                this.disableAccount(conn);
                return false;
            }
            finally {
                this.accountInfo = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while updating login attempts", (Throwable)ex);
            this.setValidateError(ex);
        }
        return false;
    }

    private void disableAccount(Connection conn) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement(CHANGE_ACCOUNT_STATE);){
            ps.setInt(1, 0);
            ps.setString(2, Messages.getString("PowerProLoginModule.0"));
            ps.setInt(3, this.accountInfo.accountId);
            ps.executeUpdate();
        }
        this.invalidateAccountObject(this.accountInfo.accountId);
    }

    /*
     * Exception decompiling
     */
    private int getMaxLoginAttempts(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearLoginAttempts(Connection conn) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement(CLEAR_LOGIN_ATTEMPTS);){
            ps.setString(1, this.getUsername());
            ps.executeUpdate();
        }
    }

    private void invalidateAccountObject(Integer account) {
        try {
            ObjectName name = new ObjectName(CACHING_SERVICE_NAME);
            MBeanUtil.lookupJBossMBeanServer().invoke(name, "removeObject", new Object[]{account, new String[]{BASE_ACCOUNT_DTO}, 0L}, new String[]{Integer.class.getName(), "[S", Long.class.getName()});
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private Object readLicenseProperty(String property) throws Exception {
        MBeanServer server = MBeanUtil.lookupJBossMBeanServer();
        ObjectName objName = new ObjectName("name=com.dsoft:service=LicenseManager");
        return server.invoke(objName, "getModuleLicenseProperty", new Object[]{"0C356F62-66B9-41BC-9E98-7CD8D96CC651", property}, new String[]{String.class.getName(), String.class.getName()});
    }

    protected String getUsersPassword() throws LoginException {
        String password;
        block48: {
            String username = this.getUsername();
            this.accountInfo = null;
            if (username == null) {
                try {
                    return AccountUtil.createPasswordHash(null, null);
                }
                catch (Exception e) {
                    return "";
                }
            }
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                try (Connection conn = ds.getConnection();){
                    if (!SPECIAL_NAMES.contains(username)) {
                        this.checkLicenseRestrictions();
                    }
                    this.accountInfo = new AccountInfo();
                    try (PreparedStatement ps = conn.prepareStatement(PRINCIPALS_QUERY);){
                        ps.setString(1, username);
                        try (ResultSet rs = ps.executeQuery();){
                            if (!rs.next()) {
                                throw new FailedLoginException(Messages.getString("PowerProLoginModule.3"));
                            }
                            int enabled = rs.getInt("enabled");
                            if (enabled == 1 || ClientContextFactory.getClientContext().getAccount() != null) {
                                password = rs.getString(1);
                                password = this.convertRawPassword(password);
                                this.accountInfo.enabled = enabled == 1;
                                this.accountInfo.accountId = rs.getInt("id");
                                this.accountInfo.attempts = rs.getInt("LOGIN_ATTEMPTS");
                                if (rs.wasNull()) {
                                    this.accountInfo.attempts = -1;
                                }
                                break block48;
                            }
                            if (rs.getString("LOG_MESSAGE") != null) {
                                throw new FailedLoginException(Messages.getString("PowerProLoginModule.4"));
                            }
                            throw new FailedLoginException(Messages.getString("PowerProLoginModule.5"));
                        }
                    }
                }
            }
            catch (NamingException ex) {
                throw new LoginException(ex.toString(true));
            }
            catch (LoginException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new LoginException(ex.toString());
            }
        }
        return password;
    }

    private void checkLicenseRestrictions() throws LoginException {
        try {
            String bindAddress;
            Boolean demo;
            String expires = (String)this.readLicenseProperty("expires");
            if (expires != null) {
                if (expires.equalsIgnoreCase("never")) {
                    this.expiresDate = new Date(Long.MAX_VALUE);
                } else {
                    try {
                        this.expiresDate = licenseDateFormat.parse(expires);
                    }
                    catch (ParseException ex) {
                        throw new LoginException(ex.toString());
                    }
                }
            }
            if ((demo = (Boolean)this.readLicenseProperty("demo")) != null && demo.booleanValue() && !LOCAL_HOST.contains(bindAddress = System.getProperty("jboss.bind.address"))) {
                throw new FailedLoginException(Messages.getString("PowerProLoginModule.1"));
            }
        }
        catch (Exception ex) {
            throw new LoginException(ex.toString());
        }
        if (this.expiresDate == null || this.expiresDate.getTime() < System.currentTimeMillis()) {
            throw new FailedLoginException(Messages.getString("PowerProLoginModule.2"));
        }
    }

    private Set<String> getRoles(Connection conn, String query, String username) throws LoginException {
        HashSet<String> roles = new HashSet<String>();
        if (username == null) {
            return roles;
        }
        try (PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, username);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString(1);
                    roles.add(name);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"SQL failure", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        return roles;
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        HashMap<String, Group> setsMap = new HashMap<String, Group>();
        try {
            Iterator<String> it;
            Set<String> groupDisabledRoles;
            Set<String> groupEnabledRoles;
            Set<String> accountDisabledRoles;
            Set<String> accountEnabledRoles;
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            try (Connection conn = ds.getConnection();){
                accountEnabledRoles = this.getRoles(conn, rolesQuery1, username);
                accountDisabledRoles = this.getRoles(conn, rolesQuery2, username);
                groupEnabledRoles = this.getRoles(conn, rolesQuery3, username);
                groupDisabledRoles = this.getRoles(conn, rolesQuery4, username);
            }
            groupEnabledRoles.removeAll(groupDisabledRoles);
            groupEnabledRoles.addAll(accountEnabledRoles);
            groupEnabledRoles.removeAll(accountDisabledRoles);
            if (groupEnabledRoles.isEmpty()) {
                groupEnabledRoles.add("no_such_role");
            }
            if (!(it = groupEnabledRoles.iterator()).hasNext()) {
                if (this.getUnauthenticatedIdentity() == null) {
                    throw new FailedLoginException(Messages.getString("PowerProLoginModule.6"));
                }
                return new Group[]{new SimpleGroup("Roles")};
            }
            while (it.hasNext()) {
                String name = it.next();
                String groupName = "Roles";
                Group group = (Group)setsMap.get(groupName);
                if (group == null) {
                    group = new SimpleGroup(groupName);
                    setsMap.put(groupName, group);
                }
                group.addMember((Principal)new SimplePrincipal(name));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while loading account roles", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    private String convertRawPassword(String rawPassword) {
        return rawPassword;
    }

    public String createPasswordHash(String username, String password) {
        try {
            return AccountUtil.createPasswordHash(username, password.toCharArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    private class AccountInfo {
        private int attempts;
        private boolean enabled;
        private Integer accountId;

        private AccountInfo() {
        }
    }
}

