/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticReplicationInterceptor
extends BaseRpcInterceptor {
    private Map broadcastTxs = new ConcurrentHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall call) throws Throwable {
        Object retval;
        block18: {
            block17: {
                JBCMethodCall m = (JBCMethodCall)call;
                InvocationContext ctx = this.getInvocationContext();
                Option optionOverride = ctx.getOptionOverrides();
                if (this.isBuddyGroupOrganisationMethod(m)) {
                    return super.invoke(m);
                }
                if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
                    return super.invoke(m);
                }
                if (ctx.getTransaction() == null) break block17;
                GlobalTransaction gtx = ctx.getGlobalTransaction();
                if (gtx == null) {
                    throw new CacheException("failed to get global transaction");
                }
                this.log.debug((Object)(" received method " + (Object)((Object)m)));
                switch (m.getMethodId()) {
                    case 18: {
                        retval = super.invoke(m);
                        if (!gtx.isRemote() && this.getInvocationContext().isOriginLocal() && (retval = this.broadcastPrepare(m, gtx)) instanceof Throwable) {
                            throw (Throwable)retval;
                        }
                        break block18;
                    }
                    case 11: {
                        Throwable temp = null;
                        if (!gtx.isRemote() && this.getInvocationContext().isOriginLocal() && this.broadcastTxs.containsKey(gtx)) {
                            try {
                                this.broadcastCommit(gtx);
                            }
                            catch (Throwable t) {
                                this.log.error((Object)" a problem occurred with remote commit", t);
                                temp = t;
                            }
                        }
                        retval = super.invoke(m);
                        if (temp != null) {
                            throw temp;
                        }
                        break block18;
                    }
                    case 12: {
                        Throwable temp2 = null;
                        if (!gtx.isRemote() && this.getInvocationContext().isOriginLocal() && this.broadcastTxs.containsKey(gtx)) {
                            try {
                                this.broadcastRollback(gtx);
                            }
                            catch (Throwable t) {
                                this.log.error((Object)" a problem occurred with remote rollback", t);
                                temp2 = t;
                            }
                        }
                        retval = super.invoke(m);
                        if (temp2 != null) {
                            throw temp2;
                        }
                        break block18;
                    }
                    default: {
                        this.log.debug((Object)(" received method " + (Object)((Object)m) + " not handling"));
                        retval = super.invoke(m);
                        break;
                    }
                }
                break block18;
            }
            throw new CacheException("transaction does not exist");
        }
        return retval;
    }

    protected Object broadcastPrepare(JBCMethodCall methodCall, GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.cache.getCacheModeInternal() == 3;
        Object[] args = methodCall.getArgs();
        List modifications = (List)args[1];
        int num_mods = modifications != null ? modifications.size() : 0;
        JBCMethodCall toBroadcast = this.mapDataVersionedMethodCalls(methodCall, this.getTransactionWorkspace(gtx));
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            this.broadcastTxs.put(gtx, gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + num_mods + " modifications"));
            }
            this.replicateCall(toBroadcast, remoteCallSync);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("(" + this.cache.getLocalAddress() + "):not broadcasting prepare as members are " + this.cache.getMembers()));
        }
        return null;
    }

    private JBCMethodCall mapDataVersionedMethodCalls(JBCMethodCall m, TransactionWorkspace w) {
        Object[] origArgs = m.getArgs();
        return MethodCallFactory.create(m.getMethod(), new Object[]{origArgs[0], this.translate((List)origArgs[1], w), origArgs[2], origArgs[3], origArgs[4]});
    }

    private List translate(List l, TransactionWorkspace w) {
        ArrayList<JBCMethodCall> newList = new ArrayList<JBCMethodCall>();
        Iterator origCalls = l.iterator();
        while (origCalls.hasNext()) {
            JBCMethodCall origCall = (JBCMethodCall)((Object)origCalls.next());
            if (MethodDeclarations.isDataGravitationMethod(origCall.getMethodId())) {
                newList.add(origCall);
                continue;
            }
            Object[] origArgs = origCall.getArgs();
            Fqn fqn = (Fqn)origArgs[1];
            DataVersion versionToBroadcast = this.getVersionToBroadcast(w, fqn);
            Object[] newArgs = new Object[origArgs.length + 1];
            for (int i = 0; i < origArgs.length; ++i) {
                newArgs[i] = origArgs[i];
            }
            newArgs[origArgs.length] = versionToBroadcast;
            JBCMethodCall newCall = MethodCallFactory.create(MethodDeclarations.getVersionedMethod(origCall.getMethodId()), newArgs);
            newList.add(newCall);
        }
        return newList;
    }

    private DataVersion getVersionToBroadcast(TransactionWorkspace w, Fqn f) {
        WorkspaceNode n = w.getNode(f);
        if (n == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Fqn " + f + " not found in workspace; not using a data version."));
            }
            return null;
        }
        if (n.isVersioningImplicit()) {
            DefaultDataVersion v = (DefaultDataVersion)n.getVersion();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Fqn " + f + " has implicit versioning.  Broadcasting an incremented version."));
            }
            return v.increment();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Fqn " + f + " has explicit versioning.  Broadcasting the version as-is."));
        }
        return n.getVersion();
    }

    protected void broadcastCommit(GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.cache.getSyncCommitPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                JBCMethodCall commit_method = MethodCallFactory.create(MethodDeclarations.commitMethod, new Object[]{gtx});
                this.log.debug((Object)("running remote commit for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(commit_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.fatal((Object)"commit failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected TransactionWorkspace getTransactionWorkspace(GlobalTransaction gtx) throws CacheException {
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)this.cache.getTransactionTable().get(gtx);
        if (transactionEntry == null) {
            throw new CacheException("unable to map global transaction " + gtx + " to transaction entry");
        }
        return transactionEntry.getTransactionWorkSpace();
    }

    protected void broadcastRollback(GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.cache.getSyncRollbackPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                JBCMethodCall rollback_method = MethodCallFactory.create(MethodDeclarations.rollbackMethod, new Object[]{gtx});
                this.log.debug((Object)("running remote rollback for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(rollback_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.error((Object)"rollback failed", (Throwable)e);
                throw e;
            }
        }
    }
}

