/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.util.ObjectUtil;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.invocation.MarshalledValueOutputStream;

class StateTransferGenerator_124
implements StateTransferGenerator {
    public static final short STATE_TRANSFER_VERSION = 124;
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private TreeCache cache;

    StateTransferGenerator_124(TreeCache cache) {
        this.cache = cache;
    }

    public byte[] generateStateTransfer(DataNode rootNode, boolean generateTransient, boolean generatePersistent, boolean suppressErrors) throws Throwable {
        MarshalledValueOutputStream out;
        ByteArrayOutputStream baos;
        byte[] retval;
        byte[][] states;
        Fqn fqn;
        block15: {
            boolean debug;
            block14: {
                debug = this.log.isDebugEnabled();
                fqn = rootNode.getFqn();
                states = new byte[3][];
                states[2] = null;
                states[1] = null;
                states[0] = null;
                retval = null;
                try {
                    if (generateTransient) {
                        baos = new ByteArrayOutputStream(1024);
                        out = new MarshalledValueOutputStream((OutputStream)baos);
                        this.marshallTransientState(rootNode, (ObjectOutputStream)out);
                        out.close();
                        states[0] = baos.toByteArray();
                        if (debug) {
                            this.log.debug((Object)("returning the in-memory state (" + states[0].length + " bytes)"));
                        }
                        if (this.cache instanceof PojoCache) {
                            baos = new ByteArrayOutputStream(1024);
                            out = new MarshalledValueOutputStream((OutputStream)baos);
                            this.marshallAssociatedState(fqn, (ObjectOutputStream)out);
                            out.close();
                            states[1] = baos.toByteArray();
                            if (debug) {
                                this.log.debug((Object)("returning the associated state (" + states[1].length + " bytes)"));
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed getting the in-memory (transient) state", t);
                    if (suppressErrors) break block14;
                    throw t;
                }
            }
            if (generatePersistent) {
                try {
                    if (debug) {
                        this.log.debug((Object)"getting the persistent state");
                    }
                    states[2] = fqn.size() == 0 ? this.cache.getCacheLoader().loadEntireState() : ((ExtendedCacheLoader)this.cache.getCacheLoader()).loadState(fqn);
                    if (debug) {
                        this.log.debug((Object)("returning the persistent state (" + states[2].length + " bytes)"));
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed getting the persistent state", t);
                    if (suppressErrors) break block15;
                    throw t;
                }
            }
        }
        try {
            baos = new ByteArrayOutputStream(1024);
            out = new MarshalledValueOutputStream((OutputStream)baos);
            out.writeShort(124);
            out.writeObject((Object)states);
            out.close();
            retval = baos.toByteArray();
            this.log.info((Object)("returning the state for tree rooted in " + fqn.toString() + "(" + retval.length + " bytes)"));
            return retval;
        }
        catch (Throwable t) {
            this.log.error((Object)"failed serializing transient and persistent state", t);
            if (!suppressErrors) {
                throw t;
            }
            return retval;
        }
    }

    private void marshallTransientState(DataNode node, ObjectOutputStream out) throws Exception {
        Map attrs = node.getData();
        NodeData nd = attrs == null || attrs.size() == 0 ? new NodeData(node.getFqn()) : new NodeData(node.getFqn(), attrs);
        out.writeObject(nd);
        Map children = node.getChildren();
        if (children == null) {
            return;
        }
        Iterator it = children.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.marshallTransientState((DataNode)entry.getValue(), out);
        }
    }

    private void marshallAssociatedState(Fqn fqn, ObjectOutputStream out) throws Exception {
        if (fqn == null || fqn.size() == 0 || fqn.isChildOf(InternalDelegate.JBOSS_INTERNAL)) {
            return;
        }
        Node refMapNode = this.cache.get(InternalDelegate.JBOSS_INTERNAL_MAP);
        Map children = null;
        if (refMapNode != null && (children = refMapNode.getChildren()) != null) {
            String targetFqn = ObjectUtil.getIndirectFqn(fqn.toString());
            Iterator iter = children.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(targetFqn)) continue;
                DataNode value = (DataNode)entry.getValue();
                out.writeObject(new Object[]{key, value.get(key)});
            }
        }
    }
}

