/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherSerializationTest
extends TestCase {
    private JChannel channel;
    private JChannel channel2;
    private RpcDispatcher disp;
    private RpcDispatcher disp2;
    private String props = null;

    public RpcDispatcherSerializationTest(String testName) {
        super(testName);
    }

    public void methodA(boolean b, long l) {
        System.out.println("methodA(" + b + ", " + l + ") called");
    }

    public boolean methodB() {
        return true;
    }

    public void methodC() {
        throw new IllegalArgumentException("dummy exception - for testing only");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel(this.props);
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new RpcDispatcher((Channel)this.channel, null, null, (Object)this);
        this.channel.connect("RpcDispatcherSerializationTestGroup");
        this.channel2 = new JChannel(this.props);
        this.disp2 = new RpcDispatcher((Channel)this.channel2, null, null, (Object)this);
        this.channel2.connect("RpcDispatcherSerializationTestGroup");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.channel2.close();
        this.disp2.stop();
        this.disp.stop();
        this.channel.close();
    }

    public void testNonSerializableArgument() {
        try {
            this.disp.callRemoteMethods(null, "foo", new Object[]{new NonSerializable()}, new Class[]{NonSerializable.class}, 2, 5000L);
            RpcDispatcherSerializationTest.fail((String)"should throw NotSerializableException");
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause != null && cause instanceof NotSerializableException) {
                System.out.println("received RuntimeException with NotSerializableException as cause - this is expected");
            }
            RpcDispatcherSerializationTest.fail((String)("received " + t));
        }
    }

    public void testTargetMethodNotFound() {
        Vector members = this.channel.getView().getMembers();
        System.out.println("members are: " + members);
        RspList rsps = this.disp.callRemoteMethods(members, "foo", null, new Class[]{String.class, String.class}, 2, 8000L);
        System.out.println("responses:\n" + rsps + ", channel.view: " + this.channel.getView() + ", channel2.view: " + this.channel2.getView());
        RpcDispatcherSerializationTest.assertEquals((int)members.size(), (int)rsps.size());
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            RpcDispatcherSerializationTest.assertTrue((boolean)(rsp.getValue() instanceof NoSuchMethodException));
        }
    }

    public void testMarshaller() {
        Rsp rsp;
        MyMarshaller m = new MyMarshaller();
        this.disp.setRequestMarshaller(m);
        this.disp.setResponseMarshaller(m);
        this.disp2.setRequestMarshaller(m);
        this.disp2.setResponseMarshaller(m);
        RspList rsps = this.disp.callRemoteMethods(null, "methodA", new Object[]{Boolean.TRUE, new Long(322649L)}, new Class[]{Boolean.TYPE, Long.TYPE}, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals((int)2, (int)rsps.size());
        Iterator it = rsps.values().iterator();
        while (it.hasNext()) {
            rsp = (Rsp)it.next();
            RpcDispatcherSerializationTest.assertNull((Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue((boolean)rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse((boolean)rsp.wasSuspected());
        }
        rsps = this.disp.callRemoteMethods(null, "methodB", null, (Class[])null, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals((int)2, (int)rsps.size());
        it = rsps.values().iterator();
        while (it.hasNext()) {
            rsp = (Rsp)it.next();
            RpcDispatcherSerializationTest.assertNotNull((Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertEquals((Object)Boolean.TRUE, (Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue((boolean)rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse((boolean)rsp.wasSuspected());
        }
        rsps = this.disp.callRemoteMethods(null, "methodC", null, (Class[])null, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals((int)2, (int)rsps.size());
        it = rsps.values().iterator();
        while (it.hasNext()) {
            rsp = (Rsp)it.next();
            RpcDispatcherSerializationTest.assertNotNull((Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue((boolean)(rsp.getValue() instanceof Throwable));
            RpcDispatcherSerializationTest.assertTrue((boolean)rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse((boolean)rsp.wasSuspected());
        }
        this.disp.setRequestMarshaller(null);
        this.disp.setResponseMarshaller(null);
        this.disp2.setRequestMarshaller(null);
        this.disp2.setResponseMarshaller(null);
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherSerializationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherSerializationTest.suite());
    }

    static class NonSerializable {
        int i;

        NonSerializable() {
        }
    }

    static class MyMarshaller
    implements RpcDispatcher.Marshaller {
        static final byte NULL = 0;
        static final byte BOOL = 1;
        static final byte LONG = 2;
        static final byte OBJ = 3;

        MyMarshaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] objectToByteBuffer(Object obj) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream(24);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            try {
                if (obj == null) {
                    oos.writeByte(0);
                } else if (obj instanceof Boolean) {
                    oos.writeByte(1);
                    oos.writeBoolean((Boolean)obj);
                } else if (obj instanceof Long) {
                    oos.writeByte(2);
                    oos.writeLong((Long)obj);
                } else {
                    oos.writeByte(3);
                    oos.writeObject(obj);
                }
                oos.flush();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                Util.close(oos);
            }
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            ByteArrayInputStream inp = new ByteArrayInputStream(buf);
            ObjectInputStream in = new ObjectInputStream(inp);
            try {
                byte type = in.readByte();
                switch (type) {
                    case 0: {
                        Object var5_5 = null;
                        return var5_5;
                    }
                    case 1: {
                        Boolean bl = new Boolean(in.readBoolean());
                        return bl;
                    }
                    case 2: {
                        Long l = new Long(in.readLong());
                        return l;
                    }
                    case 3: {
                        Object object = in.readObject();
                        return object;
                    }
                }
                throw new IllegalArgumentException("incorrect type " + type);
            }
            finally {
                Util.close(in);
            }
        }
    }
}

