/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Random;
import javax.management.MBeanServer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Debugger;
import org.jgroups.demos.DrawCommand;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class Draw
extends ExtendedReceiverAdapter
implements ActionListener,
ChannelListener {
    String groupname = "DrawGroupDemo";
    private Channel channel = null;
    private int member_size = 1;
    Debugger debugger = null;
    final boolean first = true;
    final boolean cummulative = true;
    private JFrame mainFrame = null;
    private JPanel sub_panel = null;
    private DrawPanel panel = null;
    private JButton clear_button;
    private JButton leave_button;
    private final Random random = new Random(System.currentTimeMillis());
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final Color draw_color = this.selectColor();
    private final Color background_color = Color.white;
    boolean no_channel = false;
    boolean jmx;

    public Draw(String props, boolean debug, boolean cummulative, boolean no_channel, boolean jmx) throws Exception {
        this.no_channel = no_channel;
        this.jmx = jmx;
        if (no_channel) {
            return;
        }
        this.channel = new JChannel(props);
        if (debug) {
            this.debugger = new Debugger((JChannel)this.channel, cummulative);
            this.debugger.start();
        }
        this.channel.setOpt(5, Boolean.TRUE);
        this.channel.setReceiver(this);
        this.channel.addChannelListener(this);
    }

    public Draw(Channel channel) throws Exception {
        this.channel = channel;
        channel.setOpt(5, Boolean.TRUE);
        channel.setReceiver(this);
        channel.addChannelListener(this);
    }

    public String getGroupName() {
        return this.groupname;
    }

    public void setGroupName(String groupname) {
        if (groupname != null) {
            this.groupname = groupname;
        }
    }

    public static void main(String[] args) {
        Draw draw = null;
        String props = null;
        boolean debug = false;
        boolean cummulative = false;
        boolean no_channel = false;
        boolean jmx = false;
        String group_name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                Draw.help();
                return;
            }
            if ("-debug".equals(args[i])) {
                debug = true;
                continue;
            }
            if ("-cummulative".equals(args[i])) {
                cummulative = true;
                continue;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-no_channel".equals(args[i])) {
                no_channel = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-groupname".equals(args[i])) {
                group_name = args[++i];
                continue;
            }
            Draw.help();
            return;
        }
        if (props == null) {
            props = "UDP(down_thread=false;mcast_send_buf_size=640000;mcast_port=45566;discard_incompatible_packets=true;ucast_recv_buf_size=20000000;mcast_addr=228.10.10.10;up_thread=false;loopback=false;mcast_recv_buf_size=25000000;max_bundle_size=64000;max_bundle_timeout=30;use_incoming_packet_handler=true;use_outgoing_packet_handler=false;ucast_send_buf_size=640000;tos=16;enable_bundling=true;ip_ttl=2):PING(timeout=2000;down_thread=false;num_initial_members=3;up_thread=false):MERGE2(max_interval=10000;down_thread=false;min_interval=5000;up_thread=false):FD(timeout=2000;max_tries=3;down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(max_xmit_size=60000;down_thread=false;use_mcast_xmit=false;gc_lag=0;discard_delivered_msgs=true;up_thread=false;retransmit_timeout=100,200,300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400,3600;down_thread=false;up_thread=false):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=50000;max_bytes=400000;down_thread=false;up_thread=false):VIEW_SYNC(down_thread=false;avg_send_interval=60000;up_thread=false):pbcast.GMS(print_local_addr=true;join_timeout=3000;down_thread=false;join_retry_timeout=2000;up_thread=false;shun=true):FC(max_credits=2000000;down_thread=false;up_thread=false;min_threshold=0.10):FRAG2(frag_size=60000;down_thread=false;up_thread=false):pbcast.STATE_TRANSFER(down_thread=false;up_thread=false)";
        }
        try {
            draw = new Draw(props, debug, cummulative, no_channel, jmx);
            if (group_name != null) {
                draw.setGroupName(group_name);
            }
            draw.go();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    static void help() {
        System.out.println("\nDraw [-help] [-debug] [-cummulative] [-no_channel] [-props <protocol stack definition>] [-groupname <name>]");
        System.out.println("-debug: brings up a visual debugger");
        System.out.println("-no_channel: doesn't use JGroups at all, any drawing will be relected on the whiteboard directly");
        System.out.println("-props: argument can be an old-style protocol stack specification, or it can be a URL. In the latter case, the protocol specification will be read from the URL\n");
    }

    private Color selectColor() {
        int red = Math.abs(this.random.nextInt()) % 255;
        int green = Math.abs(this.random.nextInt()) % 255;
        int blue = Math.abs(this.random.nextInt()) % 255;
        return new Color(red, green, blue);
    }

    public void go() throws Exception {
        if (!this.no_channel) {
            this.channel.connect(this.groupname);
            if (this.jmx) {
                MBeanServer server = Util.getMBeanServer();
                if (server == null) {
                    throw new Exception("No MBeanServers found;\nDraw needs to be run with an MBeanServer present, or inside JDK 5");
                }
                JmxConfigurator.registerChannel((JChannel)this.channel, server, "jgroups", this.channel.getClusterName(), true);
            }
        }
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.panel = new DrawPanel();
        this.panel.setBackground(this.background_color);
        this.sub_panel = new JPanel();
        this.mainFrame.getContentPane().add("Center", this.panel);
        this.clear_button = new JButton("Clear");
        this.clear_button.setFont(this.default_font);
        this.clear_button.addActionListener(this);
        this.leave_button = new JButton("Leave");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.getContentPane().add("South", this.sub_panel);
        this.mainFrame.setBackground(this.background_color);
        this.clear_button.setForeground(Color.blue);
        this.leave_button.setForeground(Color.blue);
        this.setTitle();
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        this.mainFrame.setBounds(new Rectangle(250, 250));
        this.mainFrame.setVisible(true);
    }

    void setTitle(String title) {
        String tmp = "";
        if (this.no_channel) {
            this.mainFrame.setTitle(" Draw Demo ");
            return;
        }
        if (title != null) {
            this.mainFrame.setTitle(title);
        } else {
            if (this.channel.getLocalAddress() != null) {
                tmp = tmp + this.channel.getLocalAddress();
            }
            tmp = tmp + " (" + this.member_size + ")";
            this.mainFrame.setTitle(tmp);
        }
    }

    void setTitle() {
        this.setTitle(null);
    }

    public void receive(Message msg) {
        byte[] buf = msg.getRawBuffer();
        if (buf == null) {
            System.err.println("received null buffer from " + msg.getSrc() + ", headers: " + msg.getHeaders());
            return;
        }
        try {
            DrawCommand comm = (DrawCommand)Util.streamableFromByteBuffer(DrawCommand.class, buf, msg.getOffset(), msg.getLength());
            switch (comm.mode) {
                case 1: {
                    if (this.panel != null) {
                        this.panel.drawPoint(comm);
                    }
                    break;
                }
                case 2: {
                    this.clearPanel();
                    break;
                }
                default: {
                    System.err.println("***** received invalid draw command " + comm.mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void viewAccepted(View v) {
        if (v instanceof MergeView) {
            System.out.println("** MergeView=" + v);
        } else {
            System.out.println("** View=" + v);
        }
        this.member_size = v.size();
        if (this.mainFrame != null) {
            this.setTitle();
        }
    }

    public void block() {
        System.out.println("--  received BlockEvent");
    }

    public void unblock() {
        System.out.println("-- received UnblockEvent");
    }

    public void clearPanel() {
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void sendClearPanelMsg() {
        int[] tmp = new int[]{0};
        DrawCommand comm = new DrawCommand(2);
        try {
            byte[] buf = Util.streamableToByteBuffer(comm);
            this.channel.send(new Message(null, null, buf));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Clear".equals(command)) {
            if (this.no_channel) {
                this.clearPanel();
                return;
            }
            this.sendClearPanelMsg();
        } else if ("Leave".equals(command)) {
            this.stop();
        } else {
            System.out.println("Unknown action");
        }
    }

    public void stop() {
        if (!this.no_channel) {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
    }

    public void channelShunned() {
        System.out.println("-- received EXIT, waiting for ChannelReconnected callback");
        this.setTitle(" Draw Demo - shunned ");
    }

    public void channelReconnected(Address addr) {
        this.setTitle();
    }

    private class DrawPanel
    extends JPanel
    implements MouseMotionListener {
        final Dimension preferred_size = new Dimension(235, 170);
        Image img = null;
        Dimension d;
        Dimension imgsize = null;
        Graphics gr = null;

        public DrawPanel() {
            this.createOffscreenImage();
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ DrawPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentResized(ComponentEvent e) {
                    if (this.this$1.getWidth() <= 0 || this.this$1.getHeight() <= 0) {
                        return;
                    }
                    this.this$1.createOffscreenImage();
                }
            });
        }

        final void createOffscreenImage() {
            this.d = this.getSize();
            if (this.img == null || this.imgsize == null || this.imgsize.width != this.d.width || this.imgsize.height != this.d.height) {
                this.img = this.createImage(this.d.width, this.d.height);
                if (this.img != null) {
                    this.gr = this.img.getGraphics();
                }
                this.imgsize = this.d;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            DrawCommand comm = new DrawCommand(1, x, y, Draw.this.draw_color.getRed(), Draw.this.draw_color.getGreen(), Draw.this.draw_color.getBlue());
            if (Draw.this.no_channel) {
                this.drawPoint(comm);
                return;
            }
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                Draw.this.channel.send(new Message(null, null, buf));
                Thread.yield();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        public void drawPoint(DrawCommand c) {
            if (c == null || this.gr == null) {
                return;
            }
            this.gr.setColor(new Color(c.r, c.g, c.b));
            this.gr.fillOval(c.x, c.y, 10, 10);
            this.repaint();
        }

        public void clear() {
            if (this.gr == null) {
                return;
            }
            this.gr.clearRect(0, 0, this.getSize().width, this.getSize().height);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return this.preferred_size;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

