/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class PIGGYBACK
extends Protocol {
    long max_wait_time = 20L;
    long max_size = 8192L;
    final Queue msg_queue = new Queue();
    Packer packer = null;
    boolean packing = false;
    Address local_addr = null;

    public String getName() {
        return "PIGGYBACK";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("max_wait_time");
        if (str != null) {
            this.max_wait_time = Long.parseLong(str);
            props.remove("max_wait_time");
        }
        if ((str = props.getProperty("max_size")) != null) {
            this.max_size = Long.parseLong(str);
            props.remove("max_size");
        }
        if (props.size() > 0) {
            this.log.error((Object)("PIGGYBACK.setProperties(): these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.startPacker();
    }

    public void stop() {
        this.packing = false;
        this.msg_queue.close(true);
        this.stopPacker();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PiggybackHeader)) break;
                msg.removeHeader(this.getName());
                try {
                    Vector messages = (Vector)msg.getObject();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("unpacking " + messages.size() + " messages"));
                    }
                    for (int i = 0; i < messages.size(); ++i) {
                        this.passUp(new Event(1, messages.elementAt(i)));
                    }
                }
                catch (Exception e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("piggyback message does not contain a vector of piggybacked messages, discarding message ! Exception is " + e));
                    }
                    return;
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress() || !this.packing) break;
                try {
                    this.msg_queue.add(msg);
                }
                catch (QueueClosedException closed) {
                    break;
                }
                return;
            }
        }
        this.passDown(evt);
    }

    void startPacker() {
        if (this.packer == null) {
            this.packing = true;
            this.packer = new Packer();
            this.packer.start();
        }
    }

    void stopPacker() {
        if (this.packer != null) {
            this.packer.stop();
            this.packing = false;
            this.msg_queue.close(false);
            this.packer = null;
        }
    }

    public static class PiggybackHeader
    extends Header {
        public String toString() {
            return "[PIGGYBACK: <variables> ]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    class Packer
    implements Runnable {
        Thread t = null;

        Packer() {
        }

        public void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "Packer thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            this.t = null;
        }

        public void run() {
            long current_size = 0L;
            long time_to_wait = PIGGYBACK.this.max_wait_time;
            while (PIGGYBACK.this.packer != null) {
                try {
                    Message m = (Message)PIGGYBACK.this.msg_queue.remove();
                    m.setSrc(PIGGYBACK.this.local_addr);
                    long start_time = System.currentTimeMillis();
                    current_size = 0L;
                    Message new_msg = new Message();
                    Vector<Message> msgs = new Vector<Message>();
                    msgs.addElement(m);
                    current_size += m.size();
                    while (System.currentTimeMillis() - start_time <= PIGGYBACK.this.max_wait_time && current_size <= PIGGYBACK.this.max_size && (time_to_wait = PIGGYBACK.this.max_wait_time - (System.currentTimeMillis() - start_time)) > 0L) {
                        try {
                            m = (Message)PIGGYBACK.this.msg_queue.peek(time_to_wait);
                            m.setSrc(PIGGYBACK.this.local_addr);
                        }
                        catch (TimeoutException timeout) {
                            break;
                        }
                        if (m == null || m.size() + current_size > PIGGYBACK.this.max_size) break;
                        m = (Message)PIGGYBACK.this.msg_queue.remove();
                        current_size += m.size();
                        msgs.addElement(m);
                    }
                    try {
                        new_msg.putHeader(PIGGYBACK.this.getName(), new PiggybackHeader());
                        new_msg.setBuffer(Util.objectToByteBuffer(msgs));
                        PIGGYBACK.this.passDown(new Event(1, new_msg));
                        if (!PIGGYBACK.this.log.isInfoEnabled()) continue;
                        PIGGYBACK.this.log.info((Object)("combined " + msgs.size() + " messages of a total size of " + current_size + " bytes"));
                    }
                    catch (Exception e) {
                        if (!PIGGYBACK.this.log.isWarnEnabled()) continue;
                        PIGGYBACK.this.log.warn((Object)("exception is " + e));
                    }
                }
                catch (QueueClosedException closed) {
                    if (!PIGGYBACK.this.log.isInfoEnabled()) break;
                    PIGGYBACK.this.log.info((Object)"packer stopped as queue is closed");
                    break;
                }
            }
        }
    }
}

