/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.ejb.EJBException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.logging.Logger;

public final class JDBCStoreEntityCommand {
    private final JDBCEntityBridge entity;
    private final JDBCFieldBridge[] primaryKeyFields;
    private final Logger log;

    public JDBCStoreEntityCommand(JDBCStoreManager manager) {
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.primaryKeyFields = this.entity.getPrimaryKeyFields();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    public void execute(EntityEnterpriseContext ctx) {
        JDBCEntityBridge.FieldIterator dirtyIterator = this.entity.getDirtyIterator(ctx);
        if (!dirtyIterator.hasNext() || this.entity.isBeingRemoved(ctx) || this.entity.isScheduledForBatchCascadeDelete(ctx)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Store command NOT executed. Entity is not dirty , is being removed or scheduled for *batch* cascade delete: pk=" + ctx.getId()));
            }
            return;
        }
        StringBuffer sql = new StringBuffer(200);
        sql.append("UPDATE ").append(this.entity.getQualifiedTableName()).append(" SET ");
        SQLUtil.getSetClause(dirtyIterator, sql).append(" WHERE ");
        SQLUtil.getWhereClause(this.primaryKeyFields, sql);
        boolean hasLockedFields = this.entity.hasLockedFields(ctx);
        JDBCEntityBridge.FieldIterator lockedIterator = null;
        if (hasLockedFields) {
            lockedIterator = this.entity.getLockedIterator(ctx);
            while (lockedIterator.hasNext()) {
                sql.append(" AND ");
                JDBCCMPFieldBridge field = lockedIterator.next();
                if (field.getLockedValue(ctx) == null) {
                    SQLUtil.getIsNullClause(false, field, "", sql);
                    lockedIterator.remove();
                    continue;
                }
                SQLUtil.getWhereClause(field, sql);
            }
        }
        Connection con = null;
        PreparedStatement ps = null;
        int rowsAffected = 0;
        try {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Executing SQL: " + sql));
                }
                con = this.entity.getDataSource().getConnection();
                ps = con.prepareStatement(sql.toString());
                int index = 1;
                dirtyIterator.reset();
                while (dirtyIterator.hasNext()) {
                    index = dirtyIterator.next().setInstanceParameters(ps, index, ctx);
                }
                index = this.entity.setPrimaryKeyParameters(ps, index, ctx.getId());
                if (hasLockedFields) {
                    lockedIterator.reset();
                    while (lockedIterator.hasNext()) {
                        JDBCCMPFieldBridge field = lockedIterator.next();
                        Object value = field.getLockedValue(ctx);
                        index = field.setArgumentParameters(ps, index, value);
                    }
                }
                rowsAffected = ps.executeUpdate();
            }
            catch (EJBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(String.format("Store failed(%1$s)", sql.toString()), e);
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        if (rowsAffected != 1) {
            throw new EJBException("Update failed. Expected one affected row: rowsAffected=" + rowsAffected + ", id=" + ctx.getId());
        }
        dirtyIterator.reset();
        while (dirtyIterator.hasNext()) {
            dirtyIterator.next().setClean(ctx);
        }
    }
}

