/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import org.jboss.aop.AspectManager;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.ast.ASTAndCFlow;
import org.jboss.aop.pointcut.ast.ASTCFlow;
import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
import org.jboss.aop.pointcut.ast.ASTNotCFlow;
import org.jboss.aop.pointcut.ast.ASTOrCFlow;
import org.jboss.aop.pointcut.ast.ASTSubCFlow;
import org.jboss.aop.pointcut.ast.Node;

public class CFlowMatcher
extends MatcherHelper {
    StackTraceElement[] stack;
    Invocation invocation;

    public CFlowMatcher() {
        super(null, null);
    }

    public boolean matches(ASTCFlowExpression expr, Invocation invocation) {
        this.invocation = invocation;
        Boolean rtn = (Boolean)expr.jjtAccept(this, null);
        return rtn;
    }

    private StackTraceElement[] getStack() {
        this.stack = new Throwable().getStackTrace();
        return this.stack;
    }

    protected Boolean resolvePointcut(Pointcut p) {
        throw new RuntimeException("SHOULD NOT BE REACHABLE");
    }

    public Object visit(ASTCFlowExpression node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTCFlowBoolean node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTNotCFlow node, Object data) {
        Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        boolean val = bool;
        return val ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object visit(ASTCompositeCFlow node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTSubCFlow node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            data = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTAndCFlow node, Object left) {
        Node andChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val && (Boolean)andChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    public Object visit(ASTOrCFlow node, Object left) {
        Node orChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val || (Boolean)orChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    public Object visit(ASTCFlow node, Object data) {
        AspectManager manager = null;
        manager = this.invocation.getAdvisor() == null ? AspectManager.instance() : this.invocation.getAdvisor().getManager();
        CFlowStack cflow = manager.getCFlowStack(node.getPointcutName());
        if (cflow != null) {
            return new Boolean(cflow.matches(this.getStack()));
        }
        DynamicCFlow dcflow = manager.getDynamicCFlow(node.getPointcutName());
        return new Boolean(dcflow.shouldExecute(this.invocation));
    }
}

