/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.cache.client;

import com.dsoft.framework.cache.client.ClientDTOCache;
import com.dsoft.framework.client.DTOLoaderBase;
import com.dsoft.framework.client.GenericsHelper;
import com.dsoft.framework.client.base.ClientApplication;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.base.Operation;
import com.dsoft.framework.client.cache.CacheException;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.impl.OperationAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CacheOperation<T extends NumberIdDTO<KEY>, KEY extends Number>
extends OperationAdapter {
    protected Class<T> cacheClass;
    protected int keepTimeout;
    private static final Map<Class<?>, CacheOperation<?, ?>> cacheOperations = new HashMap();
    private final Set<KEY> keysForUpdate = new HashSet<KEY>();

    public static void modifyObject(NumberIdDTO<?> object, Number key) throws CacheException {
        ClientDTOCache.invalidateCacheObject(key, object.getClass().getName());
    }

    public static void modifyObjects(NumberIdDTO<?> object, Set<Number> keySet) throws CacheException {
        Class<?> type = CacheOperation.getCacheClass(object.getClass());
        ClientDTOCache.invalidateCacheObject(keySet, type.getName());
    }

    public static <T extends NumberIdDTO<KEY>, KEY extends Number> void registerObject(T object, KEY key) throws CacheException {
        Class<?> type = CacheOperation.getCacheClass(object.getClass());
        while (type != null) {
            ClientDTOCache.putCacheObject(key, type, object, CacheOperation.getCacheOperation(type).keepTimeout);
            type = CacheOperation.getCacheClass(type.getSuperclass());
        }
    }

    public static <T extends NumberIdDTO<KEY>, KEY extends Number> void registerObject(Class<T> type, KEY key) throws CacheException {
        while (type != null) {
            ClientDTOCache.addKeyToKeySet(type, key);
            type = CacheOperation.getCacheClass(type.getSuperclass());
        }
    }

    public static void removeObject(NumberIdDTO<?> object, Number key) throws CacheException {
        Class<?> type = CacheOperation.getCacheClass(object.getClass());
        ClientDTOCache.removeCacheObject(key, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getCacheClass(Class<?> cacheClass) {
        while (cacheClass != null) {
            Map<Class<?>, CacheOperation<?, ?>> map = cacheOperations;
            synchronized (map) {
                if (cacheOperations.get(cacheClass) != null) {
                    return cacheClass;
                }
                cacheClass = cacheClass.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> CacheOperation<T, KEY> getCacheOperation(Class<T> cacheClass) {
        Map<Class<?>, CacheOperation<?, ?>> map = cacheOperations;
        synchronized (map) {
            return cacheOperations.get(CacheOperation.getCacheClass(cacheClass));
        }
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> boolean initialized(Class<T> cacheClass) {
        if (CacheOperation.getCacheOperation(cacheClass) != null) {
            Operation cacheOperation = ClientApplication.getSessionManager().getRegisterOperation(CacheOperation.getCacheOperation(cacheClass).getClass().getName());
            return cacheOperation != null;
        }
        return false;
    }

    protected CacheOperation() {
        this(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheOperation(int timeOut) {
        Class<?> cacheClass = GenericsHelper.getGenericsClassType(this.getClass(), 0);
        if (cacheClass == null) {
            throw new RuntimeException(this.getClass().getName());
        }
        Map<Class<?>, CacheOperation<?, ?>> map = cacheOperations;
        synchronized (map) {
            cacheOperations.put(cacheClass, this);
        }
        this.cacheClass = cacheClass;
        this.keepTimeout = timeOut;
    }

    public void checkForModifications() throws DTOFindException {
        this.checkForModifications(new HashSet());
    }

    public void checkForModifications(KEY key) throws DTOFindException {
        HashSet<KEY> toIgnore = new HashSet<KEY>();
        toIgnore.add(key);
        this.checkForModifications((Set<KEY>)toIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForModifications(Set<KEY> toIgnore) throws DTOFindException {
        Set<KEY> set = this.keysForUpdate;
        synchronized (set) {
            for (Number key : this.keysForUpdate) {
                if (toIgnore.contains(key)) continue;
                this.updateForPk(key);
            }
            this.keysForUpdate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        Object object = this.keysForUpdate;
        synchronized (object) {
            this.keysForUpdate.clear();
        }
        object = cacheOperations;
        synchronized (object) {
            cacheOperations.remove(this.cacheClass);
        }
        this.cacheClass = null;
    }

    @Override
    protected final Object doOperation(Object value) throws Exception {
        return null;
    }

    public T getByPK(KEY key) throws DTOFindException {
        if (key != null) {
            return (T)((NumberIdDTO)DTOLoaderBase.getLoader().findByPrimaryKey(this.cacheClass, key));
        }
        return null;
    }

    protected Class<?> getCacheClass() {
        return this.cacheClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markForUpdate(KEY key) {
        Set<KEY> set = this.keysForUpdate;
        synchronized (set) {
            this.keysForUpdate.add(key);
        }
    }

    protected abstract void updateForPk(KEY var1) throws DTOFindException;
}

