/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.cache.client;

import com.dsoft.framework.cache.client.DTOCacheListener;
import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.ClientApplication;
import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.client.base.LongIdDTO;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.base.SessionManager;
import com.dsoft.framework.client.cache.CacheException;
import com.dsoft.framework.client.history.HistoryDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientDTOCache {
    private static final Set<DTOCacheListener<?>> listeners = new HashSet();
    public static final String KEY_SETS = "KEY_SETS";
    private static ThreadLocal<Integer> cacheLock = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<List<CacheAction<?>>> cacheActions = new ThreadLocal<List<CacheAction<?>>>(){

        @Override
        protected List<CacheAction<?>> initialValue() {
            return new ArrayList();
        }
    };
    private static final Set<String> finalClasses = new HashSet<String>();

    public static void lock() {
        cacheLock.set(cacheLock.get() + 1);
    }

    public static void unlock(boolean commit) throws CacheException {
        if (ClientDTOCache.isLocked()) {
            cacheLock.set(cacheLock.get() - 1);
        }
        if (!ClientDTOCache.isLocked()) {
            List<CacheAction<?>> actions = cacheActions.get();
            if (commit) {
                for (CacheAction<?> action : actions) {
                    action.perform();
                }
            }
            actions.clear();
        }
    }

    private static boolean isLocked() {
        return cacheLock.get() != 0;
    }

    private static String getDtoCacheName(Class<?> dtoType) {
        String result = null;
        while (dtoType != null && !finalClasses.contains(dtoType.getName())) {
            result = dtoType.getName();
            dtoType = dtoType.getSuperclass();
        }
        return result;
    }

    public static <T> T getCacheInstance(Object key, Class<T> dtoType) throws CacheException {
        return (T)ClientApplication.getSessionManager().getCacheValue(ClientDTOCache.getDtoCacheName(dtoType), key);
    }

    public static void clearCacheObjects(Class<?> clearType) throws CacheException {
        String cacheName = ClientDTOCache.getDtoCacheName(clearType);
        Set cacheKeys = (Set)ClientApplication.getSessionManager().getCacheValue(KEY_SETS, clearType);
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            ClientDTOCache.invalidateCacheObject(cacheKeys, cacheName);
        }
    }

    public static <PK extends Number> void invalidateCacheObject(PK key, final String className) throws CacheException {
        try {
            Class<?> type = Class.forName(className);
            if (ClientDTOCache.isLocked()) {
                cacheActions.get().add(new CacheAction<PK>(key, type){

                    @Override
                    void perform() throws CacheException {
                        ClientDTOCache.invalidateCacheObject((Number)this.key, className);
                    }
                });
            } else {
                Object instance = ClientDTOCache.getCacheInstance(key, type);
                Class<?> instanceType = ClientDTOCache.getInstanceClass(instance, type);
                ClientDTOCache.fireObjectModified(instanceType, key, true);
                if (instance != null) {
                    ClientApplication.getSessionManager().removeCacheValue(className, key);
                } else {
                    ClientDTOCache.addKeyToKeySet(type, key);
                }
                ClientDTOCache.fireObjectModified(instanceType, key, false);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static <K extends Number> void invalidateCacheObject(Collection<K> keys, final String className) throws CacheException {
        try {
            Class<?> type = Class.forName(className);
            if (ClientDTOCache.isLocked()) {
                cacheActions.get().add(new CacheAction<Collection<K>>(keys, type){

                    @Override
                    void perform() throws CacheException {
                        ClientDTOCache.invalidateCacheObject((Collection)this.key, className);
                    }
                });
            } else {
                Map<Class<?>, List<K>> keyMap = ClientDTOCache.getCacheItemsMap(keys, type);
                SessionManager sessionManager = ClientApplication.getSessionManager();
                for (Class<?> instanceType : keyMap.keySet()) {
                    List<K> keyList = keyMap.get(instanceType);
                    ClientDTOCache.fireObjectsModified(instanceType, keyList, true);
                    for (K key : keyList) {
                        Object object = ClientDTOCache.getCacheInstance(key, type);
                        if (object != null) {
                            sessionManager.removeCacheValue(ClientDTOCache.getDtoCacheName(type), key);
                            continue;
                        }
                        ClientDTOCache.addKeyToKeySet(type, key);
                    }
                    ClientDTOCache.fireObjectsModified(instanceType, keyList, false);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private static Class<?> getInstanceClass(Object instance, Class<?> type) throws ClassNotFoundException {
        Class<?> instanceType = instance != null ? instance.getClass() : type;
        return instanceType;
    }

    public static void putCacheObject(Object key, Class<?> type, Object value) throws CacheException {
        ClientDTOCache.putCacheObject(key, type, value, 60);
    }

    public static void putCacheObject(Object key, Class<?> type, Object value, int timeOut) throws CacheException {
        if (ClientDTOCache.isLocked()) {
            cacheActions.get().add(new PutCacheAction(key, type, value, timeOut));
        } else {
            int cachePolicy = 2;
            if (timeOut == -1) {
                cachePolicy = 0;
            }
            SessionManager sessionManager = ClientApplication.getSessionManager();
            sessionManager.putCacheValue(ClientDTOCache.getDtoCacheName(type), key, value, cachePolicy, timeOut);
            ClientDTOCache.addKeyToKeySet(type, key);
        }
    }

    public static <K extends Number> void removeCacheObject(K key, Class<?> type) throws CacheException {
        try {
            if (ClientDTOCache.isLocked()) {
                cacheActions.get().add(new CacheAction<K>(key, type){

                    @Override
                    void perform() throws CacheException {
                        ClientDTOCache.removeCacheObject((Number)this.key, this.type);
                    }
                });
            } else {
                Object object = ClientDTOCache.getCacheInstance(key, type);
                Class<?> objectClass = ClientDTOCache.getInstanceClass(object, type);
                ClientDTOCache.fireObjectRemoved(objectClass, key);
                if (object != null) {
                    ClientApplication.getSessionManager().removeCacheValue(ClientDTOCache.getDtoCacheName(type), key);
                }
                ClientDTOCache.removeKeyFromKeySet(type, key);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static <K extends Number> void removeCacheObject(Collection<K> keys, Class<?> type) throws CacheException {
        try {
            if (ClientDTOCache.isLocked()) {
                cacheActions.get().add(new CacheAction<Collection<K>>(keys, type){

                    @Override
                    void perform() throws CacheException {
                        ClientDTOCache.removeCacheObject((Collection)this.key, this.type);
                    }
                });
            } else {
                Map<Class<?>, List<K>> keyMap = ClientDTOCache.getCacheItemsMap(keys, type);
                SessionManager sessionManager = ClientApplication.getSessionManager();
                for (Class<?> objectClass : keyMap.keySet()) {
                    List<K> keyList = keyMap.get(objectClass);
                    ClientDTOCache.fireObjectsRemoved(objectClass, keyList);
                    for (Number key : keyList) {
                        Object object = ClientDTOCache.getCacheInstance(key, type);
                        if (object != null) {
                            sessionManager.removeCacheValue(ClientDTOCache.getDtoCacheName(type), key);
                        }
                        ClientDTOCache.removeKeyFromKeySet(type, key);
                    }
                }
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private static <K extends Number> Map<Class<?>, List<K>> getCacheItemsMap(Collection<K> keys, Class<?> type) throws CacheException, ClassNotFoundException {
        HashMap keyMap = new HashMap();
        for (Number key : keys) {
            Object object = ClientDTOCache.getCacheInstance(key, type);
            Class<?> objectClass = ClientDTOCache.getInstanceClass(object, type);
            ArrayList<Number> keyList = (ArrayList<Number>)keyMap.get(objectClass);
            if (keyList == null) {
                keyList = new ArrayList<Number>();
                keyMap.put(objectClass, keyList);
            }
            keyList.add(key);
        }
        return keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends NumberIdDTO<KEY>, KEY extends Number> Set<KEY> getCacheKeySetForType(Class<?> type) throws CacheException {
        Class<?> clazz = type;
        synchronized (clazz) {
            HashSet keySet = (HashSet)ClientApplication.getSessionManager().getCacheValue(KEY_SETS, type);
            if (keySet == null) {
                keySet = new HashSet();
            }
            return keySet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKeyToKeySet(Class<?> type, Object key) throws CacheException {
        Class<?> clazz = type;
        synchronized (clazz) {
            SessionManager sessionManager = ClientApplication.getSessionManager();
            HashSet<Object> keySet = (HashSet<Object>)sessionManager.getCacheValue(KEY_SETS, type);
            if (keySet == null) {
                keySet = new HashSet<Object>();
            }
            keySet.add(key);
            sessionManager.putCacheValue(KEY_SETS, type, keySet, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeKeyFromKeySet(Class<?> type, Object key) throws CacheException {
        Class<?> clazz = type;
        synchronized (clazz) {
            SessionManager sessionManager = ClientApplication.getSessionManager();
            Set keySet = (Set)sessionManager.getCacheValue(KEY_SETS, type);
            if (keySet != null) {
                keySet.remove(key);
                sessionManager.putCacheValue(KEY_SETS, type, keySet, 0, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDtoCacheListener(DTOCacheListener<?> listener) {
        Set<DTOCacheListener<?>> set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDtoCacheListener(DTOCacheListener<?> listener) {
        Set<DTOCacheListener<?>> set = listeners;
        synchronized (set) {
            listeners.remove(listener);
        }
    }

    private static <PK extends Number> void fireObjectModified(Class<?> type, PK key, boolean beforeModify) {
        for (DTOCacheListener dtoCacheListener : ClientDTOCache.duplicateListeners()) {
            dtoCacheListener.objectModified(type, key, beforeModify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DTOCacheListener> duplicateListeners() {
        ArrayList<DTOCacheListener> tmpListeners;
        Set<DTOCacheListener<?>> set = listeners;
        synchronized (set) {
            tmpListeners = new ArrayList<DTOCacheListener>(listeners);
        }
        return tmpListeners;
    }

    private static <PK extends Number> void fireObjectsModified(Class<?> type, Collection<PK> keys, boolean beforeModify) {
        for (DTOCacheListener dtoCacheListener : ClientDTOCache.duplicateListeners()) {
            dtoCacheListener.objectsModified(type, keys, beforeModify);
        }
    }

    private static <PK extends Number> void fireObjectRemoved(Class<?> type, PK key) {
        for (DTOCacheListener dtoCacheListener : ClientDTOCache.duplicateListeners()) {
            dtoCacheListener.objectRemoved(type, key);
        }
    }

    private static <PK extends Number> void fireObjectsRemoved(Class<?> type, Collection<PK> keys) {
        for (DTOCacheListener dtoCacheListener : ClientDTOCache.duplicateListeners()) {
            dtoCacheListener.objectsRemoved(type, keys);
        }
    }

    static {
        finalClasses.add(BaseDTO.class.getName());
        finalClasses.add(HistoryDTO.class.getName());
        finalClasses.add(IntegerIdDTO.class.getName());
        finalClasses.add(LongIdDTO.class.getName());
    }

    static class PutCacheAction
    extends CacheAction<Object> {
        Object value;
        int timeOut;

        PutCacheAction(Object key, Class<?> type, Object value, int timeOut) {
            super(key, type);
            this.timeOut = timeOut;
            this.value = value;
        }

        @Override
        void perform() throws CacheException {
            if (this.key != null && this.type != null) {
                ClientDTOCache.putCacheObject(this.key, this.type, this.value, this.timeOut);
            }
        }
    }

    static abstract class CacheAction<K> {
        K key;
        Class<?> type;

        CacheAction(K key, Class<?> type) {
            this.key = key;
            this.type = type;
        }

        abstract void perform() throws CacheException;
    }
}

