/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.cache.client;

import com.dsoft.framework.cache.client.CacheOperation;
import com.dsoft.framework.cache.client.ClientDTOCache;
import com.dsoft.framework.client.DTOLoader;
import com.dsoft.framework.client.DTOLoaderBase;
import com.dsoft.framework.client.annotation.FrameworkItem;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.cache.CacheException;
import com.dsoft.framework.client.cache.ObjectFinderCriterion;
import com.dsoft.framework.client.exception.DSoftException;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.logger.client.LogUtilClient;
import com.dsoft.framework.logger.client.Logger;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@FrameworkItem(name="Base DTO Cache operation", description="Cache object access operation")
public abstract class DTOCacheOperation<T extends NumberIdDTO<PK>, PK extends Number>
extends CacheOperation<T, PK>
implements DTOLoader<T, PK> {
    private static final Logger LOGGER = Logger.getLogger(DTOCacheOperation.class);
    private static final long CacheLoadTIMEOUT = 600000L;
    private static ExecutorService cacheLoadService = null;
    private Future<?> cacheTask;

    protected DTOCacheOperation(int timeOut) {
        super(timeOut);
    }

    protected DTOCacheOperation() {
    }

    protected void putCollectionIntoCache(Collection<T> objects) throws CacheException {
        for (NumberIdDTO dto : objects) {
            DTOCacheOperation.registerObject(dto, dto.getNumberId());
        }
    }

    @Override
    public void finalizeInitialization(int initializeState) {
        if (this.cacheTask == null) {
            DTOLoaderBase.getLoader().registerLoader(this.cacheClass, this);
            try {
                this.fillCache();
            }
            catch (DSoftException dSoftException) {
                // empty catch block
            }
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.cacheTask != null) {
            if (!this.cacheTask.isDone()) {
                this.cacheTask.cancel(true);
            }
            this.cacheTask = null;
        }
        if (cacheLoadService != null) {
            cacheLoadService.shutdownNow();
            cacheLoadService = null;
        }
    }

    protected abstract Collection<T> loadCache() throws Exception;

    @Override
    public Class<T> getCacheType() {
        return this.cacheClass;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> boolean waitForCacheLoaded(Class<T> cacheClass) throws Throwable {
        long loadTimeOut;
        if (Beans.isDesignTime()) {
            return false;
        }
        DTOCacheOperation<T, KEY> cacheOperation = DTOCacheOperation.getDTOCacheOperation(cacheClass);
        try {
            for (loadTimeOut = 600000L; cacheOperation == null && loadTimeOut > 0L; loadTimeOut -= 10L) {
                cacheOperation = DTOCacheOperation.getDTOCacheOperation(cacheClass);
                Thread.sleep(10L);
            }
            if (loadTimeOut < 0L) {
                return false;
            }
        }
        catch (InterruptedException ex) {
            return false;
        }
        while (!DTOCacheOperation.cacheLoaded(cacheClass)) {
            if (DTOCacheOperation.cacheLoading(cacheClass)) continue;
            cacheOperation.cacheTask.get(loadTimeOut, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    private static <T extends NumberIdDTO<KEY>, KEY extends Number> DTOCacheOperation<T, KEY> getDTOCacheOperation(Class<T> cacheClass) {
        if (DTOCacheOperation.initialized(cacheClass)) {
            return (DTOCacheOperation)DTOCacheOperation.getCacheOperation(cacheClass);
        }
        return null;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> boolean cacheLoaded(Class<T> cacheClass) {
        if (DTOCacheOperation.initialized(cacheClass)) {
            try {
                DTOCacheOperation<T, KEY> operation = DTOCacheOperation.getDTOCacheOperation(cacheClass);
                return operation != null && operation.cacheTask != null && operation.cacheTask.isDone();
            }
            catch (Throwable ex) {
                LogUtilClient.error(LOGGER, String.format("Error while executing cacheLoaded for cache class %1$s", cacheClass.getSimpleName()), ex);
            }
        }
        return false;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> boolean cacheLoading(Class<T> cacheClass) {
        if (DTOCacheOperation.initialized(cacheClass)) {
            DTOCacheOperation<T, KEY> operation = DTOCacheOperation.getDTOCacheOperation(cacheClass);
            return operation != null && operation.cacheTask != null && !operation.cacheTask.isDone();
        }
        return false;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> List<T> getAllElements(Class<T> cacheClass) throws DTOFindException {
        return DTOCacheOperation.getElements(cacheClass, DTOCacheOperation.getPkSet(cacheClass));
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> List<T> getElements(Class<T> cacheClass, Set<KEY> pkSet) throws DTOFindException {
        ArrayList<T> result = new ArrayList<T>();
        try {
            if (DTOCacheOperation.waitForCacheLoaded(cacheClass)) {
                for (Number pk : pkSet) {
                    result.add(DTOLoaderBase.getLoader().findByPrimaryKey(cacheClass, pk));
                }
            }
        }
        catch (Throwable ex) {
            throw new DTOFindException(ex);
        }
        return result;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> Set<KEY> getPkSet(Class<T> cacheClass) throws DTOFindException {
        try {
            if (DTOCacheOperation.waitForCacheLoaded(cacheClass)) {
                return ClientDTOCache.getCacheKeySetForType(cacheClass);
            }
        }
        catch (Throwable ex) {
            throw new DTOFindException(ex);
        }
        return new HashSet();
    }

    public static <T extends NumberIdDTO<KEY>, KEY extends Number> T registerNewDTO(T dto) throws CacheException {
        DTOCacheOperation.registerObject(dto, dto.getNumberId());
        return dto;
    }

    public static <T extends NumberIdDTO<KEY>, KEY extends Number> void removeDTO(T dto) throws CacheException {
        DTOCacheOperation.removeObject(dto, dto.getNumberId());
    }

    public static <T extends NumberIdDTO<KEY>, KEY extends Number> T modifyDTO(T dto) throws CacheException {
        DTOCacheOperation.modifyObject(dto, dto.getNumberId());
        return dto;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> Map<KEY, T> getAllElementsAsMap(Class<T> cacheClass) throws DTOFindException {
        HashMap<Number, T> result = new HashMap<Number, T>();
        try {
            if (DTOCacheOperation.waitForCacheLoaded(cacheClass)) {
                Set<Number> pkSet = ClientDTOCache.getCacheKeySetForType(cacheClass);
                for (Number pk : pkSet) {
                    result.put(pk, DTOLoaderBase.getLoader().findByPrimaryKey(cacheClass, pk));
                }
            }
        }
        catch (Throwable ex) {
            throw new DTOFindException(ex);
        }
        return result;
    }

    public static <T extends NumberIdDTO<KEY>, KEY extends Number> Collection<T> findByCriterion(Collection<T> source, ObjectFinderCriterion<T, KEY> ofc) throws Exception {
        ArrayList<T> result = new ArrayList<T>(source);
        for (int i = result.size() - 1; i >= 0; --i) {
            NumberIdDTO baseDto = (NumberIdDTO)result.get(i);
            if (baseDto != null && ofc.acceptObject(baseDto.getNumberId(), baseDto)) continue;
            result.remove(i);
        }
        return result;
    }

    protected static <T extends NumberIdDTO<KEY>, KEY extends Number> Collection<T> findByCriterion(Class<T> cacheClass, ObjectFinderCriterion<T, KEY> ofc) throws Exception {
        return DTOCacheOperation.findByCriterion(DTOCacheOperation.getAllElements(cacheClass), ofc);
    }

    @Override
    public final Collection<T> fillCache() throws DSoftException {
        this.cacheTask = this.getCacheLoadService().submit(new CacheLoadTask());
        return null;
    }

    private ExecutorService getCacheLoadService() {
        if (cacheLoadService == null) {
            cacheLoadService = Executors.newFixedThreadPool(3);
        }
        return cacheLoadService;
    }

    class CacheLoadTask
    implements Callable<Object> {
        CacheLoadTask() {
        }

        @Override
        public Object call() throws Exception {
            try {
                Collection collection = DTOCacheOperation.this.loadCache();
                if (collection != null) {
                    DTOCacheOperation.this.putCollectionIntoCache(collection);
                }
            }
            catch (Exception ex) {
                System.err.println(DTOCacheOperation.this.getCacheClass().getSimpleName());
                ex.printStackTrace();
            }
            return null;
        }
    }
}

