/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client;

import com.dsoft.framework.client.DTOLoader;
import com.dsoft.framework.client.DTOLoaderFactory;
import com.dsoft.framework.client.DTOLoaderService;
import com.dsoft.framework.client.exception.DTOFindException;
import java.io.Serializable;
import java.util.Set;

public abstract class DTOLoaderBase
implements DTOLoaderService {
    private static ThreadLocal<DTOLoaderService> threadVar = new ThreadLocal();
    private static DTOLoaderFactory loaderFactory;

    public static synchronized DTOLoaderService getLoader() {
        if (loaderFactory == null) {
            return null;
        }
        if (threadVar.get() == null) {
            return loaderFactory.getLoader();
        }
        return threadVar.get();
    }

    public static void setLoaderFactory(DTOLoaderFactory factory) {
        loaderFactory = factory;
    }

    protected DTOLoaderBase() {
    }

    public static void clear() {
        if (loaderFactory == null) {
            return;
        }
        if (threadVar.get() == null) {
            loaderFactory.releaseLoader();
        }
    }

    private boolean checkForCacheService() throws Exception {
        return true;
    }

    @Override
    public boolean supportsCaching() {
        try {
            return this.checkForCacheService();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public <T extends Serializable, PK extends Number> void registerLoader(Class<T> type, DTOLoader<T, PK> loader) {
        throw new Error("Unsupported");
    }

    @Override
    public <T extends Serializable, PK extends Number> void scheduleForLoad(Class<T> type, Set<PK> pks, PK pk) throws DTOFindException {
        if (this != DTOLoaderBase.getLoader()) {
            DTOLoaderBase.getLoader().scheduleForLoad(type, pks, pk);
        }
    }
}

