/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class LongInterval
implements Serializable,
Comparable<LongInterval> {
    private static final long serialVersionUID = 14429137840324296L;
    private long begin;
    private long end;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public LongInterval(LongInterval interval) {
        this.begin = interval.getBegin();
        this.end = interval.getEnd();
    }

    public LongInterval(Long begin, Long end) {
        this.begin = begin != null ? begin : Long.MIN_VALUE;
        this.end = end != null ? end : Long.MAX_VALUE;
    }

    public LongInterval(long begin, long end) {
        this.begin = begin;
        this.end = end;
    }

    public void setInterval(LongInterval interval) {
        this.begin = interval.getBegin();
        this.end = interval.getEnd();
    }

    public int hashCode() {
        return (int)this.begin * 17 + (int)this.end * 17;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof LongInterval) {
            LongInterval other = (LongInterval)obj;
            return this.begin == other.begin && this.end == other.end;
        }
        return false;
    }

    public boolean includes(LongInterval interval) {
        return this.contains(interval.getBegin()) && this.contains(interval.getEnd());
    }

    public long getEnd() {
        return this.end;
    }

    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long begin) {
        this.begin = begin;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public boolean contains(long time) {
        return time >= (this.begin != 0L ? this.begin : Long.MIN_VALUE) && time <= (this.end != 0L ? this.end : Long.MAX_VALUE);
    }

    public long size() {
        return this.end - this.begin;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.begin > Long.MIN_VALUE) {
            sb.append(dateFormat.format(new Date(this.begin)));
        } else {
            sb.append("");
        }
        sb.append(" - ");
        if (this.end < 0x7FFFFFFFFFFFFFFEL) {
            sb.append(dateFormat.format(new Date(this.end)));
        } else {
            sb.append("+");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(LongInterval o) {
        int result = new Long(this.begin).compareTo(o.begin);
        if (result == 0) {
            result = new Long(this.end).compareTo(o.end);
        }
        return result;
    }

    public void resizeInterval(long fromLeft, long fromRight) {
        this.begin -= fromLeft;
        this.end += fromRight;
    }

    public void moveInterval(long newBegin) {
        this.end = newBegin + this.size();
        this.begin = newBegin;
    }

    public static List<LongInterval> mergeIntervals(Collection<? extends LongInterval> intervals) {
        ArrayList<LongInterval> result;
        block5: {
            result = new ArrayList<LongInterval>();
            while (intervals.size() > 1) {
                ArrayList<? extends LongInterval> intervalsList = new ArrayList<LongInterval>(intervals);
                Collections.sort(intervalsList);
                result.clear();
                LongInterval temp = new LongInterval((LongInterval)intervalsList.iterator().next());
                boolean changed = false;
                for (LongInterval longInterval : intervalsList) {
                    if (temp.contains(longInterval.getBegin())) {
                        if (temp.contains(longInterval.getEnd())) continue;
                        temp.setEnd(longInterval.getEnd());
                        changed = true;
                        continue;
                    }
                    if (temp.contains(longInterval.getEnd())) {
                        temp.setBegin(longInterval.getBegin());
                        changed = true;
                        continue;
                    }
                    result.add(temp);
                    temp = new LongInterval(longInterval);
                }
                result.add(temp);
                if (changed) {
                    intervals = new ArrayList<LongInterval>(result);
                    continue;
                }
                break block5;
            }
            result.clear();
            result.addAll(intervals);
        }
        Collections.sort(result);
        return result;
    }

    public static LongInterval intersect(LongInterval interval1, LongInterval interval2) {
        long resultBegin = Long.MAX_VALUE;
        long resultEnd = Long.MIN_VALUE;
        if (interval1.contains(interval2.getBegin())) {
            resultBegin = interval2.getBegin();
        } else if (interval2.contains(interval1.getBegin())) {
            resultBegin = interval1.getBegin();
        }
        if (interval1.contains(interval2.getEnd())) {
            resultEnd = interval2.getEnd();
        } else if (interval2.contains(interval1.getEnd())) {
            resultEnd = interval1.getEnd();
        }
        if (resultBegin == Long.MAX_VALUE) {
            return null;
        }
        return new LongInterval(resultBegin, resultEnd);
    }

    public static Collection<LongInterval> subtract(LongInterval interval1, LongInterval interval2) {
        ArrayList<LongInterval> result = new ArrayList<LongInterval>();
        LongInterval intersection = LongInterval.intersect(interval1, interval2);
        if (intersection != null) {
            if (interval2.equals(intersection)) {
                if (interval1.size() != interval2.size()) {
                    LongInterval ti = new LongInterval(interval1.getBegin(), interval2.getBegin());
                    if (ti.size() > 0L) {
                        result.add(ti);
                    }
                    if ((ti = new LongInterval(interval2.getEnd(), interval1.getEnd())).size() > 0L) {
                        result.add(ti);
                    }
                    return result;
                }
                return result;
            }
            if (interval1.getBegin() == intersection.getBegin()) {
                result.add(new LongInterval(intersection.getEnd(), interval1.getEnd()));
            } else {
                result.add(new LongInterval(interval1.getBegin(), intersection.getBegin()));
            }
        }
        return result;
    }
}

