/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client;

import com.dsoft.framework.client.base.ClientApplication;
import com.dsoft.framework.logger.client.LogUtilClient;
import com.dsoft.framework.logger.client.Logger;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public abstract class MessageListenerBase {
    private static final Logger LOGGER = Logger.getLogger(MessageListenerBase.class);
    private String topicName;
    private Session session;
    private Connection connection;
    private MessageConsumer subscriber;
    private Context context;
    private ScheduledExecutorService reconnectService = Executors.newSingleThreadScheduledExecutor();
    private int reconnect = 0;
    private MessageListener listener;
    private boolean notifyApplication;

    public MessageListenerBase(Context context) {
        this.context = context;
    }

    protected boolean connect(String topicName, MessageListener listener, boolean notifyApplication) throws Exception {
        this.topicName = topicName;
        this.listener = listener;
        this.notifyApplication = notifyApplication;
        try {
            return this.attachToTopic(this.context, topicName, listener);
        }
        catch (Exception ex) {
            LogUtilClient.error(LOGGER, "Error while initializing topic connection", ex);
            throw ex;
        }
    }

    protected abstract String getPrefix();

    protected boolean attachToTopic(final Context context, String topicName, MessageListener listener) throws Exception {
        Topic topic;
        ConnectionFactory tcf = (ConnectionFactory)context.lookup("ConnectionFactory");
        this.connection = tcf.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
        Random r = new Random(System.nanoTime());
        Thread.sleep(r.nextInt(500));
        boolean existing = true;
        while (true) {
            try {
                topic = (Topic)context.lookup(this.getPrefix() + topicName);
            }
            catch (NamingException ne) {
                existing = false;
                if (this.exceptionWhileConnecting()) continue;
                throw ne;
            }
            break;
        }
        this.connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                if (exception.getCause() instanceof IOException) {
                    try {
                        MessageListenerBase.this.session.recover();
                    }
                    catch (JMSException ex) {
                        if (MessageListenerBase.this.notifyApplication) {
                            ClientApplication.getSessionManager().connectionLost();
                        }
                        MessageListenerBase.this.topicName = MessageListenerBase.this.detachFromTopic();
                        MessageListenerBase.this.reconnectService.schedule(new ReconnectEventListener(context), 2L, TimeUnit.SECONDS);
                    }
                }
            }
        });
        this.subscriber = this.session.createConsumer((Destination)topic);
        this.subscriber.setMessageListener(listener);
        return existing;
    }

    protected abstract boolean exceptionWhileConnecting() throws Exception;

    public boolean isClosed() {
        return this.topicName == null;
    }

    protected String detachFromTopic() {
        try {
            if (this.connection != null) {
                this.connection.setExceptionListener(null);
            }
        }
        catch (JMSException ex) {
            LogUtilClient.error(LOGGER, "Error while detaching topic listener", ex);
        }
        try {
            if (this.subscriber != null) {
                this.subscriber.close();
                this.subscriber = null;
            }
        }
        catch (JMSException ex) {
            LogUtilClient.error(LOGGER, "Error while detaching topic listener", ex);
        }
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (JMSException ex) {
            LogUtilClient.error(LOGGER, "Error while detaching topic listener", ex);
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (JMSException ex) {
            LogUtilClient.error(LOGGER, "Error while detaching topic listener", ex);
        }
        String tmp = this.topicName;
        this.topicName = null;
        return tmp;
    }

    protected void createTopic(String jmsName) throws Exception {
        RMIAdaptor server = (RMIAdaptor)this.context.lookup("jmx/invoker/RMIAdaptor");
        ObjectName name = new ObjectName("jboss.mq:service=DestinationManager");
        try {
            server.invoke(name, "destroyTopic", new Object[]{jmsName}, new String[]{"java.lang.String"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        server.invoke(name, "createTopic", new Object[]{jmsName}, new String[]{"java.lang.String"});
    }

    protected void destroyTopic(String queueName) throws Exception {
        RMIAdaptor server = (RMIAdaptor)this.context.lookup("jmx/invoker/RMIAdaptor");
        ObjectName name = new ObjectName("jboss.mq:service=DestinationManager");
        try {
            server.invoke(name, "destroyTopic", new Object[]{queueName}, new String[]{"java.lang.String"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    private class ReconnectEventListener
    implements Runnable {
        private Context context;

        ReconnectEventListener(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            block3: {
                MessageListenerBase.this.reconnect++;
                try {
                    MessageListenerBase.this.attachToTopic(this.context, MessageListenerBase.this.topicName, MessageListenerBase.this.listener);
                    MessageListenerBase.this.reconnect = 0;
                    if (MessageListenerBase.this.notifyApplication) {
                        ClientApplication.getSessionManager().connectionRestored();
                    }
                }
                catch (Exception ex) {
                    MessageListenerBase.this.topicName = MessageListenerBase.this.detachFromTopic();
                    if (MessageListenerBase.this.reconnect > 4 && (!MessageListenerBase.this.notifyApplication || ClientApplication.getSessionManager().connectionClosed())) break block3;
                    MessageListenerBase.this.reconnectService.schedule(new ReconnectEventListener(this.context), 10L, TimeUnit.SECONDS);
                }
            }
        }
    }
}

