/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client;

import com.dsoft.framework.client.RemoteCall;
import com.dsoft.framework.client.RemoteVoid;
import com.dsoft.framework.client.base.ClientApplication;
import java.rmi.AccessException;
import java.util.Stack;

public class RemoteCallUtil {
    public static final ThreadLocal<Stack<Object>> ownersStack = new ThreadLocal<Stack<Object>>(){

        @Override
        protected Stack<Object> initialValue() {
            return new Stack<Object>();
        }
    };

    public static void performRemoteCall(RemoteVoid callObject) throws Exception {
        RemoteCallUtil.performRemoteCall((Object)callObject, callObject);
    }

    public static <T> T performRemoteCall(RemoteCall<T> callObject) throws Exception {
        return RemoteCallUtil.performRemoteCall(callObject, callObject);
    }

    public static void performRemoteCall(Object owner, final RemoteVoid callObject) throws Exception {
        RemoteCallUtil.performRemoteCall(owner, new RemoteCall<Object>(){

            @Override
            public Object perform() throws Exception {
                callObject.perform();
                return null;
            }
        }, null);
    }

    public static <T> T performRemoteCall(Object owner, RemoteCall<T> callObject) throws Exception {
        return RemoteCallUtil.performRemoteCall(owner, callObject, null);
    }

    private static <T> T performRemoteCall(Object owner, RemoteCall<T> callObject, Object dummy) throws Exception {
        ownersStack.get().push(owner);
        try {
            T t = callObject.perform();
            return t;
        }
        catch (AccessException ex) {
            ClientApplication.getSessionManager().releaseManagers(owner, ex);
            throw ex;
        }
        finally {
            ownersStack.get().pop();
            ClientApplication.getSessionManager().releaseManagers(owner);
        }
    }
}

