/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TimeInterval
implements Serializable,
Comparable<TimeInterval> {
    private static final long serialVersionUID = -5783970542789348339L;
    private long begin;
    private long end;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public TimeInterval(Date begin, Date end) {
        this.begin = begin != null ? begin.getTime() : Long.MIN_VALUE;
        this.end = end != null ? end.getTime() : Long.MAX_VALUE;
    }

    public TimeInterval(TimeInterval interval) {
        this.begin = interval.getBegin();
        this.end = interval.getEnd();
    }

    public TimeInterval(Long begin, Long end) {
        this.begin = begin != null ? begin : Long.MIN_VALUE;
        this.end = end != null ? end : Long.MAX_VALUE;
    }

    public TimeInterval() {
        this((Long)null, null);
    }

    public TimeInterval(long begin, long end) {
        this.begin = begin;
        this.end = end;
    }

    public void setInterval(TimeInterval interval) {
        this.begin = interval.getBegin();
        this.end = interval.getEnd();
    }

    public Date getBeginDate() {
        return this.begin != Long.MIN_VALUE ? new Date(this.begin) : null;
    }

    public Date getEndDate() {
        return this.end != Long.MAX_VALUE ? new Date(this.end) : null;
    }

    public int hashCode() {
        return (int)this.begin * 17 + (int)this.end * 17;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof TimeInterval) {
            TimeInterval other = (TimeInterval)obj;
            return this.begin == other.begin && this.end == other.end;
        }
        return false;
    }

    public boolean includes(TimeInterval interval) {
        return this.contains(interval.getBegin()) && this.contains(interval.getEnd());
    }

    public long getEnd() {
        return this.end;
    }

    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long begin) {
        this.begin = begin;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public boolean contains(long time) {
        return time >= (this.begin != 0L ? this.begin : Long.MIN_VALUE) && time <= (this.end != 0L ? this.end : Long.MAX_VALUE);
    }

    public boolean isZeroSize() {
        return (double)this.end - (double)this.begin == 0.0;
    }

    public double size() {
        return (double)this.end - (double)this.begin;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.begin > Long.MIN_VALUE) {
            sb.append(dateFormat.format(new Date(this.begin)));
        } else {
            sb.append("");
        }
        sb.append(" - ");
        if (this.end < 0x7FFFFFFFFFFFFFFEL) {
            sb.append(dateFormat.format(new Date(this.end)));
        } else {
            sb.append("+");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(TimeInterval o) {
        int result = new Long(this.begin).compareTo(o.begin);
        if (result == 0) {
            result = new Long(this.end).compareTo(o.end);
        }
        return result;
    }

    public void resizeInterval(long fromLeft, long fromRight) {
        this.begin -= fromLeft;
        this.end += fromRight;
    }

    public void moveInterval(long newBegin) {
        this.end = newBegin + (long)this.size();
        this.begin = newBegin;
    }

    public static List<TimeInterval> mergeIntervals(Collection<? extends TimeInterval> intervals) {
        ArrayList<TimeInterval> result;
        block5: {
            result = new ArrayList<TimeInterval>();
            while (intervals.size() > 1) {
                ArrayList<? extends TimeInterval> intervalsList = new ArrayList<TimeInterval>(intervals);
                Collections.sort(intervalsList);
                result.clear();
                TimeInterval temp = new TimeInterval((TimeInterval)intervalsList.iterator().next());
                boolean changed = false;
                for (TimeInterval timeInterval : intervalsList) {
                    if (temp.contains(timeInterval.getBegin())) {
                        if (temp.contains(timeInterval.getEnd())) continue;
                        temp.setEnd(timeInterval.getEnd());
                        changed = true;
                        continue;
                    }
                    if (temp.contains(timeInterval.getEnd())) {
                        temp.setBegin(timeInterval.getBegin());
                        changed = true;
                        continue;
                    }
                    result.add(temp);
                    temp = new TimeInterval(timeInterval);
                }
                result.add(temp);
                if (changed) {
                    intervals = new ArrayList<TimeInterval>(result);
                    continue;
                }
                break block5;
            }
            result.clear();
            result.addAll(intervals);
        }
        Collections.sort(result);
        return result;
    }

    public static List<TimeInterval> intersect(List<? extends TimeInterval> timeIntervals, TimeInterval timeInterval) {
        ArrayList<TimeInterval> intersections = new ArrayList<TimeInterval>();
        for (TimeInterval timeInterval2 : timeIntervals) {
            TimeInterval intersect = TimeInterval.intersect(timeInterval2, timeInterval);
            if (intersect == null || intersect.isZeroSize()) continue;
            intersections.add(intersect);
        }
        return TimeInterval.mergeIntervals(intersections);
    }

    public static TimeInterval intersect(TimeInterval interval1, TimeInterval interval2) {
        long resultBegin = Long.MAX_VALUE;
        long resultEnd = Long.MIN_VALUE;
        if (interval1.contains(interval2.getBegin())) {
            resultBegin = interval2.getBegin();
        } else if (interval2.contains(interval1.getBegin())) {
            resultBegin = interval1.getBegin();
        }
        if (interval1.contains(interval2.getEnd())) {
            resultEnd = interval2.getEnd();
        } else if (interval2.contains(interval1.getEnd())) {
            resultEnd = interval1.getEnd();
        }
        if (resultBegin == Long.MAX_VALUE) {
            return null;
        }
        return new TimeInterval(resultBegin, resultEnd);
    }

    public static List<TimeInterval> subtract(TimeInterval interval1, TimeInterval interval2) {
        ArrayList<TimeInterval> result = new ArrayList<TimeInterval>();
        TimeInterval intersection = TimeInterval.intersect(interval1, interval2);
        if (intersection != null) {
            if (interval2.equals(intersection)) {
                if (interval1.size() != interval2.size()) {
                    TimeInterval ti = new TimeInterval(interval1.getBegin(), interval2.getBegin());
                    if (!ti.isZeroSize()) {
                        result.add(ti);
                    }
                    if (!(ti = new TimeInterval(interval2.getEnd(), interval1.getEnd())).isZeroSize()) {
                        result.add(ti);
                    }
                    return result;
                }
                return result;
            }
            if (interval1.getBegin() == intersection.getBegin()) {
                result.add(new TimeInterval(intersection.getEnd(), interval1.getEnd()));
            } else {
                result.add(new TimeInterval(interval1.getBegin(), intersection.getBegin()));
            }
        }
        return result;
    }

    public double getLength() {
        return this.end - this.begin;
    }
}

