/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.base;

import com.dsoft.framework.client.DTOLoaderBase;
import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOCollection;
import com.dsoft.framework.client.base.DTOFinderListener;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.exception.DTOFindException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AbstractDTOCollection<E extends NumberIdDTO<N>, N extends Number>
implements DTOCollection<E, N> {
    private static final long serialVersionUID = 8144970609565657569L;
    private transient boolean scheduled = false;
    private String propertyName = null;
    private BaseDTO owner = null;
    protected Class<E> dtoClass;
    protected boolean ownsTheObjects;
    private Map<N, E> map = new HashMap<N, E>();
    private Map<E, N> newMap = new HashMap<E, N>();
    private static final Object SYNCHRONIZATION = new Object();
    private static int nextId = 0;
    private int changeLock = 0;

    protected AbstractDTOCollection(Class<E> dtoClass, BaseDTO owner) {
        this(dtoClass, owner, false);
    }

    protected AbstractDTOCollection(Class<E> dtoClass) {
        this(dtoClass, null, false);
    }

    protected AbstractDTOCollection(Class<E> dtoClass, BaseDTO owner, boolean ownsTheObjects) {
        this.owner = owner;
        this.dtoClass = dtoClass;
        this.ownsTheObjects = ownsTheObjects;
    }

    @Override
    public Iterator<E> iterator() {
        return new DTOSetIterator(this.map.keySet().iterator());
    }

    private Iterator<?> internalIterator() {
        return new DTOSetIterator(this.map.keySet().iterator());
    }

    @Override
    public Collection<N> getAllId() {
        return new HashSet<N>(this.map.keySet());
    }

    private N getNextId() {
        Object object = SYNCHRONIZATION;
        synchronized (object) {
            Integer result;
            while (this.map.containsKey(result = Integer.valueOf(--nextId)) || this.newMap.containsKey(result)) {
            }
            return (N)result;
        }
    }

    protected N getObjectId(E object) {
        if (((NumberIdDTO)object).getNumberId() != null) {
            return (N)((NumberIdDTO)object).getNumberId();
        }
        return (N)((Number)this.newMap.get(object));
    }

    protected boolean internalAdd(N id, E object) {
        boolean changed = !this.map.containsKey(id);
        this.map.put(id, object);
        return changed;
    }

    @Override
    public boolean add(E object) {
        boolean changed;
        if (this.ownsTheObjects && this.owner != null) {
            ((BaseDTO)object).setParent(this.owner);
        }
        if (((NumberIdDTO)object).getNumberId() != null) {
            changed = !this.map.containsKey(((NumberIdDTO)object).getNumberId());
            this.internalAdd(((NumberIdDTO)object).getNumberId(), object);
        } else {
            Object id;
            boolean bl = changed = !this.newMap.containsKey(object);
            if (changed) {
                id = this.getNextId();
                this.newMap.put(object, id);
            } else {
                id = (Number)this.newMap.get(object);
            }
            this.internalAdd(id, object);
        }
        this.notifyOwner();
        return changed;
    }

    protected E getById(N id, boolean getFromMap) throws DTOFindException {
        if (this.map.containsKey(id)) {
            if ((!DTOLoaderBase.getLoader().supportsCaching() || getFromMap || this.ownsTheObjects) && this.map.get(id) != null) {
                return (E)((NumberIdDTO)this.map.get(id));
            }
            NumberIdDTO value = (NumberIdDTO)DTOLoaderBase.getLoader().findByPrimaryKey(this.dtoClass, id);
            if (!this.scheduled) {
                DTOLoaderBase.getLoader().scheduleForLoad(this.dtoClass, this.map.keySet(), id);
                this.scheduled = true;
            }
            this.map.put(id, value);
            if (this.ownsTheObjects) {
                value.setParent(this.owner);
            }
            return (E)value;
        }
        return null;
    }

    @Override
    public E getById(N id) throws DTOFindException {
        return this.getById(id, false);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Object[] toArray() {
        ArrayList<NumberIdDTO> list = new ArrayList<NumberIdDTO>();
        for (NumberIdDTO e : this) {
            list.add(e);
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] array = (Object[])Array.newInstance(a.getClass().getComponentType(), this.map.size());
        int i = 0;
        Iterator<?> it = this.internalIterator();
        while (it.hasNext()) {
            array[i++] = it.next();
        }
        if (this.checkAndCopyToDestinationArray(a, array)) {
            return a;
        }
        return array;
    }

    protected <T> boolean checkAndCopyToDestinationArray(T[] a, T[] array) {
        if (a.length > array.length) {
            int i = 0;
            for (T obj : array) {
                a[i++] = obj;
            }
            a[i] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsId(N id) {
        return this.map.containsKey(id);
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            NumberIdDTO dto = (NumberIdDTO)o;
            return this.map.containsKey(dto.getNumberId());
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AbstractDTOCollection) {
            return this.map.equals(((AbstractDTOCollection)o).map);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean modified = false;
        for (NumberIdDTO dto : collection) {
            modified |= this.add((E)dto);
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (NumberIdDTO dto : collection) {
            if (this.contains(dto)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAllById(DTOCollection<E, N> collection) {
        return this.removeAllById(collection.getAllId());
    }

    @Override
    public boolean removeAllById(Collection<N> collection) {
        boolean modified = false;
        for (Number id : collection) {
            modified |= this.removeById(id);
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (NumberIdDTO dto : collection) {
            modified |= this.remove(dto);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        HashSet<Number> set = new HashSet<Number>();
        for (NumberIdDTO dto : collection) {
            set.add((Number)dto.getNumberId());
        }
        return this.retainAll((Set<Number>)set);
    }

    @Override
    private boolean retainAll(Set<Number> set) {
        boolean changed = false;
        for (Number id : new HashSet<N>(this.map.keySet())) {
            if (set.contains(id)) continue;
            this.removeById(id);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAllById(DTOCollection<E, N> collection) {
        return this.retainAllById(collection.getAllId());
    }

    @Override
    public boolean retainAllById(Collection<N> collection) {
        HashSet<Number> set = new HashSet<Number>();
        for (Number id : collection) {
            set.add(id);
        }
        return this.retainAll((Set<Number>)set);
    }

    private void lockChange() {
        ++this.changeLock;
    }

    private void unlockChange(boolean changed) {
        --this.changeLock;
        if (changed) {
            this.notifyOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllId(Collection<N> idCollection) {
        this.lockChange();
        boolean changed = false;
        try {
            for (Number id : idCollection) {
                changed |= this.addId(id);
            }
        }
        finally {
            this.unlockChange(changed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeById(N id) {
        NumberIdDTO dto = (NumberIdDTO)this.map.get(id);
        if (dto != null && this.ownsTheObjects) {
            dto.setParent(null);
        }
        try {
            boolean bl = this.map.containsKey(id);
            return bl;
        }
        finally {
            this.map.remove(id);
            this.notifyOwner();
        }
    }

    private void notifyOwner() {
        if (this.owner != null && this.changeLock == 0) {
            this.owner.setModified(this.propertyName);
        }
    }

    @Override
    public void clear() {
        if (this.map.size() > 0) {
            this.notifyOwner();
        }
        this.newMap.clear();
        this.map.clear();
    }

    @Override
    public void clearCachedObjects() {
        if (!this.ownsTheObjects && this.owner == null) {
            HashSet<N> idSet = new HashSet<N>(this.map.keySet());
            this.map.clear();
            this.lockChange();
            try {
                this.addAllId(idSet);
            }
            finally {
                this.unlockChange(false);
            }
        }
    }

    @Override
    public boolean addId(N id) {
        boolean changed;
        if (id == null) {
            return false;
        }
        boolean bl = changed = !this.map.containsKey(id);
        if (changed) {
            this.map.put(id, null);
        }
        if (changed) {
            this.notifyOwner();
        }
        return changed;
    }

    @Override
    public boolean remove(Object object) {
        if (object != null) {
            NumberIdDTO dto = (NumberIdDTO)object;
            Object id = dto.getNumberId() == null ? (Number)this.newMap.get(dto) : dto.getNumberId();
            boolean changed = this.map.containsKey(id);
            if (changed) {
                this.removeById(id);
            }
            return changed;
        }
        return false;
    }

    @Override
    public void updateCollection(Collection<? extends E> newCollection) {
        this.updateCollection(newCollection, new HashSet());
    }

    @Override
    public void updateCollection(Collection<? extends E> newCollection, Collection<? extends E> protectedValues) {
        if (newCollection == null) {
            newCollection = new HashSet<E>();
        }
        HashSet<N> currentSet = new HashSet<N>();
        currentSet.addAll(this.map.keySet());
        for (NumberIdDTO dto : new HashSet<E>(newCollection)) {
            if (currentSet.contains(dto.getNumberId())) {
                if (dto.isModified() && this.ownsTheObjects) {
                    this.add((E)dto);
                }
                currentSet.remove(dto.getNumberId());
                continue;
            }
            if (this.ownsTheObjects) {
                this.add((E)dto);
                continue;
            }
            this.addId(dto.getNumberId());
        }
        for (NumberIdDTO dto : protectedValues) {
            if (!currentSet.contains(dto.getNumberId())) continue;
            currentSet.remove(dto.getNumberId());
        }
        for (Number key : currentSet) {
            this.removeById(key);
        }
    }

    @Override
    public Class<?> getDtoClass() {
        return this.dtoClass;
    }

    @Override
    public <EL extends E> Collection<EL> findElements(DTOFinderListener<E> listener) throws DTOFindException {
        ArrayList<NumberIdDTO> result = new ArrayList<NumberIdDTO>();
        for (NumberIdDTO dto : this) {
            if (!listener.isValid(dto)) continue;
            result.add(dto);
        }
        return result;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    class DTOSetIterator
    implements Iterator<E> {
        private Iterator<N> idIterator;
        private N pk;

        DTOSetIterator(Iterator<N> idIterator) {
            this.idIterator = idIterator;
        }

        @Override
        public void remove() {
            this.idIterator.remove();
            AbstractDTOCollection.this.removeById(this.pk);
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public E next() {
            this.pk = (Number)this.idIterator.next();
            try {
                return AbstractDTOCollection.this.getById(this.pk);
            }
            catch (DTOFindException ex) {
                if (ex.getCause() instanceof InterruptedException) {
                    throw new RuntimeException(ex.getCause());
                }
                throw new RuntimeException(ex.getLocalizedMessage(), ex);
            }
        }
    }
}

