/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.base;

import com.dsoft.framework.client.DTOLoaderBase;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.base.ObjectChangedEvent;
import com.dsoft.framework.client.base.ObjectChangedListener;
import com.dsoft.framework.client.base.PropertyDescriptor;
import com.dsoft.framework.client.base.PropertyKey;
import com.dsoft.framework.client.cache.OwnedInstance;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.util.CopyObjectUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseDTO
implements Serializable,
Cloneable,
OwnedInstance {
    private static final long serialVersionUID = -8868533808598623266L;
    private transient Set<PropertyChangeListener> propertyModifyListenerList = new HashSet<PropertyChangeListener>();
    private transient Set<ObjectChangedListener> objectChangedListenerList = new HashSet<ObjectChangedListener>();
    private Map<Object, Object> customProperties = new HashMap<Object, Object>();
    protected BaseDTO parent;
    private Map<PropertyKey, Object> properties = new HashMap<PropertyKey, Object>();
    private transient Map<PropertyKey, Object> notOwnProperties;
    private Map<String, PropertyDescriptor<?, ?>> propertyRTTI = new HashMap();
    private boolean processing = false;
    private boolean modified = true;
    private int modifiedLock = 0;

    public BaseDTO() {
    }

    public BaseDTO(BaseDTO original) {
        this.clearProperties();
        this.customProperties.clear();
        this.properties.clear();
        if (original != null) {
            this.customProperties.putAll(original.customProperties);
            this.properties.putAll(original.properties);
        }
    }

    public int hashCode() {
        int result = 0;
        for (String propertyName : this.propertyRTTI.keySet()) {
            result += 7 + propertyName.hashCode() * 17;
            result += 7 + (this.customProperties.get(propertyName) != null ? this.customProperties.get(propertyName).hashCode() : 17);
        }
        return result;
    }

    public void addObjectChangeEvent(ObjectChangedListener listener) {
        if (this.objectChangedListenerList == null) {
            this.objectChangedListenerList = new HashSet<ObjectChangedListener>();
        }
        this.objectChangedListenerList.add(listener);
    }

    public void removeObjectChangeEvent(ObjectChangedListener listener) {
        if (this.objectChangedListenerList == null) {
            this.objectChangedListenerList = new HashSet<ObjectChangedListener>();
        }
        this.objectChangedListenerList.remove(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyModifyListenerList == null) {
            this.propertyModifyListenerList = new HashSet<PropertyChangeListener>();
        }
        this.propertyModifyListenerList.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyModifyListenerList == null) {
            this.propertyModifyListenerList = new HashSet<PropertyChangeListener>();
        }
        this.propertyModifyListenerList.remove(listener);
    }

    private void fireObjectChangedEvent() {
        if (this.objectChangedListenerList != null) {
            for (ObjectChangedListener listener : this.objectChangedListenerList) {
                listener.objectChanged(new ObjectChangedEvent(this));
            }
        }
    }

    private void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyModifyListenerList != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (PropertyChangeListener listener : this.propertyModifyListenerList) {
                listener.propertyChange(event);
            }
        }
    }

    private Map<PropertyKey, Object> getNotOwnPropertiesMap() {
        if (this.notOwnProperties == null) {
            this.notOwnProperties = new HashMap<PropertyKey, Object>();
        }
        return this.notOwnProperties;
    }

    protected void removeProperty(String property, Object pk) {
        PropertyDescriptor<?, ?> descriptor = this.propertyRTTI.get(property);
        if (descriptor == null) {
            return;
        }
        PropertyKey key = new PropertyKey(descriptor.propertyHash, descriptor.typeHash, pk, descriptor.propertyClass);
        if (descriptor.ownsThePropertyValue) {
            if (this.setModified(this.properties.containsKey(key), false, property)) {
                Object oldValue = this.properties.remove(key);
                this.firePropertyChangeEvent(property, oldValue, null);
            }
        } else if (this.setModified(this.getNotOwnPropertiesMap().containsKey(key), false, property)) {
            Object oldValue = this.getNotOwnPropertiesMap().remove(key);
            this.firePropertyChangeEvent(property, oldValue, null);
        }
    }

    protected void setProperty(String property, Object value) {
        Number pk = null;
        if (value instanceof NumberIdDTO) {
            pk = (Number)((NumberIdDTO)value).getNumberId();
        }
        this.setProperty(property, pk, value);
    }

    protected void setProperty(String property, Number newPk, Object value) {
        PropertyDescriptor<?, ?> descriptor = this.propertyRTTI.get(property);
        Number existingPk = (Number)this.getObjectValue(property);
        PropertyKey key = new PropertyKey(descriptor.propertyHash, descriptor.typeHash, existingPk, descriptor.propertyClass);
        Object oldValue = descriptor.ownsThePropertyValue ? this.properties.get(key) : this.getNotOwnPropertiesMap().get(key);
        key = new PropertyKey(descriptor.propertyHash, descriptor.typeHash, newPk, descriptor.propertyClass);
        this.putPropertyValue(descriptor, key, value);
        this.customProperties.put(property, newPk);
        if (this.setModified(oldValue, value, property)) {
            this.firePropertyChangeEvent(property, oldValue, value);
        }
    }

    private void putPropertyValue(PropertyDescriptor<?, ?> descriptor, PropertyKey key, Object value) {
        if (descriptor.ownsThePropertyValue) {
            this.properties.put(key, value);
        } else {
            this.getNotOwnPropertiesMap().put(key, value);
        }
        if (value instanceof BaseDTO && descriptor.ownsThePropertyValue) {
            ((BaseDTO)value).setParent(this);
        }
    }

    protected void clearProperties() {
        this.getNotOwnPropertiesMap().clear();
        this.properties.clear();
    }

    public boolean isPropertyModified(String property, Object pk) {
        PropertyDescriptor<?, ?> descriptor = this.propertyRTTI.get(property);
        PropertyKey key = new PropertyKey(descriptor.propertyHash, descriptor.typeHash, pk, descriptor.propertyClass);
        if (!this.properties.containsKey(key)) {
            return false;
        }
        Object result = this.properties.get(key);
        if (result instanceof BaseDTO) {
            return ((BaseDTO)result).isModified();
        }
        return true;
    }

    protected <T> T getPropertyValue(String property) {
        Number pk = (Number)this.getObjectValue(property);
        return this.getPropertyValue(property, pk);
    }

    protected <T> T getPropertyValue(String property, Number pk) {
        if (pk instanceof Integer && pk.intValue() < 0) {
            return null;
        }
        PropertyDescriptor<?, ?> descriptor = this.propertyRTTI.get(property);
        PropertyKey key = new PropertyKey(descriptor.propertyHash, descriptor.typeHash, pk, descriptor.propertyClass);
        Object result = descriptor.ownsThePropertyValue ? this.properties.get(key) : this.getNotOwnPropertiesMap().get(key);
        if (result == null) {
            if (pk == null) {
                return null;
            }
            result = this.loadDto(descriptor, key, pk);
        } else if (result instanceof BaseDTO) {
            boolean flag;
            boolean bl = flag = !((BaseDTO)result).isModified() && !DTOLoaderBase.getLoader().supportsCaching();
            if (descriptor.ownsThePropertyValue || flag) {
                return (T)result;
            }
            result = this.loadDto(descriptor, key, pk);
        }
        return (T)result;
    }

    private <T> T loadDto(PropertyDescriptor<?, ?> descriptor, PropertyKey key, Number pk) {
        try {
            Object result = DTOLoaderBase.getLoader().findByPrimaryKey(descriptor.propertyClass, pk);
            this.putPropertyValue(descriptor, key, result);
            return result;
        }
        catch (DTOFindException fe) {
            throw new RuntimeException(fe);
        }
    }

    public List<PropertyDescriptor> getProperties() {
        return new ArrayList<PropertyDescriptor>(this.propertyRTTI.values());
    }

    protected PropertyDescriptor<?, ?> registerProperty(Class<?> type, String property) {
        return this.registerProperty(type, property, true);
    }

    public <T> T getObjectValue(Object key) {
        return (T)(this.customProperties != null ? this.customProperties.get(key) : null);
    }

    public <T> T putObjectValue(Object key, Object value) {
        if (this.setModified(this.getObjectValue(key), value, key.toString())) {
            this.removeProperty(key.toString(), this.getObjectValue(key));
        }
        return (T)this.customProperties.put(key, value);
    }

    public Set<Object> getKeysSet() {
        return new HashSet<Object>(this.customProperties.keySet());
    }

    protected PropertyDescriptor<?, ?> registerProperty(Class<?> type, String property, boolean ownsThePropertyValue) {
        PropertyDescriptor descriptor = new PropertyDescriptor(type, ownsThePropertyValue, property);
        this.propertyRTTI.put(property, descriptor);
        return descriptor;
    }

    public void setParent(BaseDTO parent) {
        this.parent = parent;
        if (this.modified) {
            this.processModified();
        }
    }

    protected boolean setModified(Object o1, Object o2) {
        String propertyName = this.getPropertyName();
        return this.setModified(o1, o2, propertyName);
    }

    protected boolean setModified(Object o1, Object o2, String propertyName) {
        boolean result;
        boolean bl = result = o1 != o2 && (o1 == null || o2 == null || !o1.equals(o2));
        if (result && propertyName != null) {
            this.firePropertyChangeEvent(propertyName, o1, o2);
        }
        this.setModified(result);
        return result;
    }

    protected boolean setModified(double o1, double o2, String propertyName) {
        boolean result;
        boolean bl = result = o1 != o2;
        if (result && propertyName != null) {
            this.firePropertyChangeEvent(propertyName, o1, o2);
        }
        this.setModified(result);
        return result;
    }

    protected boolean setModified(int o1, int o2, String propertyName) {
        boolean result;
        boolean bl = result = o1 != o2;
        if (result && propertyName != null) {
            this.firePropertyChangeEvent(propertyName, o1, o2);
        }
        this.setModified(result);
        return result;
    }

    protected boolean setModified(long o1, long o2, String propertyName) {
        boolean result;
        boolean bl = result = o1 != o2;
        if (result && propertyName != null) {
            this.firePropertyChangeEvent(propertyName, o1, o2);
        }
        this.setModified(result);
        return result;
    }

    protected void processModified() {
        if (!this.processing) {
            this.processing = true;
            try {
                this.fireObjectChangedEvent();
                if (this.parent != null && this.parent.parent != this) {
                    this.parent.setModified(null);
                }
            }
            finally {
                this.processing = false;
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public synchronized void lockModified() {
        ++this.modifiedLock;
    }

    public synchronized void unlockModified() {
        --this.modifiedLock;
    }

    public void resetModified() {
        if (this.modifiedLock == 0) {
            this.modified = false;
            for (Object value : this.properties.values()) {
                if (!(value instanceof BaseDTO)) continue;
                ((BaseDTO)value).resetModified();
            }
        }
    }

    protected void setModified(String propertyName) {
        this.setModified(true, false, propertyName);
    }

    protected void setModified() {
        String propertyName = this.getPropertyName();
        this.setModified(propertyName);
    }

    private String getPropertyName() {
        String propertyName = null;
        String callerName = Thread.currentThread().getStackTrace()[3].getMethodName();
        if (callerName.startsWith("set")) {
            propertyName = callerName.substring(4);
            propertyName = callerName.substring(3, 4).toLowerCase() + propertyName;
        }
        return propertyName;
    }

    protected boolean setModified(boolean modified) {
        this.modified |= modified;
        if (modified) {
            this.processModified();
        }
        return modified;
    }

    protected void setCollectionParent(Collection<?> collection, BaseDTO parent) {
        for (Object object : collection) {
            ((BaseDTO)object).setParent(parent);
        }
    }

    public static <T extends BaseDTO> T createCopy(T original) throws IOException, ClassNotFoundException {
        T result;
        BaseDTO parentCopy = original.parent;
        original.parent = null;
        try {
            result = CopyObjectUtil.copyObject(original);
        }
        finally {
            original.parent = parentCopy;
        }
        return result;
    }

    public boolean isOwned() {
        return this.parent != null;
    }

    public String toString() {
        StringBuilder returnStringBuffer = new StringBuilder(128);
        returnStringBuffer.append("[");
        returnStringBuffer.append("owned:").append(this.parent != null);
        if (!this.customProperties.isEmpty()) {
            returnStringBuffer.append("custom properties[");
            for (Object object : this.customProperties.keySet()) {
                returnStringBuffer.append(object.toString()).append(":");
                returnStringBuffer.append(this.customProperties.get(object)).append(",");
            }
            returnStringBuffer.append("]");
        }
        if (!this.properties.isEmpty() || !this.getNotOwnPropertiesMap().isEmpty()) {
            returnStringBuffer.append("properties[");
            for (PropertyKey propertyKey : this.properties.keySet()) {
                returnStringBuffer.append(propertyKey.toString()).append(":");
                returnStringBuffer.append(this.properties.get(propertyKey)).append(",");
            }
            if (this.notOwnProperties != null) {
                for (PropertyKey propertyKey : this.notOwnProperties.keySet()) {
                    returnStringBuffer.append(propertyKey.toString()).append(":");
                    returnStringBuffer.append(this.notOwnProperties.get(propertyKey)).append(",");
                }
            }
            returnStringBuffer.append("]");
        }
        returnStringBuffer.append("]");
        return returnStringBuffer.toString();
    }

    @Override
    public void cleanupOwnerReferences() {
        this.parent = null;
    }
}

