/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.base;

import com.dsoft.framework.client.base.AbstractDTOCollection;
import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOList;
import com.dsoft.framework.client.base.DTOSubList;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.exception.DTOFindException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DTOListImpl<E extends NumberIdDTO<N>, N extends Number>
extends AbstractDTOCollection<E, N>
implements DTOList<E, N> {
    private static final long serialVersionUID = 1351936047837874241L;
    private List<N> idList = new ArrayList<N>();

    public DTOListImpl(Class dtoClass, BaseDTO owner) {
        super(dtoClass, owner);
    }

    public DTOListImpl(Class dtoClass) {
        super(dtoClass);
    }

    public DTOListImpl(Class dtoClass, BaseDTO owner, boolean ownsTheObjects) {
        super(dtoClass, owner, ownsTheObjects);
    }

    @Override
    protected boolean internalAdd(N id, E object) {
        if (super.internalAdd(id, object)) {
            this.idList.add(id);
            return true;
        }
        return false;
    }

    @Override
    public boolean addId(N id) {
        if (id == null) {
            return false;
        }
        boolean changed = super.addId(id);
        if (changed) {
            this.idList.add(id);
        }
        return changed;
    }

    @Override
    public boolean removeById(N id) {
        try {
            boolean bl = super.removeById(id);
            return bl;
        }
        finally {
            this.idList.remove(id);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.idList.clear();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int initialSize = this.size();
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            this.add(index, (E)((NumberIdDTO)it.next()));
            ++index;
        }
        return initialSize != this.size();
    }

    @Override
    public E get(int index) {
        Number id = (Number)this.idList.get(index);
        try {
            return this.getById(id);
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public N getId(int index) {
        return (N)((Number)this.idList.get(index));
    }

    @Override
    public E set(int index, E element) {
        Number resultId = (Number)this.idList.get(index);
        E result = null;
        try {
            result = this.getById(resultId, true);
        }
        catch (DTOFindException dTOFindException) {
            // empty catch block
        }
        super.add(element);
        this.idList.set(index, this.getObjectId(element));
        return result;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
        this.idList.add(index, this.getObjectId(element));
    }

    @Override
    public E remove(int index) {
        Object result;
        Number id = (Number)this.idList.get(index);
        try {
            result = this.getById(id, true);
            this.removeById(id);
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex.getLocalizedMessage(), ex);
        }
        return result;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        NumberIdDTO dto = (NumberIdDTO)o;
        return this.idList.indexOf(dto.getNumberId());
    }

    @Override
    public int indexOfId(N id) {
        return this.idList.indexOf(id);
    }

    @Override
    public int lastIndexOf(Object o) {
        NumberIdDTO dto = (NumberIdDTO)o;
        return this.idList.lastIndexOf(dto.getNumberId());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new DTOListIterator(this.idList.listIterator());
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new DTOListIterator(this.idList.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new DTOSubList(this.dtoClass, this.idList.subList(fromIndex, toIndex));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] array = (Object[])Array.newInstance(a.getClass().getComponentType(), this.idList.size());
        int i = 0;
        for (NumberIdDTO e : this) {
            array[i++] = e;
        }
        if (this.checkAndCopyToDestinationArray(a, array)) {
            return a;
        }
        return array;
    }

    private class DTOListIterator
    extends AbstractDTOCollection.DTOSetIterator
    implements ListIterator<E> {
        private ListIterator<N> idIterator;

        DTOListIterator(ListIterator<N> idIterator) {
            super(idIterator);
            this.idIterator = idIterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.idIterator.hasPrevious();
        }

        @Override
        public E previous() {
            Number pk = (Number)this.idIterator.previous();
            try {
                return DTOListImpl.this.getById(pk);
            }
            catch (DTOFindException ex) {
                throw new RuntimeException(ex.getLocalizedMessage(), ex);
            }
        }

        @Override
        public int nextIndex() {
            return this.idIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.idIterator.previousIndex();
        }

        @Override
        public void set(E o) {
            int index = this.nextIndex() - 1;
            DTOListImpl.this.set(index, o);
        }

        @Override
        public void add(E o) {
            DTOListImpl.this.add(this.nextIndex(), o);
        }
    }
}

