/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.cache;

import com.dsoft.framework.client.cache.CacheException;

public abstract class AbstractCacheValue<T> {
    public static final int CACHE_PERMANENT = 0;
    public static final int CACHE_REMOVE_AFTER_N_MINUTES = 1;
    public static final int CACHE_REMOVE_AFTER_N_MINUTES_IF_NOT_USED = 2;
    private static final int UNUSED_TIMEOUT = 30;
    private int policy;
    private int policyParam;
    protected long lastUsed = System.currentTimeMillis();
    private String className;

    public AbstractCacheValue(int policy, int policyParam, String className) {
        this.policy = policy;
        this.policyParam = policyParam;
        this.className = className;
    }

    public AbstractCacheValue(String className) {
        this(2, 30, className);
    }

    public abstract boolean isNull();

    public abstract T getValue() throws CacheException;

    public abstract int getValueSize();

    public boolean isExpired(long timeOut) {
        long currentTime = System.currentTimeMillis();
        switch (this.policy) {
            case 1: 
            case 2: {
                long millis = currentTime - this.lastUsed;
                if ((millis /= 60000L) <= timeOut) break;
                return true;
            }
        }
        return false;
    }

    public boolean isExpired() {
        return this.isExpired(this.policyParam);
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public int getPolicy() {
        return this.policy;
    }

    public String getClassName() {
        return this.className;
    }

    public int getPolicyParam() {
        return this.policyParam;
    }
}

