/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.cache;

import com.dsoft.framework.client.MessageListenerBase;
import com.dsoft.framework.client.base.NumberIdDTO;
import com.dsoft.framework.client.cache.AbstractCacheValue;
import com.dsoft.framework.client.cache.CacheEvent;
import com.dsoft.framework.client.cache.CacheMap;
import com.dsoft.framework.events.client.DSoftServerEvent;
import com.dsoft.framework.logger.client.LogUtilClient;
import com.dsoft.framework.logger.client.Logger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.Context;

public class CacheEventListener
extends MessageListenerBase
implements MessageListener {
    private static final Logger LOGGER = Logger.getLogger(CacheEventListener.class);
    private static final String EVENT_TOPIC = "topic/EventProcessTopic";
    private final CacheMap cacheMap;

    public CacheEventListener(CacheMap cacheMap, Context context) {
        super(context);
        this.cacheMap = cacheMap;
    }

    public void open() throws Exception {
        this.connect(EVENT_TOPIC, this, true);
    }

    @Override
    protected String getPrefix() {
        return "";
    }

    @Override
    protected boolean exceptionWhileConnecting() {
        return false;
    }

    public void detachFromEventTopic() {
        this.detachFromTopic();
    }

    public void onMessage(Message message) {
        if (!(message instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage objMsg = (ObjectMessage)message;
        try {
            HashSet<Serializable> events = new HashSet<Serializable>();
            try {
                if (objMsg.getObject() instanceof HashSet) {
                    events.addAll((Set)((Object)objMsg.getObject()));
                } else if (objMsg.getObject() instanceof DSoftServerEvent) {
                    events.add(objMsg.getObject());
                }
            }
            catch (MessageFormatException ex) {
                if (ex.getMessage().contains("ClassNotFoundException")) {
                    return;
                }
                throw ex;
            }
            for (Object e : events) {
                DSoftServerEvent eventObj = (DSoftServerEvent)e;
                if (!(eventObj instanceof CacheEvent)) continue;
                this.processCacheEvent(eventObj);
            }
        }
        catch (JMSException jmsEx) {
            LogUtilClient.error(LOGGER, jmsEx);
            jmsEx.printStackTrace();
        }
    }

    private void clearObjectFromCache(Class<?> type, Number id) {
        while (type.getSuperclass() != null) {
            this.cacheMap.replaceCacheValueIfNotNull(type.getName(), id, null);
            type = type.getSuperclass();
        }
    }

    private void processCacheEvent(DSoftServerEvent eventObj) {
        CacheEvent event = (CacheEvent)eventObj;
        if (event.isRemoveBean() || event.isModifyBean()) {
            NumberIdDTO dto = (NumberIdDTO)event.getEventObject();
            try {
                this.clearObjectFromCache(event.getType(), (Number)dto.getNumberId());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (event.isResetCache()) {
            try {
                if (event.getType() == null) {
                    this.cacheMap.clearAll();
                } else {
                    Class<?> type = event.getType();
                    String originalClassName = type.getName();
                    while (type.getSuperclass() != null) {
                        String className = type.getName();
                        type = type.getSuperclass();
                        Map<Object, AbstractCacheValue<?>> valueMap = this.cacheMap.getValueMap(className);
                        if (valueMap == null) continue;
                        for (Object key : valueMap.keySet()) {
                            AbstractCacheValue<?> item = valueMap.get(key);
                            if (!item.getClassName().equals(originalClassName)) continue;
                            this.cacheMap.replaceCacheValueIfNotNull(className, key, null);
                        }
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

