/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.cache;

import com.dsoft.framework.client.cache.AbstractCacheValue;
import com.dsoft.framework.client.cache.CacheStatistic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CacheMap {
    private static final Logger logger = Logger.getLogger(CacheMap.class);
    private final Map<String, Map<Object, AbstractCacheValue<?>>> cacheMap = Collections.synchronizedMap(new HashMap());

    public Map<Object, AbstractCacheValue<?>> getValueMap(String cacheName) {
        Map<Object, AbstractCacheValue<?>> valueMap = this.getValueMap(cacheName, false);
        return valueMap != null ? Collections.unmodifiableMap(valueMap) : null;
    }

    private Map<Object, AbstractCacheValue<?>> getValueMap(String cacheName, boolean createIfMissing) {
        Map<Object, AbstractCacheValue<Object>> valueMap = this.cacheMap.get(cacheName);
        if (valueMap == null && createIfMissing) {
            valueMap = Collections.synchronizedMap(new HashMap());
            this.cacheMap.put(cacheName, valueMap);
        }
        return valueMap;
    }

    public AbstractCacheValue<?> getCacheValue(String cacheName, Object key) {
        Map<Object, AbstractCacheValue<?>> valueMap = this.getValueMap(cacheName, false);
        return valueMap != null ? valueMap.get(key) : null;
    }

    public void putCacheValue(String cacheName, Object key, AbstractCacheValue<?> cacheValue) {
        Map<Object, AbstractCacheValue<?>> valueMap = this.getValueMap(cacheName, true);
        valueMap.put(key, cacheValue);
    }

    public AbstractCacheValue<?> removeCacheValue(String cacheName, Object key) {
        Map<Object, AbstractCacheValue<?>> valueMap = this.getValueMap(cacheName, false);
        return valueMap != null ? valueMap.remove(key) : null;
    }

    public void replaceCacheValueIfNotNull(String cacheName, Object key, AbstractCacheValue<?> newCacheValue) {
        Map<Object, AbstractCacheValue<?>> valueMap = this.getValueMap(cacheName, false);
        if (valueMap == null) {
            return;
        }
        AbstractCacheValue<?> cacheValue = valueMap.remove(key);
        if (cacheValue != null && !cacheValue.isNull()) {
            valueMap.put(key, newCacheValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCacheObjects() {
        int size = 0;
        Map<String, Map<Object, AbstractCacheValue<?>>> map = this.cacheMap;
        synchronized (map) {
            for (Map<Object, AbstractCacheValue<?>> valueMap : this.cacheMap.values()) {
                size += valueMap.size();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheSize() {
        long size = 0L;
        Map<String, Map<Object, AbstractCacheValue<?>>> map = this.cacheMap;
        synchronized (map) {
            for (Map<Object, AbstractCacheValue<?>> valueMap : this.cacheMap.values()) {
                for (AbstractCacheValue<?> val : valueMap.values()) {
                    size += (long)val.getValueSize();
                }
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<CacheStatistic>> buildCacheStatistics(String cacheName, String className) {
        HashMap<String, List<CacheStatistic>> counterMap = new HashMap<String, List<CacheStatistic>>();
        HashSet<String> cacheNames = new HashSet<String>();
        if (cacheName != null) {
            cacheNames.add(cacheName);
        } else {
            Map<String, Map<Object, AbstractCacheValue<?>>> map = this.cacheMap;
            synchronized (map) {
                cacheNames.addAll(this.cacheMap.keySet());
            }
        }
        for (String name : cacheNames) {
            Map<Object, AbstractCacheValue<?>> valueMap = this.cacheMap.get(name);
            if (valueMap == null) continue;
            Map<Object, AbstractCacheValue<?>> map = valueMap;
            synchronized (map) {
                for (Object key : valueMap.keySet()) {
                    AbstractCacheValue<?> cv = valueMap.get(key);
                    if (cv == null || cv.isNull() || cv.isExpired() || className != null && !cv.getClassName().equals(className)) continue;
                    ArrayList<CacheStatistic> items = (ArrayList<CacheStatistic>)counterMap.get(cv.getClassName());
                    if (items == null) {
                        items = new ArrayList<CacheStatistic>();
                        counterMap.put(cv.getClassName(), items);
                    }
                    items.add(new CacheStatistic(cv.getValueSize(), key));
                }
            }
        }
        return counterMap;
    }

    public void clearAll() {
        this.cacheMap.clear();
    }

    public void clearCache(String cacheName) {
        this.cacheMap.remove(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int cleanupCache(int workTimeOut) {
        HashSet<String> cacheNameSet;
        int totalSize = 0;
        Map<String, Map<Object, AbstractCacheValue<?>>> map = this.cacheMap;
        synchronized (map) {
            cacheNameSet = new HashSet<String>(this.cacheMap.keySet());
        }
        for (String cacheName : cacheNameSet) {
            Map<Object, AbstractCacheValue<?>> valueMap = this.cacheMap.get(cacheName);
            int size = valueMap.size();
            Map<Object, AbstractCacheValue<?>> map2 = valueMap;
            synchronized (map2) {
                for (Object key : new HashSet<Object>(valueMap.keySet())) {
                    AbstractCacheValue<?> cv = valueMap.get(key);
                    if (cv == null || !cv.isNull() && !cv.isExpired(workTimeOut)) continue;
                    valueMap.remove(key);
                }
            }
            if (valueMap.size() != size) {
                logger.debug(String.format("%1$d remaining objects in cache %2$s", valueMap.size(), cacheName));
            }
            totalSize += valueMap.size();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> Set<E> getCacheKeys(String cacheName) {
        Map<Object, AbstractCacheValue<?>> valueMap = this.getValueMap(cacheName, false);
        if (valueMap == null) {
            return new HashSet();
        }
        Map<Object, AbstractCacheValue<?>> map = valueMap;
        synchronized (map) {
            return new HashSet<Object>(valueMap.keySet());
        }
    }
}

