/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.cache;

import com.dsoft.framework.client.cache.CacheMap;

public class CachePurgeThread
extends Thread {
    private final CacheMap cacheMap;
    private long waitTimeOut;
    private long maxCacheSize = 150000L;
    private int timeOut = 1440;

    public CachePurgeThread(CacheMap cacheMap, long waitTimeOut) {
        super("Cache purge thread");
        this.cacheMap = cacheMap;
        this.waitTimeOut = waitTimeOut;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                CacheMap cacheMap = this.cacheMap;
                synchronized (cacheMap) {
                    this.cacheMap.wait(this.waitTimeOut);
                    try {
                        this.clearTrashInCache();
                    }
                    catch (Exception ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void clearTrashInCache() {
        int sizeAfterCleanup;
        for (int workTimeOut = this.timeOut; workTimeOut > 1 && (long)(sizeAfterCleanup = this.cacheMap.cleanupCache(workTimeOut)) >= this.maxCacheSize; workTimeOut /= 2) {
        }
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getTimeOut() {
        return this.timeOut;
    }
}

