/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.cache;

import com.dsoft.framework.client.cache.AbstractCacheValue;
import com.dsoft.framework.client.cache.CacheException;
import com.dsoft.framework.client.util.CopyObjectUtil;
import java.io.IOException;

public class SerializedCacheValue<T>
extends AbstractCacheValue<T> {
    private byte[] value;
    private ClassLoader valueClassLoader;

    public SerializedCacheValue(T instanceValue, int policy, int policyParam) throws CacheException {
        super(policy, policyParam, instanceValue.getClass().getName());
        this.serializeValue(instanceValue);
    }

    private void serializeValue(Object value) throws CacheException {
        try {
            this.value = CopyObjectUtil.jb_objectToByteArray(value);
            this.valueClassLoader = value != null ? value.getClass().getClassLoader() : null;
        }
        catch (IOException ex) {
            throw new CacheException(ex);
        }
    }

    public SerializedCacheValue(AbstractCacheValue<?> cacheValue) throws CacheException {
        super(cacheValue.getPolicy(), cacheValue.getPolicyParam(), cacheValue.getClassName());
        if (cacheValue instanceof SerializedCacheValue) {
            this.value = ((SerializedCacheValue)cacheValue).value;
        } else {
            this.serializeValue(cacheValue.getValue());
        }
    }

    public SerializedCacheValue(T instanceValue) throws CacheException {
        super(instanceValue != null ? instanceValue.getClass().getName() : null);
        this.serializeValue(instanceValue);
    }

    @Override
    public T getValue() throws CacheException {
        if (this.getPolicy() == 2) {
            this.lastUsed = System.currentTimeMillis();
        }
        try {
            return this.value != null ? (T)CopyObjectUtil.jb_byteArrayToObject(this.value, this.valueClassLoader) : null;
        }
        catch (ClassNotFoundException ex) {
            throw new CacheException(ex);
        }
        catch (IOException ex) {
            throw new CacheException(ex);
        }
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public int getValueSize() {
        return this.value != null ? this.value.length : 0;
    }
}

