/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.context;

import com.dsoft.framework.client.context.ClientContext;
import com.dsoft.framework.client.context.ClientContextFactory;
import com.dsoft.framework.client.context.ClientContextImpl;
import java.util.Locale;

public class ThreadedClientContextFactory
extends ClientContextFactory {
    private ClientContext context = new ClientContextImpl();
    private ThreadLocal<ClientContext> threadClientContext = new ThreadLocal<ClientContext>(){

        @Override
        protected ClientContext initialValue() {
            return ThreadedClientContextFactory.this.context;
        }
    };

    public ThreadedClientContextFactory(Locale locale) {
        this.context.setLocale(locale);
    }

    protected ClientContext getClientContextInstance() {
        return this.threadClientContext.get();
    }

    protected void activateClientContextInstance(ClientContext context) {
        this.threadClientContext.set(context);
    }

    protected void deactivateClientContextInstance() {
        try {
            this.getClientContextInstance().closeContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.threadClientContext.remove();
    }
}

