/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.impl;

import com.dsoft.framework.client.ConnectionProperties;
import com.dsoft.framework.client.RemoteCallUtil;
import com.dsoft.framework.client.base.ClientModule;
import com.dsoft.framework.client.base.ClientWorkArea;
import com.dsoft.framework.client.base.InitializationException;
import com.dsoft.framework.client.base.Operation;
import com.dsoft.framework.client.base.OperationRegisterListener;
import com.dsoft.framework.client.base.SessionManager;
import com.dsoft.framework.client.base.SessionManagerListener;
import com.dsoft.framework.client.base.SessionState;
import com.dsoft.framework.client.cache.AbstractCacheValue;
import com.dsoft.framework.client.cache.CacheException;
import com.dsoft.framework.client.cache.CacheMap;
import com.dsoft.framework.client.cache.InstanceCacheValue;
import com.dsoft.framework.client.context.ClientContextFactory;
import com.dsoft.framework.client.impl.CallbackQueue;
import com.dsoft.framework.client.impl.ClientTransactionManager;
import com.dsoft.framework.client.impl.RegistryKey;
import com.dsoft.framework.logger.client.LogUtilClient;
import com.dsoft.framework.logger.client.Logger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.AccessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Remove;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;

public abstract class AbstractSessionManager
implements SessionManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractSessionManager.class);
    private Map<String, Operation> registeredOperations = new HashMap<String, Operation>();
    private Set<String> overriddenOperations = new HashSet<String>();
    private Map<String, ClientWorkArea> registeredWorkAreas = new HashMap<String, ClientWorkArea>();
    protected Map<String, Set<String>> moduleOperations = new HashMap<String, Set<String>>();
    protected List<ClientModule> frameworkModules = new ArrayList<ClientModule>();
    private Set<OperationRegisterListener> operationListeners = new HashSet<OperationRegisterListener>();
    private final CacheMap cacheMap = new CacheMap();
    private Map<String, RegistryKey> registry_root = new HashMap<String, RegistryKey>();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected Set<SessionManagerListener> sessionListeners = new HashSet<SessionManagerListener>();
    protected Map<String, Set<String>> moduleWorkAreas = new HashMap<String, Set<String>>();
    private Set<String> validNames = new HashSet<String>();
    private ConnectionProperties connectionProperties;
    private ThreadLocal<Context> threadJndi = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
            env.put("java.naming.provider.url", AbstractSessionManager.this.connectionProperties.getConnectionURL());
            env.put("jnp.disableDiscovery", true);
            InitialContext ctx = null;
            try {
                ctx = new InitialContext(env);
            }
            catch (NamingException ex) {
                ex.printStackTrace();
            }
            return ctx;
        }
    };
    private ThreadLocal<Map<String, OwnedManager>> jndiMap = new ThreadLocal<Map<String, OwnedManager>>(){

        @Override
        protected Map<String, OwnedManager> initialValue() {
            return new HashMap<String, OwnedManager>();
        }
    };
    private SessionState sessionState;
    private ThreadLocal<List<OwnedManager>> managersToRelease = new ThreadLocal<List<OwnedManager>>(){

        @Override
        protected List<OwnedManager> initialValue() {
            return new ArrayList<OwnedManager>();
        }
    };
    private ThreadLocal<Stack<CallbackQueue>> threadQueue = new ThreadLocal<Stack<CallbackQueue>>(){

        @Override
        protected Stack<CallbackQueue> initialValue() {
            return new Stack<CallbackQueue>();
        }
    };

    protected AbstractSessionManager() throws SystemException, IllegalStateException, RollbackException {
        Synchronization managerReleaseSync = new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                for (OwnedManager manager : (List)AbstractSessionManager.this.managersToRelease.get()) {
                    try {
                        AbstractSessionManager.this.releaseManager(manager.name, manager.manager);
                    }
                    catch (Exception ex) {
                        LogUtilClient.error(LOGGER, String.format("Error while releasing manager %1$s", manager.name), ex);
                    }
                }
                AbstractSessionManager.this.managersToRelease.remove();
            }
        };
        ClientTransactionManager.getTransaction().registerSynchronization(managerReleaseSync);
    }

    @Override
    public ConnectionProperties getConnectionProperties() {
        if (this.connectionProperties == null) {
            this.connectionProperties = new ConnectionProperties();
        }
        return this.connectionProperties;
    }

    @Override
    public boolean canCloseSession() {
        return true;
    }

    @Override
    public void clearSession() throws Exception {
        this.registeredOperations.clear();
        this.overriddenOperations.clear();
        this.registeredWorkAreas.clear();
        this.moduleOperations.clear();
        this.frameworkModules.clear();
        this.operationListeners.clear();
        this.sessionListeners.clear();
        this.registry_root.clear();
        this.moduleWorkAreas.clear();
        this.clearCache();
        this.closeNamingContext();
    }

    @Override
    public void addSessionManagerListener(SessionManagerListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public void removeSessionManagerListener(SessionManagerListener listener) {
        this.sessionListeners.remove(listener);
    }

    @Override
    public void addOperationRegisterListener(OperationRegisterListener listener) {
        this.operationListeners.add(listener);
    }

    @Override
    public void removeOperationRegisterListener(OperationRegisterListener listener) {
        this.operationListeners.remove(listener);
    }

    @Override
    public Context getNamingContext() throws NamingException {
        return this.threadJndi.get();
    }

    @Override
    public void closeNamingContext() throws NamingException {
        this.getNamingContext().close();
        this.threadJndi.remove();
    }

    @Override
    public boolean registerOperation(String name, Operation operation) {
        if (!this.overriddenOperations.contains(name)) {
            this.registeredOperations.put(name, operation);
            this.fireOperationRegisterEvent(name, operation);
            return true;
        }
        return false;
    }

    @Override
    public void registerWorkArea(String name, ClientWorkArea workArea) {
        this.registeredWorkAreas.put(name, workArea);
    }

    @Override
    public void overrideOperation(String name, Operation operation) {
        if (this.registeredOperations.get(name) == operation) {
            return;
        }
        this.overrideOperation(name);
        this.registeredOperations.put(name, operation);
        this.fireOperationRegisterEvent(name, operation);
    }

    private void overrideOperation(String name) {
        this.overriddenOperations.add(name);
        if (this.registeredOperations.containsKey(name)) {
            Operation operation = this.registeredOperations.get(name);
            operation.clean();
            this.registeredOperations.remove(name);
        }
    }

    @Override
    public Operation getRegisterOperation(String className) {
        return this.createOperationProxy(Operation.class, className);
    }

    protected <T> T createOperationProxy(Class<T> cl, String className) {
        if (this.registeredOperations.containsKey(className)) {
            return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (InvocationHandler)new InvocationHandlerImp(className, this.registeredOperations));
        }
        return null;
    }

    protected <T> T createWorkAreaProxy(Class<T> cl, String className) {
        if (this.registeredWorkAreas.containsKey(className)) {
            return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (InvocationHandler)new InvocationHandlerImp(className, this.registeredWorkAreas));
        }
        return null;
    }

    @Override
    public ClientWorkArea getClientWorkArea(String className) {
        return this.createWorkAreaProxy(ClientWorkArea.class, className);
    }

    protected abstract void doLogin(String var1, char[] var2) throws Exception;

    @Override
    public void login(String userName, char[] password, Object serverConfig) throws Exception {
        this.sessionState = SessionState.Login;
        try {
            this.doLogin(userName, password);
        }
        catch (Exception ex) {
            this.sessionState = null;
            throw ex;
        }
    }

    @Override
    public void preComponentInit() throws InitializationException {
        this.sessionState = SessionState.Initializing;
    }

    @Override
    public void postComponentInit() throws InitializationException {
        this.sessionState = SessionState.Working;
    }

    @Override
    public void logoff() {
        this.sessionState = SessionState.Logoff;
    }

    @Override
    public void exit() throws Exception {
        this.sessionState = SessionState.Exiting;
    }

    @Override
    public abstract void reLogin(char[] var1);

    public abstract List<String> getClientModuleClassNamesForInit() throws Exception;

    public abstract Set<String> getAllowedOperationNames(ClientModule var1) throws Exception;

    public abstract Set<String> getAllowedWorkAreaNames(ClientModule var1) throws Exception;

    private void fireOperationRegisterEvent(String name, Operation operation) {
        for (OperationRegisterListener listener : this.operationListeners) {
            listener.operationRegistered(name, operation);
        }
    }

    @Override
    public void putCacheValue(String cacheName, Object key, Object value, int cachePolicy, int cacheValue) throws CacheException {
        InstanceCacheValue<Object> cv = new InstanceCacheValue<Object>(value, cachePolicy, cacheValue);
        this.cacheMap.putCacheValue(cacheName, key, cv);
    }

    protected void clearCache() {
        this.cacheMap.clearAll();
    }

    @Override
    public <K, V> V getCacheValue(String cacheName, K key) throws CacheException {
        AbstractCacheValue<?> cv = this.cacheMap.getCacheValue(cacheName, key);
        if (cv == null) {
            return null;
        }
        if (cv.isExpired()) {
            this.cacheMap.removeCacheValue(cacheName, key);
            return null;
        }
        return (V)cv.getValue();
    }

    @Override
    public void removeCacheValue(String cacheName, Object key) {
        this.cacheMap.removeCacheValue(cacheName, key);
    }

    @Override
    public <E> Set<E> getCacheKeys(String cacheName) {
        return this.cacheMap.getCacheKeys(cacheName);
    }

    @Override
    public <V> Set<V> getValues(String[] keyPath) {
        Map<String, RegistryKey> prevSet = this.registry_root;
        RegistryKey key = null;
        for (int i = 0; i < keyPath.length; ++i) {
            key = prevSet.get(keyPath[i]);
            if (key == null) {
                while (i < keyPath.length) {
                    key = new RegistryKey();
                    prevSet.put(keyPath[i], key);
                    prevSet = key.subKeys;
                    ++i;
                }
                return key.values;
            }
            prevSet = key.subKeys;
        }
        return key.values;
    }

    @Override
    public String[] getKeys(String[] keyPath) {
        Map<String, RegistryKey> subKeys = this.registry_root;
        for (String aKeyPath : keyPath) {
            RegistryKey key = subKeys.get(aKeyPath);
            if (key == null) {
                return EMPTY_STRING_ARRAY;
            }
            subKeys = key.subKeys;
        }
        Set<String> set = subKeys.keySet();
        String[] keys = new String[set.size()];
        set.toArray(keys);
        return keys;
    }

    public CacheMap getCacheMap() {
        return this.cacheMap;
    }

    public void onBeforeComponentsLoad() throws Exception {
    }

    public void onAfterComponentsLoad() throws Exception {
    }

    public void onBeforeComponentsInit() throws Exception {
    }

    public void onAfterComponentsInit() throws Exception {
    }

    public void onBeforeComponentsClear() {
    }

    public void onAfterComponentsClear() {
    }

    @Override
    public boolean isOperationAllowedBySecurity(ClientModule module, String className) {
        Set<String> set = this.moduleOperations.get(module.getClass().getName());
        return set != null && set.contains(className);
    }

    @Override
    public boolean isWorkAreaAllowedBySecurity(ClientModule module, String className) {
        Set<String> set = this.moduleWorkAreas.get(module.getClass().getName());
        return set != null && set.contains(className);
    }

    @Override
    public boolean checkForManager(String managerName) {
        return this.validNames.contains(managerName);
    }

    protected Set<String> getValidNames() {
        return this.validNames;
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getManager(String managerName, Object owner) throws Exception {
        Object object;
        LogUtilClient.debug(LOGGER, String.format("Requesting manager %1$s", managerName));
        long startTime = System.currentTimeMillis();
        try {
            object = this.getManagerPrivate(managerName, owner);
        }
        catch (Throwable throwable) {
            LogUtilClient.debug(LOGGER, String.format("Total time to serve request for manager %1$s is %2$dms", managerName, System.currentTimeMillis() - startTime));
            throw throwable;
        }
        LogUtilClient.debug(LOGGER, String.format("Total time to serve request for manager %1$s is %2$dms", managerName, System.currentTimeMillis() - startTime));
        return (T)object;
    }

    @Override
    public <T> T getManager(String managerName) throws Exception {
        if (RemoteCallUtil.ownersStack.get().isEmpty()) {
            throw new Exception("There is no owner set for remote manager request");
        }
        Object owner = RemoteCallUtil.ownersStack.get().peek();
        return this.getManager(managerName, owner);
    }

    private Object getManagerPrivate(String managerName, Object owner) throws Exception {
        Map<String, OwnedManager> map = this.jndiMap.get();
        if (!map.isEmpty()) {
            for (String name : map.keySet()) {
                OwnedManager ownedManager = map.get(name);
                if (ClientTransactionManager.inTransaction() || System.currentTimeMillis() - ownedManager.timeout <= 300000L) continue;
                Throwable ex = null;
                Iterator<Throwable> iterator = ownedManager.owners.values().iterator();
                while (iterator.hasNext()) {
                    Throwable throwable;
                    ex = throwable = iterator.next();
                    LogUtilClient.error(LOGGER, String.format("Possible manager leak: %1$s", name), ex);
                }
                if (ex == null) continue;
                throw new Exception(String.format("Possible manager leak: %1$s", name), ex);
            }
        }
        Throwable ex = new Throwable("Recursive manager request");
        if (map.containsKey(managerName)) {
            OwnedManager ownedManager = map.get(managerName);
            if (!ownedManager.owners.containsKey(owner)) {
                ownedManager.owners.put(owner, ex);
            } else {
                Throwable ex1 = ownedManager.owners.get(owner);
                if (ex1.getStackTrace().length != ex.getStackTrace().length) {
                    ex1.printStackTrace();
                    ex.printStackTrace();
                } else {
                    ArrayList<Integer> diffLines = new ArrayList<Integer>();
                    for (int i = 0; i < ex1.getStackTrace().length; ++i) {
                        if (ex1.getStackTrace()[i].toString().equals(ex.getStackTrace()[i].toString())) continue;
                        diffLines.add(i);
                    }
                    for (Integer index : diffLines) {
                        StackTraceElement el1 = ex1.getStackTrace()[index];
                        StackTraceElement el2 = ex.getStackTrace()[index];
                        if (el1.getClassName().equals(el2.getClassName()) && el1.getMethodName().equals(el2.getMethodName())) continue;
                        ex1.printStackTrace();
                        ex.printStackTrace();
                    }
                }
            }
            LogUtilClient.debug(LOGGER, String.format("Manager found in already requested managers [%1$s]", managerName));
            ownedManager.timeout = System.currentTimeMillis();
            return ownedManager.manager;
        }
        Object result = this.getFromExternalCache(managerName);
        if (result == null) {
            if (ClientTransactionManager.inTransaction()) {
                for (OwnedManager manager : this.managersToRelease.get()) {
                    if (!manager.name.equals(managerName)) continue;
                    this.managersToRelease.get().remove(manager);
                    result = manager.manager;
                    break;
                }
            }
            if (result == null) {
                result = this.createNewInstance(managerName);
            }
        }
        return this.putObjectIntoMap(managerName, owner, map, result, ex);
    }

    @Override
    public void releaseManagers(Object owner) throws Exception {
        this.releaseManagers(owner, null);
    }

    @Override
    public void releaseManagers(Object owner, AccessException ex) throws Exception {
        Map<String, OwnedManager> map = this.jndiMap.get();
        for (String name : new HashSet<String>(map.keySet())) {
            OwnedManager ownedManager = map.get(name);
            if (ownedManager.owners.remove(owner) != null) {
                LogUtilClient.debug(LOGGER, String.format("Releasing manager %1$s", name));
            }
            if (!ownedManager.owners.isEmpty()) continue;
            map.remove(name);
            if (ex == null) {
                if (ClientTransactionManager.inTransaction()) {
                    this.managersToRelease.get().add(ownedManager);
                    continue;
                }
                this.releaseManager(name, ownedManager.manager);
                continue;
            }
            LogUtilClient.error(LOGGER, String.format("Error while accessing manager %1$s", name), ex);
        }
    }

    protected void releaseManager(String managerName, Object manager) throws Exception {
        this.removeSessionBean(manager);
    }

    protected void removeSessionBean(Object manager) throws Exception {
        if (manager instanceof EJBObject) {
            EJBObject o = (EJBObject)manager;
            EJBMetaData meta = o.getEJBHome().getEJBMetaData();
            if (meta.isStatelessSession()) {
                return;
            }
            o.remove();
        } else {
            this.callRemoveMethod(manager);
        }
    }

    private Method getRemoveMethod(Object o) {
        for (Method m : o.getClass().getMethods()) {
            Remove r = m.getAnnotation(Remove.class);
            if (r == null) continue;
            return m;
        }
        return null;
    }

    private void callRemoveMethod(Object o) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method m = this.getRemoveMethod(o);
        if (m != null) {
            m.invoke(o, new Object[0]);
        }
    }

    protected abstract Object getFromExternalCache(String var1);

    protected abstract Object createNewInstance(String var1) throws Exception;

    private Object putObjectIntoMap(String managerName, Object owner, Map<String, OwnedManager> map, Object object, Throwable mark) {
        OwnedManager ownedManager = new OwnedManager(managerName, object);
        map.put(managerName, ownedManager);
        ownedManager.owners.put(owner, mark);
        return ownedManager.manager;
    }

    @Override
    public void openCallbackQueue(MessageListener listener) throws NamingException, JMSException {
        ConnectionFactory qcf = (ConnectionFactory)this.getNamingContext().lookup("ConnectionFactory");
        Connection connQueue = qcf.createConnection();
        Session sessionQueue = connQueue.createSession(false, 1);
        TemporaryQueue tempQueue = sessionQueue.createTemporaryQueue();
        MessageConsumer messageConsumer = sessionQueue.createConsumer((Destination)tempQueue);
        messageConsumer.setMessageListener(listener);
        connQueue.start();
        CallbackQueue cbq = new CallbackQueue(connQueue, sessionQueue, messageConsumer);
        this.threadQueue.get().push(cbq);
        ClientContextFactory.getClientContext().setReportQueue((Queue)tempQueue);
    }

    @Override
    public void closeCallbackQueue() throws JMSException {
        ClientContextFactory.getClientContext().setReportQueue(null);
        CallbackQueue cbq = this.threadQueue.get().pop();
        if (cbq != null) {
            try {
                cbq.close();
            }
            finally {
                this.threadQueue.remove();
            }
        }
    }

    private class OwnedManager {
        Map<Object, Throwable> owners = new HashMap<Object, Throwable>();
        Object manager;
        long timeout = System.currentTimeMillis();
        String name;

        OwnedManager(String name, Object manager) {
            this.manager = manager;
            this.name = name;
        }
    }

    private class InvocationHandlerImp
    implements InvocationHandler {
        private String className;
        private Map<String, ?> itemMap;

        InvocationHandlerImp(String className, Map<String, ?> map) {
            this.className = className;
            this.itemMap = map;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object instance = this.itemMap.get(this.className);
            return method.invoke(instance, args);
        }
    }
}

