/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.impl;

import com.dsoft.framework.client.annotation.FrameworkItem;
import com.dsoft.framework.client.annotation.RequiredManager;
import com.dsoft.framework.client.annotation.RequiredManagers;
import com.dsoft.framework.client.annotation.RequiredOperations;
import com.dsoft.framework.client.base.ClientApplication;
import com.dsoft.framework.client.base.ClientModule;
import com.dsoft.framework.client.base.ClientWorkArea;
import com.dsoft.framework.client.base.InitializationException;
import com.dsoft.framework.client.base.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@FrameworkItem
public abstract class ClientModuleAdapter
implements ClientModule {
    protected Class<? extends Operation>[] operations;
    protected Class<? extends ClientWorkArea>[] workAreas;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected Set<Class<? extends Operation>> notInitializedOperations = new HashSet<Class<? extends Operation>>();
    protected Set<Operation> initializedOperations = new HashSet<Operation>();
    protected Set<Operation> fullyInitializedOperations = new HashSet<Operation>();
    protected List<ClientWorkArea> initializedWorkAreas = new ArrayList<ClientWorkArea>();
    protected Set<Class<? extends ClientWorkArea>> notInitializedWorkAreas = new HashSet<Class<? extends ClientWorkArea>>();

    public ClientModuleAdapter() {
        this.operations = this.fillOperationsArray();
        this.workAreas = this.fillWorkAreasArray();
    }

    @Override
    public void beginInitialization() throws InitializationException {
        this.fillAllowedOperationUnits();
        this.fillAllowedWorkAreas();
    }

    private void fillAllowedWorkAreas() {
        if (this.workAreas != null) {
            for (Class<? extends ClientWorkArea> wa : this.workAreas) {
                if (!ClientApplication.getSessionManager().isWorkAreaAllowedBySecurity(this, wa.getName())) continue;
                this.notInitializedWorkAreas.add(wa);
            }
        }
    }

    private void fillAllowedOperationUnits() {
        if (this.operations != null) {
            for (Class<? extends Operation> operation : this.operations) {
                if (!ClientApplication.getSessionManager().isOperationAllowedBySecurity(this, operation.getName())) continue;
                this.notInitializedOperations.add(operation);
            }
        }
    }

    public abstract Class<? extends Operation>[] fillOperationsArray();

    public abstract Class<? extends ClientWorkArea>[] fillWorkAreasArray();

    @Override
    public Class<? extends Operation>[] getOperations() {
        return this.operations;
    }

    @Override
    public Class<? extends ClientWorkArea>[] getWorkAreas() {
        return this.workAreas;
    }

    @Override
    public void finalizeInitialization() throws InitializationException {
    }

    @Override
    public void clean() {
        for (ClientWorkArea wa : this.initializedWorkAreas) {
            wa.clean();
        }
        for (Operation op : this.initializedOperations) {
            op.clean();
        }
        for (Operation op : this.fullyInitializedOperations) {
            op.clean();
        }
        this.notInitializedOperations.clear();
        this.initializedOperations.clear();
        this.fullyInitializedOperations.clear();
        this.notInitializedWorkAreas.clear();
        this.initializedWorkAreas.clear();
        this.attributes.clear();
        this.operations = null;
        this.workAreas = null;
    }

    public void operationInitialized(Operation op) {
    }

    protected abstract boolean checkWorkArea(Class<? extends ClientWorkArea> var1);

    protected ClientWorkArea createWorkAreaInstance(Class<? extends ClientWorkArea> workAreaClass) throws Exception {
        return workAreaClass.newInstance();
    }

    @Override
    public boolean initializeWorkAreas() throws InitializationException {
        int initialized = 0;
        Iterator<Class<? extends ClientWorkArea>> it = this.notInitializedWorkAreas.iterator();
        while (it.hasNext()) {
            ClientWorkArea workArea;
            Class<? extends ClientWorkArea> workAreaClass = it.next();
            if (!this.checkWorkArea(workAreaClass) || !this.processRequiredManager(workAreaClass) || !this.processRequiredOperations(workAreaClass)) continue;
            try {
                workArea = this.createWorkAreaInstance(workAreaClass);
            }
            catch (Exception ex) {
                throw new InitializationException(ex);
            }
            if (!workArea.initializeRequirements()) continue;
            ClientApplication.getSessionManager().registerWorkArea(workAreaClass.getName(), workArea);
            this.initializedWorkAreas.add(workArea);
            it.remove();
            ++initialized;
        }
        return initialized > 0;
    }

    protected Operation createOperationInstance(Class<? extends Operation> operationClass) throws Exception {
        return operationClass.newInstance();
    }

    @Override
    public boolean initializeOperations() throws InitializationException {
        boolean hasInitialized = false;
        Iterator<Class<? extends Operation>> it = this.notInitializedOperations.iterator();
        HashMap<Class<? extends Operation>, Operation> notInitializedOperationMap = new HashMap<Class<? extends Operation>, Operation>();
        while (it.hasNext()) {
            int result;
            Operation op;
            Class<? extends Operation> opClass = it.next();
            if (!this.processRequiredManager(opClass) || !this.processRequiredOperations(opClass)) continue;
            if (notInitializedOperationMap.containsKey(opClass)) {
                op = (Operation)notInitializedOperationMap.get(opClass);
            } else {
                try {
                    op = this.createOperationInstance(opClass);
                    notInitializedOperationMap.put(opClass, op);
                }
                catch (Exception ex) {
                    throw new InitializationException(ex);
                }
            }
            if ((result = op.initializeRequirements()) == 0) continue;
            it.remove();
            if (!ClientApplication.getSessionManager().registerOperation(op.getClass().getName(), op)) continue;
            switch (result) {
                case 1: {
                    this.initializedOperations.add(op);
                    break;
                }
                case 2: {
                    this.fullyInitializedOperations.add(op);
                }
            }
            op.finalizeInitialization(result);
            this.operationInitialized(op);
            it = this.notInitializedOperations.iterator();
            hasInitialized = true;
        }
        this.finalizeInitializedOperations();
        return hasInitialized;
    }

    private void finalizeInitializedOperations() throws RuntimeException {
        Iterator<Operation> opIt = this.initializedOperations.iterator();
        while (opIt.hasNext()) {
            Operation op = opIt.next();
            int result = op.initializeRequirements();
            switch (result) {
                case 2: {
                    opIt.remove();
                    if (!ClientApplication.getSessionManager().registerOperation(op.getClass().getName(), op)) break;
                    this.fullyInitializedOperations.add(op);
                    op.finalizeInitialization(result);
                    opIt = this.initializedOperations.iterator();
                    break;
                }
                case 0: {
                    throw new RuntimeException(String.format("Incorrect result for initialized state for operation %1$s", op.getClass().getName()));
                }
            }
        }
    }

    private boolean processRequiredManager(Class<?> cl) {
        while (cl != null) {
            RequiredManager requiredManagerAnnotation = cl.getAnnotation(RequiredManager.class);
            if (requiredManagerAnnotation == null) {
                RequiredManagers requiredManagersAnnotation = cl.getAnnotation(RequiredManagers.class);
                if (requiredManagersAnnotation != null) {
                    for (RequiredManager manager : requiredManagersAnnotation.value()) {
                        if (ClientApplication.getSessionManager().checkForManager(manager.value())) continue;
                        return false;
                    }
                }
            } else if (!ClientApplication.getSessionManager().checkForManager(requiredManagerAnnotation.value())) {
                return false;
            }
            cl = cl.getSuperclass();
        }
        return true;
    }

    private boolean processRequiredOperations(Class<?> cl) {
        while (cl != null) {
            RequiredOperations requiredOperationsAnnotation = cl.getAnnotation(RequiredOperations.class);
            if (requiredOperationsAnnotation != null) {
                for (Class<?> operationClass : requiredOperationsAnnotation.value()) {
                    Operation requiredOperation = ClientApplication.getSessionManager().getRegisterOperation(operationClass.getName());
                    if (requiredOperation != null) continue;
                    return false;
                }
            }
            cl = cl.getSuperclass();
        }
        return true;
    }

    @Override
    public void setProperty(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.attributes.get(name);
    }
}

