/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.impl;

import com.dsoft.framework.client.base.ClientApplication;
import com.dsoft.framework.client.impl.DSoftUserTransaction;
import com.dsoft.framework.logger.client.LogUtilClient;
import com.dsoft.framework.logger.client.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.tm.usertx.client.ClientUserTransaction;

public class ClientTransactionManager
implements DSoftUserTransaction {
    private static final Logger LOGGER = Logger.getLogger(ClientTransactionManager.class);
    private static ClientTransactionManager singleton = new ClientTransactionManager();
    private ThreadLocal<UserTransaction> threadTransaction = new ThreadLocal<UserTransaction>(){

        @Override
        protected UserTransaction initialValue() {
            try {
                Context ctx = ClientApplication.getSessionManager().getNamingContext();
                return (UserTransaction)PortableRemoteObject.narrow((Object)ctx.lookup("UserTransaction"), UserTransaction.class);
            }
            catch (Throwable th) {
                LogUtilClient.error(LOGGER, "Unable to lookup UserTransaction", th);
                return null;
            }
        }
    };
    private List<Synchronization> transactionSynchronizations = new ArrayList<Synchronization>();

    private ClientTransactionManager() {
    }

    public static DSoftUserTransaction getTransaction() {
        return singleton;
    }

    public void begin() throws NotSupportedException, SystemException {
        ClientTransactionManager.singleton.threadTransaction.get().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.beforeCompletion();
        ClientTransactionManager.singleton.threadTransaction.get().commit();
        this.afterCompletion(3);
    }

    public int getStatus() throws SystemException {
        UserTransaction transaction = ClientTransactionManager.singleton.threadTransaction.get();
        return transaction != null ? transaction.getStatus() : 6;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ClientTransactionManager.singleton.threadTransaction.get().rollback();
        this.afterCompletion(4);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ClientTransactionManager.singleton.threadTransaction.get().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        ClientTransactionManager.singleton.threadTransaction.get().setTransactionTimeout(seconds);
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws IllegalStateException, SystemException, RollbackException {
        this.transactionSynchronizations.add(sync);
    }

    private void beforeCompletion() {
        for (Synchronization sync : this.transactionSynchronizations) {
            sync.beforeCompletion();
        }
    }

    private void afterCompletion(int status) {
        for (Synchronization sync : this.transactionSynchronizations) {
            sync.afterCompletion(status);
        }
    }

    @Override
    public Object getTransactionId() {
        UserTransaction transaction = ClientTransactionManager.singleton.threadTransaction.get();
        if (transaction instanceof ClientUserTransaction) {
            return ((ClientUserTransaction)transaction).getTransactionPropagationContext();
        }
        return null;
    }

    public static boolean inTransaction() throws SystemException {
        return ClientTransactionManager.getTransaction().getStatus() == 0;
    }
}

