/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.impl;

import com.dsoft.framework.client.base.SerializableNode;
import com.dsoft.framework.client.base.SerializationContainer;
import com.dsoft.framework.client.impl.DefaultSerializationNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class DefaultSerializableContainer
extends DefaultSerializationNode
implements SerializationContainer {
    transient String fileName;
    transient String path;

    public DefaultSerializableContainer(String path, String fileName) {
        this.path = path;
        this.fileName = fileName;
    }

    @Override
    public SerializableNode createRootNode(String name) {
        return this.createChild(name);
    }

    @Override
    public SerializableNode getRootNode(String name) {
        return this.getChild(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() {
        String userHomePath = System.getProperty("user.home");
        String pathSeparator = System.getProperty("file.separator");
        String fullPath = userHomePath + pathSeparator + this.path + pathSeparator;
        File tempFile = new File(fullPath);
        tempFile.mkdirs();
        String fileName = fullPath + this.fileName;
        File file = new File(fileName);
        if (!file.exists()) {
            this.m_name = "root";
            this.m_childs = new HashMap();
            this.m_values = new HashMap();
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            try {
                ObjectInputStream oStream = new ObjectInputStream(stream);
                try {
                    this.m_name = (String)oStream.readObject();
                    this.m_childs = (HashMap)oStream.readObject();
                    this.m_values = (HashMap)oStream.readObject();
                }
                finally {
                    oStream.close();
                }
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            this.m_name = "root";
            this.m_childs = new HashMap();
            this.m_values = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException {
        String userHomePath = System.getProperty("user.home");
        String pathSeparator = System.getProperty("file.separator");
        String fullPath = userHomePath + pathSeparator + this.path + pathSeparator;
        File tempFile = new File(fullPath);
        tempFile.mkdirs();
        String fileName = fullPath + this.fileName;
        File file = new File(fileName);
        file.createNewFile();
        FileOutputStream stream = new FileOutputStream(file);
        try {
            ObjectOutputStream oStream = new ObjectOutputStream(stream);
            try {
                oStream.writeObject(this.m_name);
                oStream.writeObject(this.m_childs);
                oStream.writeObject(this.m_values);
            }
            finally {
                oStream.close();
            }
        }
        finally {
            stream.close();
        }
    }

    @Override
    public void clear() {
        this.m_childs.clear();
        this.m_values.clear();
    }
}

