/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.impl;

import com.dsoft.framework.client.base.SerializableNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultSerializationNode
implements SerializableNode {
    private static final long serialVersionUID = -8597850983263814155L;
    protected String m_name;
    protected Map<String, SerializableNode> m_childs = new HashMap<String, SerializableNode>();
    protected Map<String, Object> m_values = new HashMap<String, Object>();

    public DefaultSerializationNode() {
    }

    public DefaultSerializationNode(String name) {
        this.m_name = name;
    }

    @Override
    public SerializableNode getChild(String name) {
        return this.m_childs.get(name);
    }

    public Collection<SerializableNode> getChilds() {
        return this.m_childs.values();
    }

    @Override
    public Set<String> getChildNames() {
        return this.m_childs.keySet();
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Object getValue(String key) {
        return this.m_values.get(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this.m_values.put(key, value);
    }

    @Override
    public SerializableNode createChild(String name) {
        DefaultSerializationNode node = new DefaultSerializationNode(name);
        this.m_childs.put(name, node);
        return node;
    }

    @Override
    public void makeAsNode(SerializableNode node) {
        this.m_name = node.getName();
        for (String childName : node.getChildNames()) {
            this.m_childs.put(childName, node.getChild(childName));
        }
        for (String valueKey : node.getValueKeys()) {
            this.m_values.put(valueKey, node.getValue(valueKey));
        }
    }

    @Override
    public Set<String> getValueKeys() {
        return this.m_values.keySet();
    }

    @Override
    public SerializableNode removeChildNode(String name) {
        return this.m_childs.remove(name);
    }
}

