/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.impl;

import com.dsoft.framework.client.annotation.FrameworkItem;
import com.dsoft.framework.client.base.ClientApplication;
import com.dsoft.framework.client.base.KeyValueParam;
import com.dsoft.framework.client.base.Operation;
import com.dsoft.framework.client.base.OperationListener;
import com.dsoft.framework.client.base.PerformResult;
import com.dsoft.framework.client.exception.PerformRollbackException;
import com.dsoft.framework.client.impl.ClientTransactionManager;
import com.dsoft.framework.logger.client.LogUtilClient;
import com.dsoft.framework.util.client.TransactionHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@FrameworkItem(name="no name", description="Operation adapter description", version="1.0")
public abstract class OperationAdapter
implements Operation {
    private Set<OperationListener> operationListeners = new HashSet<OperationListener>();
    private Set<PropertyChangeListener> propChangeListeners = new HashSet<PropertyChangeListener>();
    private Object inputValue;
    private boolean transactionStarted;
    private boolean eventsFlag = true;
    private Map<String, Object> attributes;

    protected OperationAdapter() {
    }

    @Override
    public void addOperationListener(OperationListener listener) {
        this.operationListeners.add(listener);
    }

    @Override
    public void removeOperationListener(OperationListener listener) {
        this.operationListeners.remove(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeListeners.remove(listener);
    }

    @Override
    public void clearPropertyChangeListeners() {
        this.propChangeListeners.clear();
    }

    @Override
    public <T extends Operation> T getRealInstance(Class<T> cl) {
        return (T)this;
    }

    private Object operationInvoked_(Object value) throws Exception {
        Object result;
        block1: {
            OperationListener listener;
            result = this.operationInvoked(value);
            if (result != null) break block1;
            Iterator<OperationListener> iterator = this.operationListeners.iterator();
            while (iterator.hasNext() && (result = (listener = iterator.next()).operationInvoked(this, value)) == null) {
            }
        }
        return result;
    }

    protected Object operationInvoked(Object value) throws Exception {
        return null;
    }

    protected void operationPerformed(PerformResult performResult) throws PerformRollbackException {
    }

    private void operationPerformed_(PerformResult performResult) throws PerformRollbackException {
        this.operationPerformed(performResult);
        for (OperationListener listener : this.operationListeners) {
            listener.operationPerformed(this, performResult);
        }
    }

    protected void operationCompleted(PerformResult performResult) throws PerformRollbackException {
    }

    private void operationCompleted_(PerformResult performResult) throws PerformRollbackException {
        this.operationCompleted(performResult);
        for (OperationListener listener : this.operationListeners) {
            listener.operationCompleted(this, performResult);
        }
    }

    private void afterTransactionBegin_(Object value) throws PerformRollbackException {
        this.afterTransactionBegin();
        for (OperationListener listener : this.operationListeners) {
            listener.afterTransactionBegin(this, value);
        }
    }

    protected void afterTransactionBegin() throws PerformRollbackException {
    }

    private void beforeTransactionBegin_(Object result) throws Exception {
        this.beforeTransactionBegin(result);
        for (OperationListener listener : this.operationListeners) {
            listener.beforeTransactionBegin(this, result);
        }
    }

    protected void beforeTransactionBegin(Object result) throws Exception {
    }

    protected Object afterTransactionCommit(Object result) throws Exception {
        return result;
    }

    private Object afterTransactionCommit_(Object result) {
        try {
            result = this.afterTransactionCommit(result);
        }
        catch (Exception ex) {
            LogUtilClient.error(LogUtilClient.getLogger(this.getClass()), "Error in afterCommit", ex);
        }
        for (OperationListener listener : this.operationListeners) {
            listener.afterTransactionCommit(this, result);
        }
        return result;
    }

    @Override
    public void clean() {
    }

    protected void exceptionThrown(Throwable ex) {
        ClientApplication.getSessionManager().processException(ex);
    }

    @Override
    public PerformResult perform() {
        return this.perform(null);
    }

    @Override
    public PerformResult perform(Object value) {
        return this.perform(value, null);
    }

    @Override
    public PerformResult perform(Object value, KeyValueParam param) {
        PerformResult pr;
        block8: {
            this.inputValue = value;
            this.attributes = param != null ? param.getValueMap() : null;
            this.transactionStarted = false;
            pr = null;
            try {
                Object result = this.operationInvoked_(value);
                if (result == null) {
                    this.eventsFlag = true;
                    result = this.doOperation(value);
                }
                pr = this.commitPerformTransaction(result);
            }
            catch (Throwable e) {
                try {
                    pr = new PerformResult(null, false);
                    try {
                        this.operationPerformed_(pr);
                    }
                    catch (Throwable ex) {
                        this.exceptionThrown(ex);
                    }
                    this.rollbackTransaction();
                    if (!(e instanceof PerformRollbackException) && e.getCause() != e) {
                        this.exceptionThrown(e);
                    }
                }
                catch (Throwable ex) {
                    this.exceptionThrown(ex);
                }
                if (!(e instanceof PerformRollbackException) || e.getCause() == e) break block8;
                this.exceptionThrown(e.getCause());
            }
        }
        return pr;
    }

    protected void rollbackTransaction() {
        if (this.transactionStarted) {
            TransactionHelper.rollback();
            this.transactionStarted = false;
        }
    }

    protected abstract Object doOperation(Object var1) throws Exception;

    protected void beginTransaction(Object result, boolean require, int transactionTimeOut) throws Exception {
        this.eventsFlag = true;
        if (!require && this.noListeners()) {
            return;
        }
        if (ClientTransactionManager.getTransaction().getStatus() == 6) {
            this.beforeTransactionBegin_(result);
            if (transactionTimeOut > 0) {
                ClientTransactionManager.getTransaction().setTransactionTimeout(transactionTimeOut);
            } else {
                ClientTransactionManager.getTransaction().setTransactionTimeout(0);
            }
            ClientTransactionManager.getTransaction().begin();
            this.transactionStarted = true;
            this.afterTransactionBegin_(this.inputValue);
        }
    }

    protected void beginTransaction(Object result, boolean require) throws Exception {
        this.beginTransaction(result, require, 0);
    }

    protected boolean noListeners() {
        return this.operationListeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PerformResult commitPerformTransaction(Object result) throws Exception {
        PerformResult performResult;
        block20: {
            performResult = new PerformResult(result, result != null && result != Boolean.FALSE);
            try {
                if (this.eventsFlag) {
                    this.operationPerformed_(performResult);
                }
                this.eventsFlag = false;
                if (!this.transactionStarted) break block20;
            }
            catch (PerformRollbackException re) {
                try {
                    performResult = null;
                    throw re;
                }
                catch (Throwable throwable) {
                    this.eventsFlag = false;
                    if (this.transactionStarted) {
                        try {
                            if (performResult == null || !performResult.isSuccessful()) {
                                try {
                                    ClientTransactionManager.getTransaction().rollback();
                                }
                                catch (Exception exception) {}
                            } else {
                                ClientTransactionManager.getTransaction().commit();
                                result = this.afterTransactionCommit_(result);
                                performResult = new PerformResult(result, result != null && result != Boolean.FALSE);
                            }
                        }
                        finally {
                            this.transactionStarted = false;
                        }
                    }
                    this.operationCompleted_(performResult);
                    throw throwable;
                }
            }
            try {
                if (performResult == null || !performResult.isSuccessful()) {
                    try {
                        ClientTransactionManager.getTransaction().rollback();
                    }
                    catch (Exception exception) {}
                } else {
                    ClientTransactionManager.getTransaction().commit();
                    result = this.afterTransactionCommit_(result);
                    performResult = new PerformResult(result, result != null && result != Boolean.FALSE);
                }
            }
            finally {
                this.transactionStarted = false;
            }
        }
        this.operationCompleted_(performResult);
        return performResult;
    }

    protected void clearEventsFlag() {
        this.eventsFlag = false;
    }

    protected void setEventsFlag() {
        this.eventsFlag = true;
    }

    @Override
    public <T> T getValue(String name) {
        return (T)(this.attributes == null ? null : this.attributes.get(name));
    }

    @Override
    public void firePropertyChanged(String name, Object value, Object oldValue) {
        boolean changed;
        boolean bl = changed = oldValue != value && (oldValue == null || value == null || !oldValue.equals(value));
        if (changed) {
            for (PropertyChangeListener listener : this.propChangeListeners) {
                listener.propertyChange(new PropertyChangeEvent(this, name, oldValue, value));
            }
        }
    }

    @Override
    public int initializeRequirements() {
        return 2;
    }

    @Override
    public void finalizeInitialization(int initializeState) {
    }

    public Object getInputValue() {
        return this.inputValue;
    }
}

