/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.util;

import com.dsoft.framework.client.exception.InvalidIPFormatException;
import com.dsoft.framework.util.client.StringUtil;
import java.util.StringTokenizer;

public class IPUtils {
    public static String ipLongToString(long ip) {
        return String.format("%1$s.%2$s.%3$s.%4$s", ip >> 24, ip >> 16 & 0xFFL, ip >> 8 & 0xFFL, ip & 0xFFL);
    }

    public static String ipLongToString(Long ipl) {
        if (ipl == null) {
            return null;
        }
        return IPUtils.ipLongToString((long)ipl);
    }

    public static long ipStringToLong(String str) throws InvalidIPFormatException {
        long ip = 0L;
        if (str != null) {
            StringTokenizer tokenizer = new StringTokenizer(str.trim(), ".");
            if (tokenizer.countTokens() != 4) {
                throw new InvalidIPFormatException(str);
            }
            while (tokenizer.hasMoreTokens()) {
                long num;
                try {
                    num = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException ex) {
                    throw new InvalidIPFormatException(str);
                }
                if (num < 0L || num > 255L) {
                    throw new InvalidIPFormatException(str);
                }
                ip <<= 8;
                ip |= num;
            }
            return ip;
        }
        return 0L;
    }

    public static Long ipStringToLong2(String str) throws InvalidIPFormatException {
        if (str == null) {
            return null;
        }
        return IPUtils.ipStringToLong(str);
    }

    public static boolean checkIP(String ip, boolean acceptEmpty) {
        if (acceptEmpty && StringUtil.isEmpty(ip)) {
            return true;
        }
        if (StringUtil.isEmpty(ip)) {
            return false;
        }
        if (ip.charAt(0) == '.' || ip.charAt(ip.length() - 1) == '.') {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(ip, ".");
        if (tok.countTokens() != 4) {
            return false;
        }
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            try {
                int i = Integer.parseInt(token);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static int calculateMaskFields(long netAddress, long netMask) {
        int maskBits = 0;
        long tmp = (netAddress | netMask ^ 0xFFFFFFFFL) - netAddress;
        while (tmp > 0L) {
            tmp /= 2L;
            ++maskBits;
        }
        return 32 - maskBits;
    }

    public static long ipWithPortStringToLong(String strIP) throws InvalidIPFormatException {
        try {
            int index = strIP.indexOf("/");
            strIP = strIP.substring(0, index);
            long ipLong = IPUtils.ipStringToLong(strIP);
            return ipLong;
        }
        catch (Exception e) {
            if (e instanceof InvalidIPFormatException) {
                throw (InvalidIPFormatException)e;
            }
            throw new InvalidIPFormatException(e);
        }
    }

    public static boolean isValidNetMask(String mask) {
        StringTokenizer st = new StringTokenizer(mask, ".");
        int[] tetra = new int[4];
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                return false;
            }
            tetra[i] = Integer.parseInt(st.nextToken());
        }
        boolean prevTetraIsBelow255 = false;
        for (int i = 0; i < 4; ++i) {
            if (!prevTetraIsBelow255 && tetra[i] == 255) continue;
            if (tetra[i] == 0) {
                prevTetraIsBelow255 = true;
                continue;
            }
            if (prevTetraIsBelow255) {
                return false;
            }
            boolean bl = prevTetraIsBelow255 = tetra[i] != 255;
            if (tetra[i] == 128 || tetra[i] == 192 || tetra[i] == 224 || tetra[i] == 240 || tetra[i] == 248 || tetra[i] == 252 || tetra[i] == 254) continue;
            return false;
        }
        return true;
    }
}

