/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.client.util;

import com.dsoft.framework.client.exception.InvalidMacAddress;
import com.dsoft.framework.util.client.StringUtil;
import java.util.StringTokenizer;

public class InternetUtils {
    public static long macStringToLong(String mac) throws InvalidMacAddress {
        StringTokenizer macTokenizer = new StringTokenizer(mac, ":", false);
        return InternetUtils.macStringToLong(macTokenizer, mac);
    }

    public static int[] macStringToByte(String mac) throws InvalidMacAddress {
        StringTokenizer macTokenizer = new StringTokenizer(mac, ":", false);
        return InternetUtils.macStringToByte(macTokenizer, mac);
    }

    public static String macByteToString(int[] mac) {
        return String.format("%1$02x:%2$02x:%3$02x:%4$02x:%5$02x:%6$02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    }

    private static int[] macStringToByte(StringTokenizer macTokenizer, String mac) throws InvalidMacAddress {
        int[] byteMac = new int[6];
        int index = 0;
        while (macTokenizer.hasMoreTokens() && index < byteMac.length) {
            int macToken;
            try {
                macToken = Integer.parseInt(macTokenizer.nextToken(), 16);
            }
            catch (NumberFormatException ex) {
                throw new InvalidMacAddress(mac);
            }
            if (macToken < 0 || macToken > 255) {
                throw new InvalidMacAddress(mac);
            }
            byteMac[index++] = macToken;
        }
        if (macTokenizer.hasMoreTokens()) {
            throw new InvalidMacAddress(mac);
        }
        return byteMac;
    }

    private static long macStringToLong(StringTokenizer macTokenizer, String mac) throws InvalidMacAddress {
        long lmac = 0L;
        int[] intMac = InternetUtils.macStringToByte(macTokenizer, mac);
        for (int i = 0; i < 6; ++i) {
            lmac <<= 8;
            lmac |= (long)intMac[i];
        }
        return lmac;
    }

    public static String macLongToString(long mac) {
        StringBuilder strMac = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            String macToken = String.format("%1$02x", mac & 0xFFL);
            strMac.insert(0, macToken);
            mac >>= 8;
            if (i >= 5) continue;
            strMac.insert(0, ":");
        }
        return strMac.toString();
    }

    public static boolean checkMac(String macAddress, boolean canBeEmpty) {
        if (canBeEmpty && StringUtil.isEmpty(macAddress)) {
            return true;
        }
        if (macAddress != null) {
            StringTokenizer macTokenizer = new StringTokenizer(macAddress, ":", false);
            if (macTokenizer.countTokens() != 6) {
                return false;
            }
            try {
                InternetUtils.macStringToLong(macTokenizer, macAddress);
            }
            catch (InvalidMacAddress ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static Long strTrafficToLong(String text) {
        if (StringUtil.isEmpty(text)) {
            return null;
        }
        Long result = null;
        text = text.trim();
        int idx = 0;
        StringBuilder digits = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        for (char c : text.toUpperCase().toCharArray()) {
            if (!Character.isDigit(c)) {
                if (idx == 0) break;
                if (result == null) {
                    result = Long.parseLong(digits.toString());
                }
                if (Character.isSpaceChar(c)) continue;
                suffix.append(Character.toUpperCase(c));
                continue;
            }
            digits.append(c);
            ++idx;
        }
        if (result != null) {
            if ("GB".equals(suffix.toString())) {
                result = result * 0x100000L;
            } else if ("MB".equals(suffix.toString())) {
                result = result * 1024L;
            } else if (!"KB".equals(suffix.toString())) {
                return null;
            }
        }
        return result;
    }

    public static String getTrafficAsString(Long traffic) {
        long maxTraffic;
        long l = maxTraffic = traffic != null ? traffic : -1L;
        if (maxTraffic == -1L) {
            return "unlimited";
        }
        String suffix = "KB";
        if (maxTraffic % 1024L == 0L) {
            maxTraffic /= 1024L;
            suffix = "MB";
        }
        if (maxTraffic % 1024L == 0L) {
            maxTraffic /= 1024L;
            suffix = "GB";
        }
        return maxTraffic + suffix;
    }

    public static String getTrafficAsDoubleString(Long longTraffic) {
        double traffic;
        double d = traffic = longTraffic != null ? (double)longTraffic.longValue() : -1.0;
        if (traffic == -1.0) {
            return "";
        }
        String suffix = "KB";
        if (traffic / 1024.0 >= 1.0) {
            traffic /= 1024.0;
            suffix = "MB";
        }
        if (traffic / 1024.0 >= 1.0) {
            traffic /= 1024.0;
            suffix = "GB";
        }
        return String.format("%1$.2f%2$s", traffic, suffix);
    }

    public static String fixMac(String mac) {
        String string = mac = mac != null ? mac.trim() : null;
        if (mac != null) {
            StringBuilder macBuilder = new StringBuilder(mac);
            while (macBuilder.length() < 12) {
                macBuilder.append("0");
            }
            mac = macBuilder.toString();
            StringBuilder macSb = new StringBuilder(mac);
            int idx = 2;
            while (macSb.length() < 17) {
                macSb.insert(idx, ":");
                idx += 3;
            }
            return macSb.toString();
        }
        return null;
    }
}

