/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.enterprise.client.dto;

import com.dsoft.framework.client.base.BaseDTO;
import java.util.Arrays;

public class AccountPolicyDTO
extends BaseDTO {
    byte[] policyAsBytes;

    public AccountPolicyDTO() {
        this.policyAsBytes = new byte[168];
    }

    public AccountPolicyDTO(byte[] policy) {
        this.policyAsBytes = policy;
    }

    public AccountPolicyDTO(AccountPolicyDTO ap) {
        this.policyAsBytes = (byte[])ap.policyAsBytes.clone();
    }

    public void setPolicyFor(int dayOfWeek, int hour, boolean enabled) {
        this.setModified(this.policyAsBytes[(dayOfWeek - 1) * 24 + hour] != (byte)(enabled ? 1 : 0), false, "policy");
        this.policyAsBytes[(dayOfWeek - 1) * 24 + hour] = (byte)(enabled ? 1 : 0);
    }

    public boolean getPolicyFor(int dayOfWeek, int hour) {
        return this.policyAsBytes[(dayOfWeek - 1) * 24 + hour] != 0;
    }

    public void setBytes(byte[] bytes) {
        this.setModified(!Arrays.equals(this.policyAsBytes, bytes), false, "policy");
        this.policyAsBytes = bytes;
    }

    public byte[] getBytes() {
        return this.policyAsBytes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPolicyDTO)) {
            return false;
        }
        AccountPolicyDTO that = (AccountPolicyDTO)obj;
        return Arrays.equals(this.policyAsBytes, that.policyAsBytes);
    }
}

