/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.enterprise.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.framework.enterprise.client.dto.AccountPolicyDTO;
import com.dsoft.framework.enterprise.client.dto.GroupDTO;
import com.dsoft.framework.enterprise.client.dto.RoleDTO;
import com.dsoft.framework.util.client.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Set;

@ServerLoader(value="BaseAccountLoaderLocal")
public class BaseAccountDTO
extends HistoryDTO {
    private String username;
    private boolean enabled = false;
    private Long passwordExpireDate;
    private boolean passwordExpirable;
    private boolean changeAtNextLogin;
    private boolean cannotChangePassword;
    private DTOSet<GroupDTO, Integer> accountGroups = new DTOSet(GroupDTO.class, this);
    private DTOSet<RoleDTO, Integer> accountEnabledRoles = new DTOSet(RoleDTO.class, this);
    private DTOSet<RoleDTO, Integer> accountDisabledRoles = new DTOSet(RoleDTO.class, this);
    private Set<Integer> grantGroups = new HashSet<Integer>();
    private String logMessage;
    private AccountPolicyDTO accountPolicy = new AccountPolicyDTO(){
        {
            this.setParent(BaseAccountDTO.this);
        }
    };
    private Integer visibleResults;
    private transient Set<RoleDTO> accountRoles = null;

    public void setUsername(String username) throws PropertyVetoException {
        if (StringUtil.isEmpty(username)) {
            throw new PropertyVetoException("User name is required field!", new PropertyChangeEvent(this, "username", this.username, username));
        }
        this.setModified(this.username, username, "username");
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setAccountEnabled(boolean enabled) {
        this.setModified(this.enabled, enabled, "enabled");
        this.enabled = enabled;
    }

    public void setCanChangePassword(boolean canChangePassword) throws PropertyVetoException {
        this.setModified(this.cannotChangePassword, this.cannotChangePassword, "cannotChangePassword");
        this.cannotChangePassword = !canChangePassword;
    }

    public boolean canChangePassword() {
        return !this.cannotChangePassword;
    }

    public void setChangeAtNextLogin(boolean changeAtNextLogin) {
        this.setModified(this.changeAtNextLogin, changeAtNextLogin, "changeAtNextLogin");
        this.changeAtNextLogin = changeAtNextLogin;
    }

    public boolean getChangeAtNextLogin() {
        return this.changeAtNextLogin;
    }

    public void setPasswordExpirable(boolean e) {
        this.setModified(this.passwordExpirable, e, "passwordExpirable");
        this.passwordExpirable = e;
    }

    public void setPasswordExpireDate(Long passwordExpireDate) {
        this.setModified(this.passwordExpireDate, passwordExpireDate, "passwordExpireDate");
        this.passwordExpireDate = passwordExpireDate;
    }

    public void setEnabled(boolean enabled) {
        this.setModified(this.enabled, enabled, "enabled");
        this.enabled = enabled;
    }

    public void setCanNotChangePassword(boolean cannotChangePassword) {
        this.setModified(this.cannotChangePassword, cannotChangePassword, "cannotChangePassword");
        this.cannotChangePassword = cannotChangePassword;
    }

    public boolean isPasswordExpirable() {
        return this.passwordExpirable;
    }

    public Long getPasswordExpireDate() {
        return this.passwordExpireDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean canNotChangePassword() {
        return this.cannotChangePassword;
    }

    public DTOSet<GroupDTO, Integer> getAccountGroups() {
        return this.accountGroups;
    }

    public AccountPolicyDTO getAccountPolicy() {
        return this.accountPolicy;
    }

    public DTOSet<RoleDTO, Integer> getAccountEnabledRoles() {
        return this.accountEnabledRoles;
    }

    public DTOSet<RoleDTO, Integer> getAccountDisabledRoles() {
        return this.accountDisabledRoles;
    }

    @Override
    public String toString() {
        return this.username;
    }

    public void setVisibleResults(Integer visibleAccountsCount) {
        this.setModified(this.visibleResults, visibleAccountsCount, "visibleAccountsCount");
        this.visibleResults = visibleAccountsCount;
    }

    public void setLogMessage(String logMessage) {
        this.setModified(this.logMessage, logMessage, "logMessage");
        this.logMessage = logMessage;
    }

    public void setGrantGroups(Set<Integer> grantGroups) {
        this.setModified(this.grantGroups, grantGroups, "grantGroups");
        this.grantGroups.clear();
        if (grantGroups != null) {
            this.grantGroups.addAll(grantGroups);
        }
    }

    public boolean canGrant(Integer groupId) {
        return this.grantGroups.contains(groupId);
    }

    public void setGrantGroup(Integer groupId, boolean grant) {
        if (grant) {
            this.setModified(this.grantGroups.add(groupId), Boolean.TRUE, "grantGroups");
        } else {
            this.setModified(this.grantGroups.remove(groupId), Boolean.TRUE, "grantGroups");
        }
    }

    public Integer getVisibleResults() {
        return this.visibleResults;
    }

    public Set<Integer> getGrantGroups() {
        return new HashSet<Integer>(this.grantGroups);
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public Set<RoleDTO> getAccountRoles() {
        if (this.accountRoles == null) {
            this.accountRoles = new HashSet<RoleDTO>();
            HashSet groupEnabledRoles = new HashSet();
            HashSet groupDisabledRoles = new HashSet();
            for (GroupDTO groupDto : this.accountGroups) {
                groupEnabledRoles.addAll(groupDto.getGroupEnabledRoles());
                groupDisabledRoles.addAll(groupDto.getGroupDisabledRoles());
            }
            groupEnabledRoles.removeAll(groupDisabledRoles);
            groupEnabledRoles.removeAll(this.accountDisabledRoles);
            groupEnabledRoles.addAll(this.accountEnabledRoles);
            this.accountRoles.addAll(groupEnabledRoles);
        }
        return this.accountRoles;
    }
}

