/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.enterprise.client.dto;

import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.framework.enterprise.client.dto.RoleDTO;
import com.dsoft.framework.enterprise.client.dto.ServerSubmoduleDTO;
import com.dsoft.framework.enterprise.client.utils.VersionCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerModuleDTO
extends HistoryDTO {
    private String name;
    private String version;
    private String jarName;
    private String moduleId;
    private String installClassName;
    private String licenseClassName;
    private String alias;
    private String bootClassName;
    private DTOSet<RoleDTO, Integer> moduleRoles = new DTOSet(RoleDTO.class, this, true);
    private List<ServerSubmoduleDTO> subModules = new ArrayList<ServerSubmoduleDTO>();
    private transient Map<String, String> roleAliases = new HashMap<String, String>();

    public ServerModuleDTO(ServerModuleDTO serverModuleDto) {
        super(serverModuleDto);
        this.copyFields(serverModuleDto);
    }

    private void copyFields(ServerModuleDTO serverModuleDto) {
        if (serverModuleDto != null) {
            this.setName(serverModuleDto.getName());
            this.setVersion(serverModuleDto.getVersion());
            this.setJarName(serverModuleDto.getJarName());
            this.setModuleId(serverModuleDto.getModuleId());
            this.setInstallClassName(serverModuleDto.getInstallClassName());
            this.setLicenseClassName(serverModuleDto.getLicenseClassName());
            this.getModuleRoles().clear();
            this.getModuleRoles().addAll(serverModuleDto.getModuleRoles());
            this.getSubModules().clear();
            this.getSubModules().addAll(serverModuleDto.getSubModules());
        }
    }

    public ServerModuleDTO() {
    }

    public String getInstallClassName() {
        return this.installClassName;
    }

    public void setInstallClassName(String installClassName) {
        this.setModified(this.installClassName, installClassName, "installClassName");
        this.installClassName = installClassName;
    }

    public void setVersion(String version) {
        this.setModified(this.version, version, "version");
        this.version = version;
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public void setLicenseClassName(String licenseClassName) {
        this.setModified(this.licenseClassName, licenseClassName, "licenseClassName");
        this.licenseClassName = licenseClassName;
    }

    public void setJarName(String jarName) {
        this.setModified(this.jarName, jarName, "jarName");
        this.jarName = jarName;
    }

    public void setModuleId(String moduleId) {
        this.setModified(this.moduleId, moduleId, "moduleId");
        this.moduleId = moduleId;
    }

    public void setAlias(String alias) {
        this.setModified(this.alias, alias, "alias");
        this.alias = alias;
    }

    public void setBootClassName(String bootClassName) {
        this.setModified(this.bootClassName, bootClassName, "bootClassName");
        this.bootClassName = bootClassName;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getLicenseClassName() {
        return this.licenseClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public DTOSet<RoleDTO, Integer> getModuleRoles() {
        return this.moduleRoles;
    }

    public boolean isSubmoduleInstalled(String submoduleId) {
        for (ServerSubmoduleDTO subModuleDto : this.subModules) {
            if (!subModuleDto.getSubModuleId().equals(submoduleId)) continue;
            return true;
        }
        return false;
    }

    public List<ServerSubmoduleDTO> getSubModules() {
        return this.subModules;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getBootClassName() {
        return this.bootClassName;
    }

    public long getVersionLong() {
        return VersionCalculator.getVersionLong(this.version);
    }
}

