/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.enterprise.client.dto;

import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.enterprise.client.dto.OperationDTO;
import com.dsoft.framework.enterprise.client.dto.RoleDTO;
import com.dsoft.framework.enterprise.client.dto.WorkAreaDTO;
import com.dsoft.framework.enterprise.client.utils.VersionCalculator;

public class UIModuleDTO
extends IntegerIdDTO {
    private String name;
    private String className;
    private String version;
    private String description;
    private String moduleId;
    private DTOSet<RoleDTO, Integer> requiredRoles = new DTOSet(RoleDTO.class, this, true);
    private DTOSet<OperationDTO, Integer> operations = new DTOSet(OperationDTO.class, this, true);
    private DTOSet<WorkAreaDTO, Integer> workAreas = new DTOSet(WorkAreaDTO.class, this, true);

    public UIModuleDTO() {
    }

    public UIModuleDTO(UIModuleDTO uiModuleDto) {
        super(uiModuleDto);
        this.copyFields(uiModuleDto);
    }

    private void copyFields(UIModuleDTO uiModuleDto) {
        if (uiModuleDto != null) {
            this.setName(uiModuleDto.getName());
            this.setVersion(uiModuleDto.getVersion());
            this.setClassName(uiModuleDto.getClassName());
            this.setDescription(uiModuleDto.getDescription());
            this.setModuleId(uiModuleDto.getModuleId());
            this.getRequiredRoles().clear();
            this.getRequiredRoles().addAll(uiModuleDto.getRequiredRoles());
            this.getOperations().clear();
            this.getOperations().addAll(uiModuleDto.getOperations());
            this.getWorkAreas().clear();
            this.getWorkAreas().addAll(uiModuleDto.getWorkAreas());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.setModified(this.className, className, "className");
        this.className = className;
    }

    public void setVersion(String version) {
        this.setModified(this.version, version, "version");
        this.version = version;
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public void setDescription(String description) {
        this.setModified(this.description, description, "description");
        this.description = description;
    }

    public void setModuleId(String moduleId) {
        this.setModified(this.moduleId, moduleId, "moduleId");
        this.moduleId = moduleId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public DTOSet<RoleDTO, Integer> getRequiredRoles() {
        return this.requiredRoles;
    }

    public DTOSet<WorkAreaDTO, Integer> getWorkAreas() {
        return this.workAreas;
    }

    public DTOSet<OperationDTO, Integer> getOperations() {
        return this.operations;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public long getVersionLong() {
        return VersionCalculator.getVersionLong(this.version);
    }
}

