/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.scheduled_jobs.client.dto;

import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.client.util.CopyObjectUtil;
import com.dsoft.framework.scheduled_jobs.client.dto.JobPriority;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class JobTasksDTO
extends IntegerIdDTO {
    private String name;
    private String executor;
    private long timeToExecute;
    private Long completed;
    private Throwable exitStatus;
    private Serializable jobInfo;
    private Long timeOut;
    private Long wait_TimeOut;
    private Integer retries;
    private Integer marker;
    private JobPriority priority;
    private byte[] exitStatusBytes;
    private byte[] jobInfoBytes;
    private boolean jobInfoLoaded;

    public JobTasksDTO() {
    }

    public JobTasksDTO(Integer id, String taskName, String executor, long executeTime, int retries, long executeTimeOut, long waitBetweenRetries, Integer marker, JobPriority priority) {
        this.setId(id);
        this.name = taskName;
        this.executor = executor;
        this.timeToExecute = executeTime;
        this.retries = retries;
        this.timeOut = executeTimeOut;
        this.wait_TimeOut = waitBetweenRetries;
        this.marker = marker;
        this.priority = priority;
    }

    public JobTasksDTO(String taskName, String executor, long executeTime, int retries, long executeTimeOut, long waitBetweenRetries, Serializable jobInfo, Integer marker, JobPriority priority) {
        this.name = taskName;
        this.executor = executor;
        this.timeToExecute = executeTime;
        this.retries = retries;
        this.timeOut = executeTimeOut;
        this.wait_TimeOut = waitBetweenRetries;
        this.jobInfo = jobInfo;
        this.marker = marker;
        this.priority = priority;
        this.jobInfoLoaded = true;
    }

    public JobTasksDTO(JobTasksDTO dto) {
        super(dto);
        this.name = dto.name;
        this.executor = dto.executor;
        this.timeToExecute = dto.timeToExecute;
        this.retries = dto.retries;
        this.timeOut = dto.timeOut;
        this.wait_TimeOut = dto.wait_TimeOut;
        this.jobInfoBytes = dto.jobInfoBytes;
        this.marker = dto.marker;
        this.priority = dto.priority;
        this.jobInfoLoaded = dto.jobInfoLoaded;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public String getExecutor() {
        return this.executor;
    }

    public void setExecutor(String executor) {
        this.setModified(this.executor, executor, "executor");
        this.executor = executor;
    }

    public long getTimeToExecute() {
        return this.timeToExecute;
    }

    public void setTimeToExecute(long timeToExecute) {
        this.setModified(this.timeToExecute, timeToExecute, "timeToExecute");
        this.timeToExecute = timeToExecute;
    }

    public Long getCompleted() {
        return this.completed;
    }

    public void setCompleted(Long completed) {
        this.setModified(this.completed, completed, "completed");
        this.completed = completed;
    }

    public Throwable getExitStatus() throws ClassNotFoundException, IOException {
        if (this.exitStatus == null && this.exitStatusBytes != null) {
            Object o = CopyObjectUtil.byteArrayToObject(this.exitStatusBytes);
            this.exitStatus = o instanceof Throwable ? (Throwable)o : new Exception((String)o);
        }
        return this.exitStatus;
    }

    public void setExitStatus(Throwable exitStatus) {
        this.setModified(this.exitStatus, exitStatus, "exitStatus");
        this.exitStatus = exitStatus;
    }

    public Serializable getJobInfo() throws ClassNotFoundException, IOException {
        if (this.jobInfo == null && this.jobInfoBytes != null) {
            this.jobInfo = (Serializable)CopyObjectUtil.byteArrayToObject(this.jobInfoBytes, Thread.currentThread().getContextClassLoader());
        }
        return this.jobInfo;
    }

    public Long getWait_TimeOut() {
        return this.wait_TimeOut;
    }

    public Long getTimeOut() {
        return this.timeOut;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Integer getMarker() {
        return this.marker;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    public byte[] getJobInfoBytes() {
        return this.jobInfoBytes;
    }

    public boolean isJobInfoLoaded() {
        return this.jobInfoLoaded;
    }

    public void setJobInfo(Serializable jobInfo) {
        this.jobInfoLoaded = true;
        this.setModified(this.jobInfo, jobInfo, "jobInfo");
        this.jobInfo = jobInfo;
    }

    public void setWait_TimeOut(Long wait_TimeOut) {
        this.setModified(this.wait_TimeOut, wait_TimeOut, "wait_TimeOut");
        this.wait_TimeOut = wait_TimeOut;
    }

    public void setTimeOut(Long timeOut) {
        this.setModified(this.timeOut, timeOut, "timeOut");
        this.timeOut = timeOut;
    }

    public void setRetries(Integer retries) {
        this.setModified(this.retries, retries, "retries");
        this.retries = retries;
    }

    public void setMarker(Integer marker) {
        this.setModified(this.marker, marker, "marker");
        this.marker = marker;
    }

    public void setPriority(JobPriority priority) {
        this.setModified((Object)this.priority, (Object)priority, "priority");
        this.priority = priority;
    }

    public void setJobInfoBytes(byte[] jobInfoBytes) {
        this.jobInfoLoaded = true;
        this.jobInfoBytes = jobInfoBytes;
    }

    public void setExitStatusBytes(byte[] exitStatusBytes) {
        this.exitStatusBytes = exitStatusBytes;
    }

    @Override
    public String toString() {
        return "[name:" + this.name + ", executor:" + this.executor + ", timeToExecute:" + new Date(this.timeToExecute).toString() + ", jobInfo:" + this.jobInfo + "]";
    }
}

