/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.util.client;

import com.dsoft.framework.client.exception.UnsupportedDatabaseException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public class DB2SQLMethodMapper {
    public static String getMethodSuffix(Connection db, boolean versionSpecific) throws SQLException, UnsupportedDatabaseException {
        String dbName = db.getMetaData().getDatabaseProductName();
        String dbVersion = db.getMetaData().getDatabaseProductVersion();
        if ("Oracle".equals(dbName)) {
            if (versionSpecific) {
                if (dbVersion != null) {
                    if (dbVersion.contains("Oracle9i")) {
                        return "Oracle_9i";
                    }
                    if (dbVersion.contains("11g")) {
                        return "Oracle_11g";
                    }
                }
                throw new UnsupportedDatabaseException("Unsupported database %1$s", new Serializable[]{dbVersion});
            }
            return "Oracle";
        }
        if ("MySQL".equals(dbName)) {
            return "MySQL";
        }
        if (dbName.startsWith("Firebird")) {
            if (versionSpecific && dbVersion != null) {
                if (dbVersion.contains("1.5")) {
                    return "Firebird1_5";
                }
                if (dbVersion.contains("2.0")) {
                    return "Firebird2_0";
                }
                if (dbVersion.contains("2.1")) {
                    return "Firebird2_1";
                }
                if (dbVersion.contains("2.5")) {
                    return "Firebird2_5";
                }
                if (dbVersion.contains("3.0")) {
                    return "Firebird3_0";
                }
            }
            return "Firebird";
        }
        throw new UnsupportedDatabaseException("Unsupported database %1$s", new Serializable[]{dbVersion});
    }

    public static String getDefaultSQLMethodName(String name, Connection c, boolean versionSpecific) throws SQLException, UnsupportedDatabaseException {
        return name + DB2SQLMethodMapper.getMethodSuffix(c, versionSpecific);
    }

    public static Method getSQLMethod(Class<?> methodClass, String methodName, Class<?>[] methodDef, Connection db) throws SQLException, UnsupportedDatabaseException {
        try {
            return methodClass.getMethod(DB2SQLMethodMapper.getDefaultSQLMethodName(methodName, db, true), methodDef);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException();
        }
    }

    public static Method getSQLMethod(Object methodObject, String methodName, Class<?>[] methodDef, Connection db) throws SQLException, UnsupportedDatabaseException {
        return DB2SQLMethodMapper.getSQLMethod(methodObject.getClass(), methodName, methodDef, db);
    }

    public static Method getSQLMethod(Class<?> methodClass, String methodName, Connection db) throws SQLException, UnsupportedDatabaseException {
        String dbSpecificName = DB2SQLMethodMapper.getDefaultSQLMethodName(methodName, db, false);
        String versionSpecificName = DB2SQLMethodMapper.getDefaultSQLMethodName(methodName, db, true);
        Method[] methods = methodClass.getMethods();
        Method commonMethod = null;
        Method dbMethod = null;
        for (Method m : methods) {
            if (m.getName().equals(versionSpecificName)) {
                return m;
            }
            if (m.getName().equals(dbSpecificName)) {
                dbMethod = m;
            }
            if (!m.getName().equals(methodName)) continue;
            commonMethod = m;
        }
        if (dbMethod != null) {
            return dbMethod;
        }
        if (commonMethod != null) {
            return commonMethod;
        }
        throw new UnsupportedDatabaseException("Unsupported database %1$s for method %2$s", new Serializable[]{DB2SQLMethodMapper.getMethodSuffix(db, true), methodName});
    }

    public static Method getSQLMethod(Object methodObject, String methodName, Connection db) throws SQLException, UnsupportedDatabaseException {
        return DB2SQLMethodMapper.getSQLMethod(methodObject.getClass(), methodName, db);
    }
}

