/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.util.client;

import com.dsoft.framework.util.client.Messages;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final String DOT = ".";
    private static DateFormat monthDateFormat = new SimpleDateFormat("MMMM.yyyy");
    private static DateFormat m_shortTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static DateFormat m_weekDayFormat = new SimpleDateFormat("EEEE");
    private static String[] shortMonths = new String[]{Messages.getString("DateUtils.3"), Messages.getString("DateUtils.4"), Messages.getString("DateUtils.5"), Messages.getString("DateUtils.6"), Messages.getString("DateUtils.7"), Messages.getString("DateUtils.8"), Messages.getString("DateUtils.9"), Messages.getString("DateUtils.10"), Messages.getString("DateUtils.11"), Messages.getString("DateUtils.12"), Messages.getString("DateUtils.13"), Messages.getString("DateUtils.14")};
    private static DateFormatSymbols dateSymbols = new DateFormatSymbols();

    public static String getShortDate(int day, int month, int year) {
        Calendar c = Calendar.getInstance();
        c.set(5, day);
        c.set(2, month);
        c.set(1, year);
        return DateUtils.getShortDate(c.getTime());
    }

    public static long getDayBegin(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long getNextDayBegin(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, 1);
        return c.getTimeInMillis();
    }

    public static long getPreviousDayBegin(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, 1);
        c.add(5, -1);
        return c.getTimeInMillis();
    }

    public static long getMonthBegin(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(2, month);
        c.set(1, year);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long getDateMillis(int day, int month, int year) {
        Calendar c = Calendar.getInstance();
        c.set(5, day);
        c.set(2, month);
        c.set(1, year);
        return c.getTimeInMillis();
    }

    public static String getWeekdayString(long date) {
        return DateUtils.getWeekdayString(new Date(date));
    }

    public static String getWeekdayString(Date date) {
        return m_weekDayFormat.format(date);
    }

    public static String getWeekdayString(int day, int month, int year) {
        Calendar c = Calendar.getInstance();
        c.set(5, day);
        c.set(2, month);
        c.set(1, year);
        return DateUtils.getWeekdayString(c.getTime());
    }

    public static String getShortDate(long date) {
        return DateUtils.getShortDate(new Date(date), Messages.getString("DateUtils.1"));
    }

    public static String getShortDate(long date, String format) {
        return DateUtils.getShortDate(new Date(date), format);
    }

    public static String getShortDate(Date date) {
        return DateUtils.getShortDate(date, Messages.getString("DateUtils.1"));
    }

    public static String getShortDate(Date date, String format) {
        SimpleDateFormat shortDateFormat = new SimpleDateFormat(format);
        return shortDateFormat.format(date);
    }

    public static String getShortTime(long time) {
        return DateUtils.getShortTime(new Date(time));
    }

    public static String getShortTime(Date time) {
        return m_shortTimeFormat.format(time);
    }

    public static String getMediumDate(long date) {
        return DateUtils.getMediumDate(new Date(date));
    }

    public static String getMediumDate(Date date) {
        SimpleDateFormat mediumDateFormat = new SimpleDateFormat(Messages.getString("DateUtils.0"));
        return mediumDateFormat.format(date);
    }

    public static String getPeriodString(long begin, long end) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        if (end < begin) {
            begin = end;
        }
        if (begin == end) {
            return DateUtils.getShortDate(begin);
        }
        c1.setTimeInMillis(begin);
        c2.setTimeInMillis(end);
        int d1 = c1.get(5);
        int d2 = c2.get(5);
        int m1 = c1.get(2);
        int m2 = c2.get(2);
        int y1 = c1.get(1);
        int y2 = c2.get(1);
        m2 += (y2 - y1) * 12;
        if (d1 == d2) {
            if (m2 - m1 == 1 && d1 == 1) {
                return DateUtils.getMonthDateFormat(begin);
            }
            return DateUtils.getMonthDateFormat(begin) + " - " + DateUtils.getMonthDateFormat(end - 1L);
        }
        return DateUtils.getShortDate(begin) + " - " + DateUtils.getShortDate(end - 1L);
    }

    public static String getFullPeriodString(long begin, long end) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        if (end < begin) {
            begin = end;
        }
        if (begin == end) {
            return DateUtils.getShortDate(begin);
        }
        c1.setTimeInMillis(begin);
        c2.setTimeInMillis(end);
        int d1 = c1.get(5);
        int d2 = c2.get(5);
        int m1 = c1.get(2);
        int m2 = c2.get(2);
        int y1 = c1.get(1);
        int y2 = c2.get(1);
        m2 += (y2 - y1) * 12;
        if (d1 == d2) {
            if (m2 - m1 == 1 && d1 == 1) {
                return DateUtils.getFullMonthDateFormat(begin);
            }
            return DateUtils.getFullMonthDateFormat(begin) + " - " + DateUtils.getFullMonthDateFormat(end - 1L);
        }
        return DateUtils.getShortDate(begin) + " - " + DateUtils.getShortDate(end - 1L) + Messages.getString("DateUtils.2");
    }

    public static String getMonthDateFormat(long date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        String month = dateSymbols.getShortMonths()[c.get(2)];
        return month + DOT + c.get(1);
    }

    public static String getFullMonthDateFormat(long date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        String month = dateSymbols.getMonths()[c.get(2)];
        month = month + (month.endsWith(DOT) ? "" : DOT) + c.get(1);
        if (c.get(5) != 1) {
            month = c.get(5) + DOT + month;
        }
        return month;
    }

    public static Date parseShortDateFormat(String date) throws ParseException {
        SimpleDateFormat shortDateFormat = new SimpleDateFormat(Messages.getString("DateUtils.1"));
        return shortDateFormat.parse(date);
    }

    static {
        if (Locale.getDefault().getLanguage().equals("bg")) {
            dateSymbols.setShortMonths(shortMonths);
        }
    }
}

