/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.util.client;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceUtil {
    public static Map<String, List<InetAddress>> getInterfaceData() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        HashMap<String, List<InetAddress>> result = new HashMap<String, List<InetAddress>>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            ArrayList<InetAddress> addressList = new ArrayList<InetAddress>();
            List<InterfaceAddress> interfaceAddressList = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : interfaceAddressList) {
                InetAddress address = interfaceAddress.getAddress();
                if (address instanceof Inet6Address) continue;
                addressList.add(address);
            }
            if (addressList.isEmpty()) continue;
            result.put(networkInterface.getDisplayName(), addressList);
        }
        return result;
    }

    public static void main(String[] arg) {
        try {
            Map<String, List<InetAddress>> map = InterfaceUtil.getInterfaceData();
            for (String interfaceName : map.keySet()) {
                for (InetAddress address : map.get(interfaceName)) {
                    System.out.println(interfaceName + ": " + address.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

