/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.framework.util.client;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;

public class StringUtil {
    private static final String UTF_8 = "utf-8";
    private static final String EMPTY_STRING = "";

    public static boolean checkStringLength(String string, int length) throws UnsupportedEncodingException {
        return string.getBytes(UTF_8).length <= length;
    }

    public static String stringToHex(String text, String encoding) throws UnsupportedEncodingException {
        byte[] textAsBytes = text.getBytes(encoding);
        StringBuilder buf = new StringBuilder();
        for (byte textAsByte : textAsBytes) {
            buf.append(String.format("%1$02X", textAsByte));
        }
        return buf.toString();
    }

    public static String subString(String string, int length) throws UnsupportedEncodingException {
        byte[] buffer = string.getBytes(UTF_8);
        if (buffer.length > length) {
            return new String(buffer, 0, length, UTF_8);
        }
        return string;
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return null;
        }
        String result = EMPTY_STRING;
        boolean apostrophe = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                apostrophe = !apostrophe;
            } else if (apostrophe) {
                apostrophe = false;
                result = result + '\'';
            }
            result = result + c;
        }
        if (apostrophe) {
            result = result + '\'';
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static byte[] fillEmptyResult(int length) {
        byte[] res = new byte[length];
        Arrays.fill(res, (byte)32);
        return res;
    }

    public static String formatStringRight(String str, int length, String emptyChar) throws UnsupportedEncodingException {
        if (str.equals(EMPTY_STRING)) {
            return new String(StringUtil.fillEmptyResult(length));
        }
        if (str.length() > length) {
            str = str.substring(0, length);
        }
        while (str.length() < length) {
            str = emptyChar + str;
        }
        return str;
    }

    public static String formatStringLeft(String str, int length, String emptyChar) throws UnsupportedEncodingException {
        if (str.equals(EMPTY_STRING)) {
            return new String(StringUtil.fillEmptyResult(length));
        }
        if (str.length() > length) {
            str = str.substring(0, length);
        }
        while (str.length() < length) {
            str = str + emptyChar;
        }
        return str;
    }

    public static String listToString(Collection<?> list) {
        return StringUtil.listToString(list, ", ");
    }

    public static String listToString(Collection<?> list, String separator) {
        StringBuilder builder = new StringBuilder();
        for (Object value : list) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(value.toString());
        }
        return builder.toString();
    }

    private static DecomposedNumber decomposeNumber(String num) {
        int i;
        if (StringUtil.isEmpty(num)) {
            return null;
        }
        DecomposedNumber n = new DecomposedNumber();
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < num.length() && !Character.isDigit(num.charAt(i)); ++i) {
            buf.append(num.charAt(i));
        }
        n.prefix = buf.toString();
        buf = new StringBuilder();
        for (i = 0; i < num.length() && Character.isDigit(num.charAt(i)); ++i) {
            buf.append(num.charAt(i));
        }
        if (buf.length() > 0) {
            n.num = Integer.parseInt(buf.toString());
        }
        buf = new StringBuilder();
        while (i < num.length()) {
            buf.append(num.charAt(i));
            ++i;
        }
        n.suffix = buf.toString();
        return n;
    }

    public static int compareNumbers(String numberOne, String numberTwo) {
        DecomposedNumber n1 = StringUtil.decomposeNumber(numberOne);
        DecomposedNumber n2 = StringUtil.decomposeNumber(numberTwo);
        if (n1 == null) {
            if (n2 == null) {
                return 0;
            }
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        return n1.compareTo(n2);
    }

    private static class DecomposedNumber
    implements Comparable<DecomposedNumber> {
        int num = Integer.MIN_VALUE;
        String suffix;
        String prefix;

        private DecomposedNumber() {
        }

        @Override
        public int compareTo(DecomposedNumber o) {
            int result = this.prefix.compareTo(o.prefix);
            if (result == 0) {
                result = Integer.compare(this.num, o.num);
            }
            return result == 0 ? this.suffix.compareTo(o.suffix) : result;
        }
    }
}

