/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.address.client;

import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.address.client.Messages;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.address.client.dto.CityDTO;
import com.dsoft.powerpro.address.client.dto.StreetDTO;

public class AddressUtils {
    private static final String NEW_LINE = "\n";
    private static final String EMPTY_STR = "";
    private static final String SPACE = " ";
    private static final String COMA = ", ";

    public static String getShortStreetType(String type) {
        switch (type.charAt(0)) {
            case 'U': {
                return Messages.getString("AddressUtils.10");
            }
            case 'B': {
                return Messages.getString("AddressUtils.11");
            }
            case 'P': {
                return Messages.getString("AddressUtils.12");
            }
        }
        return EMPTY_STR;
    }

    public static String getShortAddressString(AddressDTO dto) {
        return AddressUtils.getShortAddressString(dto, false);
    }

    public static String getShortAddressString(AddressDTO dto, boolean showAddrNotes) {
        try {
            StringBuilder buf = new StringBuilder();
            if (dto != null && dto.getCityDto() != null) {
                if (!StringUtil.isEmpty(dto.getCityDto().getName())) {
                    buf.append(Messages.getString("AddressUtils.1"));
                    buf.append(dto.getCityDto().getName());
                    buf.append(' ');
                }
                if (!StringUtil.isEmpty(dto.getPoBox())) {
                    buf.append(Messages.getString("AddressUtils.9"));
                    buf.append(dto.getPoBox());
                } else {
                    if (!StringUtil.isEmpty(dto.getDistrict())) {
                        buf.append(Messages.getString("AddressUtils.4"));
                        buf.append(dto.getDistrict());
                        buf.append(COMA);
                    }
                    if (dto.getStreetId() != null) {
                        StreetDTO streetDto = dto.getStreetDto();
                        buf.append(AddressUtils.getShortStreetType(streetDto.getStreetType())).append('.');
                        buf.append(streetDto.getName());
                        if (!StringUtil.isEmpty(dto.getStreetNo())) {
                            buf.append(Messages.getString("AddressUtils.16"));
                            buf.append(dto.getStreetNo());
                        }
                        buf.append(COMA);
                    }
                    if (!StringUtil.isEmpty(dto.getBlockNumber())) {
                        buf.append(Messages.getString("AddressUtils.5"));
                        buf.append(dto.getBlockNumber());
                        buf.append(COMA);
                    }
                    if (!StringUtil.isEmpty(dto.getEntranceNo())) {
                        buf.append(Messages.getString("AddressUtils.6"));
                        buf.append(dto.getEntranceNo());
                        buf.append(COMA);
                    }
                    if (!StringUtil.isEmpty(dto.getFloor())) {
                        buf.append(Messages.getString("AddressUtils.8"));
                        buf.append(dto.getFloor());
                        buf.append(COMA);
                    }
                    if (!StringUtil.isEmpty(dto.getRoomNumber())) {
                        buf.append(Messages.getString("AddressUtils.7"));
                        buf.append(dto.getRoomNumber());
                        buf.append(COMA);
                    }
                    if (showAddrNotes && !StringUtil.isEmpty(dto.getStrAddress())) {
                        buf.append(dto.getStrAddress());
                    }
                }
            }
            return buf.toString();
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getGoogleAddress(AddressDTO dto) {
        try {
            StringBuilder buf = new StringBuilder();
            if (dto != null && dto.getCityDto() != null) {
                if (!StringUtil.isEmpty(dto.getPoBox())) {
                    buf.append(Messages.getString("AddressUtils.9"));
                    buf.append(dto.getPoBox());
                } else {
                    if (!StringUtil.isEmpty(dto.getDistrict())) {
                        buf.append(Messages.getString("AddressUtils.4"));
                        buf.append(dto.getDistrict());
                        buf.append(SPACE);
                    }
                    if (dto.getStreetId() != null) {
                        StreetDTO streetDto = dto.getStreetDto();
                        buf.append(AddressUtils.getShortStreetType(streetDto.getStreetType())).append('.');
                        buf.append(streetDto.getName());
                        if (!StringUtil.isEmpty(dto.getStreetNo())) {
                            buf.append(SPACE);
                            buf.append(dto.getStreetNo());
                        }
                        buf.append(COMA);
                    }
                    if (!StringUtil.isEmpty(dto.getBlockNumber())) {
                        buf.append(dto.getBlockNumber());
                    }
                    if (!StringUtil.isEmpty(dto.getCityDto().getName())) {
                        buf.append(dto.getCityDto().getName());
                        buf.append(COMA);
                    }
                    if (!StringUtil.isEmpty(dto.getCityDto().getMunicipality().getRegion().getCountry().getName())) {
                        buf.append(dto.getCityDto().getMunicipality().getRegion().getCountry().getName());
                    }
                }
            }
            return buf.toString();
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getMediumAddressString(AddressDTO dto) {
        return AddressUtils.getMediumAddressString(dto, false);
    }

    public static String getMediumAddressString(AddressDTO dto, boolean appendAddrNotes) {
        try {
            StringBuilder buf = new StringBuilder();
            if (dto != null && dto.getCityId() != null) {
                buf.append(Messages.getString("AddressUtils.1"));
                buf.append(dto.getCityDto().getName());
                buf.append(',');
                buf.append(AddressUtils.getAddressStringForPayment(dto, appendAddrNotes));
            }
            return buf.toString();
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getAddressStringForPayment(AddressDTO dto) {
        return AddressUtils.getAddressStringForPayment(dto, false);
    }

    public static String getAddressStringForPayment(AddressDTO dto, boolean appendAddrNotes) {
        StringBuilder buf = new StringBuilder();
        if (!StringUtil.isEmpty(dto.getDistrict())) {
            buf.append(Messages.getString("AddressUtils.4"));
            buf.append(dto.getDistrict());
            buf.append(',');
        }
        buf.append(AddressUtils.getVeryShortAddressString(dto, appendAddrNotes));
        return buf.toString();
    }

    public static String getVeryShortAddressString(AddressDTO dto) {
        return AddressUtils.getVeryShortAddressString(dto, false);
    }

    public static String getVeryShortAddressString(AddressDTO dto, boolean appendAddrNotes) {
        try {
            StringBuilder buf = new StringBuilder();
            if (!StringUtil.isEmpty(dto.getPoBox())) {
                buf.append(Messages.getString("AddressUtils.9"));
                buf.append(dto.getPoBox());
            } else {
                AddressUtils.appendStreet(dto, buf);
                if (!StringUtil.isEmpty(dto.getBlockNumber())) {
                    buf.append(Messages.getString("AddressUtils.13"));
                    buf.append(dto.getBlockNumber());
                    buf.append(',');
                }
                if (!StringUtil.isEmpty(dto.getEntranceNo())) {
                    buf.append(Messages.getString("AddressUtils.6"));
                    buf.append(dto.getEntranceNo());
                    buf.append(',');
                }
                if (!StringUtil.isEmpty(dto.getFloor())) {
                    buf.append(Messages.getString("AddressUtils.14"));
                    buf.append(dto.getFloor());
                    buf.append(',');
                }
                if (!StringUtil.isEmpty(dto.getRoomNumber())) {
                    buf.append(Messages.getString("AddressUtils.15"));
                    buf.append(dto.getRoomNumber());
                    buf.append(',');
                }
                if (appendAddrNotes && !StringUtil.isEmpty(dto.getStrAddress())) {
                    buf.append(dto.getStrAddress());
                }
            }
            return buf.toString();
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void appendStreet(AddressDTO dto, StringBuilder buf) throws DTOFindException {
        if (dto.getStreetId() != null) {
            StreetDTO streetDto = dto.getStreetDto();
            buf.append(AddressUtils.getShortStreetType(streetDto.getStreetType())).append('.');
            buf.append(streetDto.getName());
            if (!StringUtil.isEmpty(dto.getStreetNo())) {
                buf.append(Messages.getString("AddressUtils.16"));
                buf.append(dto.getStreetNo());
            }
            buf.append(',');
        }
    }

    public static String getFullAddressString(AddressDTO dto) {
        try {
            StringBuilder buf = new StringBuilder();
            CityDTO cityDto = dto.getCityDto();
            buf.append(Messages.getString("AddressUtils.0"));
            buf.append(cityDto.getMunicipality().getRegion().getName());
            buf.append(SPACE).append(Messages.getString("AddressUtils.2"));
            buf.append(cityDto.getMunicipality().getName());
            buf.append(SPACE).append(Messages.getString("AddressUtils.1"));
            buf.append(cityDto.getName());
            if (!StringUtil.isEmpty(dto.getPostalCode())) {
                buf.append(Messages.getString("AddressUtils.3"));
                buf.append(dto.getPostalCode());
            }
            buf.append(NEW_LINE);
            if (!StringUtil.isEmpty(dto.getPoBox())) {
                buf.append(Messages.getString("AddressUtils.9"));
                buf.append(dto.getPoBox());
            } else {
                if (!StringUtil.isEmpty(dto.getDistrict())) {
                    buf.append(Messages.getString("AddressUtils.4"));
                    buf.append(dto.getDistrict());
                    buf.append(COMA);
                }
                AddressUtils.appendStreet(dto, buf);
                buf.append(NEW_LINE);
                if (!StringUtil.isEmpty(dto.getBlockNumber())) {
                    buf.append(Messages.getString("AddressUtils.5")).append(SPACE);
                    buf.append(dto.getBlockNumber());
                    buf.append(COMA);
                }
                if (!StringUtil.isEmpty(dto.getEntranceNo())) {
                    buf.append(Messages.getString("AddressUtils.6"));
                    buf.append(dto.getEntranceNo());
                    buf.append(COMA);
                }
                if (!StringUtil.isEmpty(dto.getFloor())) {
                    buf.append(Messages.getString("AddressUtils.8"));
                    buf.append(dto.getFloor());
                    buf.append(COMA);
                }
                if (!StringUtil.isEmpty(dto.getRoomNumber())) {
                    buf.append(Messages.getString("AddressUtils.7"));
                    buf.append(dto.getRoomNumber());
                    buf.append(COMA);
                }
            }
            return buf.toString();
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
    }
}

